/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc;

import java.sql.SQLException;
import java.sql.SQLNonTransientException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.firebirdsql.gds.ng.fields.RowValue;
import org.firebirdsql.jdbc.CompletionReason;
import org.firebirdsql.jdbc.FBFetcher;
import org.firebirdsql.jdbc.FBObjectListener;
import org.firebirdsql.jdbc.FetchConfig;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
final class FBUpdatableFetcher
implements FBFetcher {
    private final FBFetcher fetcher;
    private final RowValue deletedRowMarker;
    private FBObjectListener.FetcherListener fetcherListener;
    private Map<Integer, RowValue> modifiedRows = new HashMap<Integer, RowValue>();
    private int position;
    private List<RowValue> insertedRows = new ArrayList<RowValue>();
    private int firstInsertPosition;
    private int fetcherSize = -1;
    private final InternalFetcherListener rowListener = new InternalFetcherListener();

    FBUpdatableFetcher(FBFetcher fetcher, FBObjectListener.FetcherListener fetcherListener, RowValue deletedRowMarker) {
        if (!deletedRowMarker.isDeletedRowMarker()) {
            throw new IllegalArgumentException("deletedRowMarker should return true for isDeletedRowMarker()");
        }
        this.fetcher = fetcher;
        fetcher.setFetcherListener(this.rowListener);
        this.fetcherListener = fetcherListener;
        this.deletedRowMarker = deletedRowMarker;
    }

    @Override
    public FetchConfig getFetchConfig() {
        return this.fetcher.getFetchConfig();
    }

    @Override
    public void setReadOnly() throws SQLException {
        throw new SQLNonTransientException("This fetcher implementation cannot be marked read-only", "HY024");
    }

    private boolean notifyFetcherRow(int position) throws SQLException {
        return this.notifyRow(position, this.rowListener.lastReceivedRow);
    }

    private boolean notifyInsertedRow(int position) throws SQLException {
        int insertPosition = this.insertPosition(position);
        RowValue rowValue = insertPosition < this.insertedRows.size() ? this.insertedRows.get(insertPosition) : null;
        return this.notifyRow(position, rowValue);
    }

    private boolean notifyRow(int position, @Nullable RowValue originalRowValue) throws SQLException {
        RowValue rowValue = this.modifiedRows.getOrDefault(position, originalRowValue);
        this.fetcherListener.rowChanged(this.fetcher, rowValue);
        return rowValue != null;
    }

    private int insertPosition(int position) throws SQLException {
        int firstInsertPosition = this.firstInsertPosition();
        if (position < firstInsertPosition) {
            throw new SQLException(String.format("Implementation error: %d is not a valid insert-position (minimum: %d)", position, firstInsertPosition));
        }
        return position - this.firstInsertPosition();
    }

    private int firstInsertPosition() throws SQLException {
        int firstInsertPosition = this.firstInsertPosition;
        if (firstInsertPosition == 0) {
            this.firstInsertPosition = this.fetcherSize() + 1;
            return this.firstInsertPosition;
        }
        return firstInsertPosition;
    }

    private int fetcherSize() throws SQLException {
        int fetcherSize = this.fetcherSize;
        if (fetcherSize == -1) {
            this.fetcherSize = this.fetcher.size();
            return this.fetcherSize;
        }
        return fetcherSize;
    }

    private int cappedPosition(int position) throws SQLException {
        return Math.max(0, Math.min(this.size() + 1, position));
    }

    @Override
    public boolean first() throws SQLException {
        this.position = 1;
        return this.fetcher.first() ? this.notifyFetcherRow(1) : this.notifyInsertedRow(1);
    }

    @Override
    public boolean last() throws SQLException {
        if (this.insertedRows.isEmpty()) {
            this.fetcher.last();
            int position = this.position = this.fetcher.currentPosition();
            return this.notifyFetcherRow(position);
        }
        int position = this.position = this.size();
        this.fetcher.afterLast();
        return this.notifyInsertedRow(position);
    }

    @Override
    public boolean previous() throws SQLException {
        this.position = this.cappedPosition(this.position - 1);
        int position = this.position;
        if (position <= this.fetcherSize()) {
            this.fetcher.previous();
            assert (position == this.fetcher.currentPosition()) : "Position discrepancy: " + position + " <> " + this.fetcher.currentPosition();
            return this.notifyFetcherRow(position);
        }
        this.fetcher.afterLast();
        return this.notifyInsertedRow(position);
    }

    @Override
    public boolean next() throws SQLException {
        this.position = this.cappedPosition(this.position + 1);
        int position = this.position;
        if (position <= this.fetcherSize()) {
            this.fetcher.next();
            assert (position == this.fetcher.currentPosition()) : "Position discrepancy: " + position + " <> " + this.fetcher.currentPosition();
            return this.notifyFetcherRow(position);
        }
        this.fetcher.afterLast();
        return this.notifyInsertedRow(position);
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        int position = row >= 0 ? this.cappedPosition(row) : this.cappedPosition(this.size() + 1 + row);
        return this.internalAbsolute(position);
    }

    private boolean internalAbsolute(int position) throws SQLException {
        this.position = position;
        if (position <= this.fetcherSize()) {
            this.fetcher.absolute(position);
            return this.notifyFetcherRow(position);
        }
        this.fetcher.afterLast();
        return this.notifyInsertedRow(position);
    }

    @Override
    public boolean relative(int row) throws SQLException {
        int position = this.cappedPosition(this.position + row);
        return this.internalAbsolute(position);
    }

    @Override
    public void beforeFirst() throws SQLException {
        this.position = 0;
        this.fetcher.beforeFirst();
        this.notifyFetcherRow(0);
    }

    @Override
    public void afterLast() throws SQLException {
        int position = this.position = this.size() + 1;
        this.fetcher.afterLast();
        this.notifyFetcherRow(position);
    }

    @Override
    public void close() throws SQLException {
        this.close(CompletionReason.OTHER);
    }

    @Override
    public void close(CompletionReason completionReason) throws SQLException {
        try {
            this.fetcher.close(completionReason);
        }
        finally {
            this.modifiedRows.clear();
            this.modifiedRows = Collections.emptyMap();
            this.insertedRows.clear();
            this.insertedRows = Collections.emptyList();
        }
    }

    @Override
    public boolean isClosed() {
        return this.fetcher.isClosed();
    }

    @Override
    public int getRowNum() throws SQLException {
        int position = this.position;
        return position <= this.size() ? position : 0;
    }

    @Override
    public boolean isEmpty() throws SQLException {
        return this.size() == 0;
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        return this.position == 0;
    }

    @Override
    public boolean isFirst() throws SQLException {
        return this.position == 1 && !this.isEmpty();
    }

    @Override
    public boolean isLast() throws SQLException {
        int size = this.size();
        return this.position == size && size > 0;
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        return this.position > this.size();
    }

    @Override
    public void beforeExecuteInsert() throws SQLException {
        this.fetcher.beforeExecuteInsert();
    }

    @Override
    public void insertRow(RowValue data) throws SQLException {
        this.insertedRows.add(data);
        this.fetcherListener.rowChanged(this, data);
    }

    @Override
    public void deleteRow() throws SQLException {
        this.modifiedRows.put(this.position, this.deletedRowMarker);
        this.fetcherListener.rowChanged(this, this.deletedRowMarker);
    }

    @Override
    public void updateRow(RowValue data) throws SQLException {
        this.modifiedRows.put(this.position, data);
        this.fetcherListener.rowChanged(this, data);
    }

    @Override
    public void renotifyCurrentRow() throws SQLException {
        int position = this.position;
        if (position <= this.fetcherSize()) {
            this.notifyFetcherRow(position);
        } else {
            this.notifyInsertedRow(position);
        }
    }

    @Override
    public int getFetchSize() throws SQLException {
        return this.fetcher.getFetchSize();
    }

    @Override
    public void setFetchSize(int fetchSize) throws SQLException {
        this.fetcher.setFetchSize(fetchSize);
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return this.fetcher.getFetchDirection();
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this.fetcher.setFetchDirection(direction);
    }

    @Override
    public int currentPosition() {
        return this.position;
    }

    @Override
    public int size() throws SQLException {
        return this.fetcherSize() + this.insertedRows.size();
    }

    @Override
    public void setFetcherListener(FBObjectListener.FetcherListener fetcherListener) {
        this.fetcherListener = fetcherListener;
    }

    @Override
    public boolean rowInserted() throws SQLException {
        return !this.isBeforeFirst() && !this.isAfterLast() && this.firstInsertPosition() <= this.position;
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        if (this.isBeforeFirst() || this.isAfterLast()) {
            return false;
        }
        RowValue rowValue = this.modifiedRows.get(this.position);
        return rowValue != null && !rowValue.isDeletedRowMarker();
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        if (this.isBeforeFirst() || this.isAfterLast()) {
            return false;
        }
        RowValue rowValue = this.modifiedRows.get(this.position);
        return rowValue != null && rowValue.isDeletedRowMarker();
    }

    private static final class InternalFetcherListener
    implements FBObjectListener.FetcherListener {
        @Nullable RowValue lastReceivedRow;

        private InternalFetcherListener() {
        }

        @Override
        public void rowChanged(FBFetcher fetcher, @Nullable RowValue newRow) {
            this.lastReceivedRow = newRow;
        }
    }
}

