/*
 * Decompiled with CFR 0.152.
 */
package us.fatehi.utility.datasource;

import java.sql.Connection;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sql.DataSource;
import us.fatehi.utility.datasource.ConnectionDatabaseConnectionSource;
import us.fatehi.utility.datasource.DataSourceConnectionSource;
import us.fatehi.utility.datasource.DatabaseConnectionSource;
import us.fatehi.utility.datasource.SimpleDatabaseConnectionSource;
import us.fatehi.utility.datasource.SingleDatabaseConnectionSource;
import us.fatehi.utility.datasource.UserCredentials;
import us.fatehi.utility.readconfig.SystemPropertiesConfig;

public class DatabaseConnectionSources {
    private static final Logger LOGGER = Logger.getLogger(DatabaseConnectionSources.class.getName());

    public static DatabaseConnectionSource fromConnection(Connection connection) {
        return new ConnectionDatabaseConnectionSource(connection);
    }

    public static DatabaseConnectionSource fromDataSource(DataSource dataSource) {
        return new DataSourceConnectionSource(dataSource);
    }

    public static DatabaseConnectionSource newDatabaseConnectionSource(String connectionUrl, Set<String> additionalDriverProperties, Map<String, String> connectionProperties, UserCredentials userCredentials, Consumer<Connection> connectionInitializer) {
        boolean isSingleThreaded = new SystemPropertiesConfig().getBooleanValue("SC_SINGLE_THREADED");
        if (isSingleThreaded) {
            LOGGER.log(Level.CONFIG, "Loading database schema in the main thread");
            return new SingleDatabaseConnectionSource(connectionUrl, additionalDriverProperties, connectionProperties, userCredentials, connectionInitializer);
        }
        LOGGER.log(Level.CONFIG, "Loading database schema using multiple threads");
        return new SimpleDatabaseConnectionSource(connectionUrl, additionalDriverProperties, connectionProperties, userCredentials, connectionInitializer);
    }

    public static DatabaseConnectionSource newDatabaseConnectionSource(String connectionUrl, UserCredentials userCredentials) {
        return DatabaseConnectionSources.newDatabaseConnectionSource(connectionUrl, null, null, userCredentials, connection -> {});
    }

    private DatabaseConnectionSources() {
    }
}

