/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.ermodel.utility;

import java.util.Objects;
import schemacrawler.ermodel.implementation.ERModelBuilder;
import schemacrawler.ermodel.implementation.TableEntityModelInferrer;
import schemacrawler.ermodel.model.ERModel;
import schemacrawler.ermodel.model.EntityType;
import schemacrawler.ermodel.model.RelationshipCardinality;
import schemacrawler.schema.Catalog;
import schemacrawler.schema.Table;
import schemacrawler.schema.TableReference;
import schemacrawler.utility.MetaDataUtility;
import us.fatehi.utility.OptionalBoolean;

public class EntityModelUtility {
    public static ERModel buildERModel(Catalog catalog) {
        Objects.requireNonNull(catalog, "No catalog provided");
        return new ERModelBuilder(catalog).build();
    }

    public static OptionalBoolean coveredByIndex(TableReference fk) {
        if (fk == null) {
            return OptionalBoolean.unknown;
        }
        Table table = fk.getForeignKeyTable();
        if (table == null || MetaDataUtility.isPartial(table)) {
            return OptionalBoolean.unknown;
        }
        TableEntityModelInferrer tableEntityModel = new TableEntityModelInferrer(table);
        OptionalBoolean coveredByIndex = tableEntityModel.coveredByIndex(fk);
        return coveredByIndex;
    }

    public static OptionalBoolean coveredByUniqueIndex(TableReference fk) {
        if (fk == null) {
            return OptionalBoolean.unknown;
        }
        Table table = fk.getForeignKeyTable();
        if (table == null || MetaDataUtility.isPartial(table)) {
            return OptionalBoolean.unknown;
        }
        TableEntityModelInferrer tableEntityModel = new TableEntityModelInferrer(table);
        OptionalBoolean coveredByIndex = tableEntityModel.coveredByUniqueIndex(fk);
        return coveredByIndex;
    }

    public static OptionalBoolean inferBridgeTable(Table table) {
        if (table == null || MetaDataUtility.isPartial(table)) {
            return OptionalBoolean.unknown;
        }
        TableEntityModelInferrer tableEntityModel = new TableEntityModelInferrer(table);
        boolean isBridgeTable = tableEntityModel.inferBridgeTable();
        return OptionalBoolean.fromBoolean(isBridgeTable);
    }

    public static RelationshipCardinality inferCardinality(TableReference fk) {
        if (fk == null) {
            return RelationshipCardinality.unknown;
        }
        Table table = fk.getForeignKeyTable();
        if (table == null || MetaDataUtility.isPartial(table)) {
            return RelationshipCardinality.unknown;
        }
        TableEntityModelInferrer tableEntityModel = new TableEntityModelInferrer(table);
        RelationshipCardinality fkCardinality = tableEntityModel.inferCardinality(fk);
        return fkCardinality;
    }

    public static EntityType inferEntityType(Table table) {
        if (table == null || MetaDataUtility.isPartial(table)) {
            return EntityType.unknown;
        }
        TableEntityModelInferrer tableEntityModel = new TableEntityModelInferrer(table);
        EntityType entityType = tableEntityModel.inferEntityType();
        return entityType;
    }

    private EntityModelUtility() {
    }
}

