/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.utils;

import java.util.List;
import java.util.Locale;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.action.admin.indices.stats.IndicesStatsRequest;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.cluster.health.ClusterIndexHealth;
import org.opensearch.cluster.metadata.IndexAbstraction;
import org.opensearch.cluster.metadata.IndexMetadata;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.common.xcontent.LoggingDeprecationHandler;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.DeprecationHandler;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.index.query.BoolQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.transport.client.Client;

public class IndexUtils {
    public static final String NONEXISTENT_INDEX_STATUS = "non-existent";
    public static final String ALIAS_EXISTS_NO_INDICES_STATUS = "alias exists, but does not point to any indices";
    private Client client;
    private ClusterService clusterService;

    @Inject
    public IndexUtils(Client client, ClusterService clusterService) {
        this.client = client;
        this.clusterService = clusterService;
    }

    public String getIndexHealthStatus(String indexOrAliasName) throws IllegalArgumentException {
        if (!this.clusterService.state().getRoutingTable().hasIndex(indexOrAliasName)) {
            if (this.clusterService.state().metadata().hasAlias(indexOrAliasName)) {
                List indexMetaDataList = ((IndexAbstraction)this.clusterService.state().metadata().getIndicesLookup().get(indexOrAliasName)).getIndices();
                if (indexMetaDataList.size() == 0) {
                    return ALIAS_EXISTS_NO_INDICES_STATUS;
                }
                if (indexMetaDataList.size() > 1) {
                    throw new IllegalArgumentException("Cannot get health for alias that points to multiple indices");
                }
                indexOrAliasName = ((IndexMetadata)indexMetaDataList.get(0)).getIndex().getName();
            } else {
                return NONEXISTENT_INDEX_STATUS;
            }
        }
        ClusterIndexHealth indexHealth = new ClusterIndexHealth(this.clusterService.state().metadata().index(indexOrAliasName), this.clusterService.state().getRoutingTable().index(indexOrAliasName));
        return indexHealth.getStatus().name().toLowerCase(Locale.ROOT);
    }

    public void getNumberOfDocumentsInIndex(String indexName, ActionListener<Long> listener) {
        if (this.clusterService.state().getRoutingTable().hasIndex(indexName)) {
            IndicesStatsRequest indicesStatsRequest = new IndicesStatsRequest();
            indicesStatsRequest.indices(new String[]{indexName});
            this.client.admin().indices().stats(indicesStatsRequest, ActionListener.wrap(r -> {
                long count = r.getIndex((String)indexName).getPrimaries().docs.getCount();
                listener.onResponse((Object)count);
            }, e -> listener.onFailure(e)));
        } else {
            listener.onResponse((Object)0L);
        }
    }

    public void getNumberOfDocumentsInIndex(String indexName, String searchQuery, NamedXContentRegistry xContentRegistry, ActionListener<Long> listener) {
        block9: {
            if (this.clusterService.state().getRoutingTable().hasIndex(indexName)) {
                try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
                    SearchRequest searchRequest = new SearchRequest();
                    XContentParser parser = XContentType.JSON.xContent().createParser(xContentRegistry, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, searchQuery);
                    SearchSourceBuilder builder = SearchSourceBuilder.fromXContent((XContentParser)parser);
                    builder.fetchSource(false);
                    searchRequest.source(builder).indices(new String[]{indexName});
                    this.client.search(searchRequest, ActionListener.runBefore((ActionListener)ActionListener.wrap(r -> {
                        long count = r.getHits().getTotalHits().value();
                        listener.onResponse((Object)count);
                    }, e -> listener.onFailure(e)), () -> context.restore()));
                    break block9;
                }
                catch (Exception e2) {
                    throw new OpenSearchStatusException("Failed to search index " + indexName, RestStatus.BAD_REQUEST, new Object[0]);
                }
            }
            listener.onResponse((Object)0L);
        }
    }

    public static SearchRequest buildHiddenModelSearchRequest() {
        SearchRequest searchRequest = new SearchRequest(new String[]{".plugins-ml-model"});
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        boolQueryBuilder.filter((QueryBuilder)QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.termQuery((String)"is_hidden", (boolean)true)).mustNot((QueryBuilder)QueryBuilders.existsQuery((String)"chunk_number")));
        searchRequest.source().query((QueryBuilder)boolQueryBuilder);
        searchRequest.source().fetchSource(new String[]{"_id"}, new String[0]);
        return searchRequest;
    }
}

