/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.classification.evaluation;

import java.util.ArrayList;
import java.util.List;
import org.tribuo.classification.Label;
import org.tribuo.classification.evaluation.ClassifierEvaluation;
import org.tribuo.classification.evaluation.ConfusionMatrix;
import org.tribuo.classification.evaluation.LabelEvaluationUtil;

public interface LabelEvaluation
extends ClassifierEvaluation<Label> {
    public double accuracy();

    public double accuracy(Label var1);

    public double AUCROC(Label var1);

    public double averageAUCROC(boolean var1);

    public double averagedPrecision(Label var1);

    public LabelEvaluationUtil.PRCurve precisionRecallCurve(Label var1);

    default public String toHTML() {
        return LabelEvaluation.toHTML(this);
    }

    public static String toFormattedString(LabelEvaluation evaluation) {
        ConfusionMatrix<Label> cm = evaluation.getConfusionMatrix();
        ArrayList labelOrder = new ArrayList(cm.getLabelOrder());
        labelOrder.retainAll(cm.observed());
        StringBuilder sb = new StringBuilder();
        int tp = 0;
        int fn = 0;
        int fp = 0;
        int n = 0;
        int maxLabelSize = "Balanced Error Rate".length();
        for (Label label : labelOrder) {
            maxLabelSize = Math.max(maxLabelSize, label.getLabel().length());
        }
        String labelFormatString = String.format("%%-%ds", maxLabelSize + 2);
        sb.append(String.format(labelFormatString, "Class"));
        sb.append(String.format("%12s%12s%12s%12s", "n", "tp", "fn", "fp"));
        sb.append(String.format("%12s%12s%12s%n", "recall", "prec", "f1"));
        for (Label label : labelOrder) {
            if (cm.support(label) == 0.0) continue;
            n = (int)((double)n + cm.support(label));
            tp = (int)((double)tp + cm.tp(label));
            fn = (int)((double)fn + cm.fn(label));
            fp = (int)((double)fp + cm.fp(label));
            sb.append(String.format(labelFormatString, label));
            sb.append(String.format("%,12d%,12d%,12d%,12d", (int)cm.support(label), (int)cm.tp(label), (int)cm.fn(label), (int)cm.fp(label)));
            sb.append(String.format("%12.3f%12.3f%12.3f%n", evaluation.recall(label), evaluation.precision(label), evaluation.f1(label)));
        }
        sb.append(String.format(labelFormatString, "Total"));
        sb.append(String.format("%,12d%,12d%,12d%,12d%n", n, tp, fn, fp));
        sb.append(String.format(labelFormatString, "Accuracy"));
        sb.append(String.format("%60.3f%n", evaluation.accuracy()));
        sb.append(String.format(labelFormatString, "Micro Average"));
        sb.append(String.format("%60.3f%12.3f%12.3f%n", evaluation.microAveragedRecall(), evaluation.microAveragedPrecision(), evaluation.microAveragedF1()));
        sb.append(String.format(labelFormatString, "Macro Average"));
        sb.append(String.format("%60.3f%12.3f%12.3f%n", evaluation.macroAveragedRecall(), evaluation.macroAveragedPrecision(), evaluation.macroAveragedF1()));
        sb.append(String.format(labelFormatString, "Balanced Error Rate"));
        sb.append(String.format("%60.3f", evaluation.balancedErrorRate()));
        return sb.toString();
    }

    public static String toHTML(LabelEvaluation evaluation) {
        ConfusionMatrix<Label> cm = evaluation.getConfusionMatrix();
        List labelOrder = cm.getLabelOrder();
        StringBuilder sb = new StringBuilder();
        int tp = 0;
        int fn = 0;
        int fp = 0;
        int tn = 0;
        sb.append("<table>\n");
        sb.append("<tr>\n");
        sb.append("<th>Class</th><th>n</th> <th>%</th> <th>tp</th> <th>fn</th> <th>fp</th> <th>Recall</th> <th>Precision</th> <th>F1</th>");
        sb.append("\n</tr>\n");
        for (Label label : labelOrder) {
            tn = (int)((double)tn + cm.tn(label));
        }
        for (Label label : labelOrder) {
            if (cm.support(label) == 0.0) continue;
            tp = (int)((double)tp + cm.tp(label));
            fn = (int)((double)fn + cm.fn(label));
            fp = (int)((double)fp + cm.fp(label));
            sb.append("<tr>");
            sb.append("<td><code>").append(label).append("</code></td>");
            int occurrence = (int)cm.support(label);
            sb.append("<td style=\"text-align:right\">").append(String.format("%,d", occurrence)).append("</td>");
            sb.append("<td style=\"text-align:right\">").append(String.format("%8.1f%%", (double)occurrence / (double)tn * 100.0)).append("</td>");
            sb.append("<td style=\"text-align:right\">").append(String.format("%,d", (int)cm.tp(label))).append("</td>");
            sb.append("<td style=\"text-align:right\">").append(String.format("%,d", (int)cm.fn(label))).append("</td>");
            sb.append("<td style=\"text-align:right\">").append(String.format("%,d", (int)cm.fp(label))).append("</td>");
            sb.append(String.format("<td style=\"text-align:right\">%8.3f</td><td style=\"text-align:right\">%8.3f</td><td style=\"text-align:right\">%8.3f</td>%n", evaluation.recall(label), evaluation.precision(label), evaluation.f1(label)));
            sb.append("</tr>");
        }
        sb.append("<tr>");
        sb.append("<td>Total</td>");
        sb.append(String.format("<td style=\"text-align:right\">%,12d</td><td style=\"text-align:right\"></td><td style=\"text-align:right\">%,12d</td><td style=\"text-align:right\">%,12d</td><td style=\"text-align:right\">%,12d</td>%n", tn, tp, fn, fp));
        sb.append("<td colspan=\"4\"></td>");
        sb.append("</tr>\n<tr>");
        sb.append(String.format("<td>Accuracy</td><td style=\"text-align:right\" colspan=\"6\">%8.3f</td>%n", evaluation.accuracy()));
        sb.append("<td colspan=\"4\"></td>");
        sb.append("</tr>\n<tr>");
        sb.append("<td>Micro Average</td>");
        sb.append(String.format("<td style=\"text-align:right\" colspan=\"6\">%8.3f</td><td style=\"text-align:right\">%8.3f</td><td style=\"text-align:right\">%8.3f</td>%n", evaluation.microAveragedRecall(), evaluation.microAveragedPrecision(), evaluation.microAveragedF1()));
        sb.append("</tr></table>");
        return sb.toString();
    }
}

