/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.classification.ensemble;

import com.oracle.labs.mlrg.olcut.config.Option;
import com.oracle.labs.mlrg.olcut.config.Options;
import java.util.logging.Logger;
import org.tribuo.Trainer;
import org.tribuo.classification.Label;
import org.tribuo.classification.ensemble.AdaBoostTrainer;
import org.tribuo.classification.ensemble.VotingCombiner;
import org.tribuo.common.tree.DecisionTreeTrainer;
import org.tribuo.common.tree.ExtraTreesTrainer;
import org.tribuo.common.tree.RandomForestTrainer;
import org.tribuo.ensemble.BaggingTrainer;
import org.tribuo.ensemble.EnsembleCombiner;

public class ClassificationEnsembleOptions
implements Options {
    private static final Logger logger = Logger.getLogger(ClassificationEnsembleOptions.class.getName());
    @Option(longName="ensemble-type", usage="Ensemble method, options are {ADABOOST, BAGGING, RF}.")
    public EnsembleType type = EnsembleType.BAGGING;
    @Option(longName="ensemble-size", usage="Number of base learners in the ensemble.")
    public int ensembleSize = -1;
    @Option(longName="ensemble-seed", usage="RNG seed.")
    public long seed = 12345L;

    public Trainer<Label> wrapTrainer(Trainer<Label> trainer) {
        if (this.ensembleSize > 0 && this.type != null) {
            switch (this.type) {
                case ADABOOST: {
                    logger.info("Using Adaboost with " + this.ensembleSize + " members.");
                    return new AdaBoostTrainer(trainer, this.ensembleSize, this.seed);
                }
                case BAGGING: {
                    logger.info("Using Bagging with " + this.ensembleSize + " members.");
                    return new BaggingTrainer(trainer, (EnsembleCombiner)new VotingCombiner(), this.ensembleSize, this.seed);
                }
                case EXTRA_TREES: {
                    if (trainer instanceof DecisionTreeTrainer) {
                        logger.info("Using Extra Trees with " + this.ensembleSize + " members.");
                        return new ExtraTreesTrainer((DecisionTreeTrainer)trainer, (EnsembleCombiner)new VotingCombiner(), this.ensembleSize, this.seed);
                    }
                    throw new IllegalArgumentException("ExtraTreesTrainer requires a DecisionTreeTrainer");
                }
                case RF: {
                    if (trainer instanceof DecisionTreeTrainer) {
                        logger.info("Using Random Forests with " + this.ensembleSize + " members.");
                        return new RandomForestTrainer((DecisionTreeTrainer)trainer, (EnsembleCombiner)new VotingCombiner(), this.ensembleSize, this.seed);
                    }
                    throw new IllegalArgumentException("RandomForestTrainer requires a DecisionTreeTrainer");
                }
            }
            throw new IllegalArgumentException("Unknown ensemble type :" + (Object)((Object)this.type));
        }
        return trainer;
    }

    public static enum EnsembleType {
        ADABOOST,
        BAGGING,
        EXTRA_TREES,
        RF;

    }
}

