/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.index.updater.jetty;

import java.io.InputStream;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import org.apache.maven.wagon.ConnectionException;
import org.apache.maven.wagon.authentication.AuthenticationException;
import org.apache.maven.wagon.authentication.AuthenticationInfo;
import org.apache.maven.wagon.authorization.AuthorizationException;
import org.apache.maven.wagon.proxy.ProxyInfo;
import org.eclipse.jetty.http.HttpFields;
import org.sonatype.nexus.index.updater.jetty.JettyResourceFetcher;
import org.sonatype.nexus.index.updater.jetty.ResourceExchange;

public class NtlmConnectionHelper {
    private final JettyResourceFetcher resourceFetcher;
    private HttpURLConnection urlConnection;
    private String previousProxyExclusions;
    private String previousHttpProxyHost;
    private String previousHttpProxyPort;

    NtlmConnectionHelper(JettyResourceFetcher fetcher) {
        this.resourceFetcher = fetcher;
    }

    public void send(ResourceExchange exchange) {
        try {
            StringBuilder urlBuilder = new StringBuilder();
            urlBuilder.append(exchange.getScheme().toString());
            urlBuilder.append("://");
            urlBuilder.append(exchange.getAddress().toString());
            urlBuilder.append(exchange.getURI().replace("//", "/"));
            URL url = new URL(urlBuilder.toString());
            String method = exchange.getMethod();
            this.setupConnection(url);
            if (method.equalsIgnoreCase("GET")) {
                this.doGet(url, exchange, true);
            } else if (method.equalsIgnoreCase("HEAD")) {
                this.doGet(url, exchange, false);
            }
            this.closeConnection();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void doGet(URL url, ResourceExchange exchange, boolean doGet) throws Exception {
        this.urlConnection = (HttpURLConnection)url.openConnection();
        this.urlConnection.setRequestProperty("Accept-Encoding", "gzip");
        if (!this.resourceFetcher.isUseCache()) {
            this.urlConnection.setRequestProperty("Pragma", "no-cache");
        }
        this.addHeaders(this.urlConnection);
        if (doGet) {
            this.urlConnection.setRequestMethod("GET");
        } else {
            this.urlConnection.setRequestMethod("HEAD");
        }
        int responseCode = this.urlConnection.getResponseCode();
        if (responseCode == 403 || responseCode == 401) {
            throw new AuthorizationException("Access denied to: " + url);
        }
        if (doGet) {
            InputStream is = this.urlConnection.getInputStream();
            String contentEncoding = this.urlConnection.getHeaderField("Content-Encoding");
            if (contentEncoding != null) {
                exchange.setContentEncoding(contentEncoding);
            }
            exchange.setContentLength(this.urlConnection.getContentLength());
            exchange.setLastModified(this.urlConnection.getLastModified());
            exchange.setResponseContentStream(is);
        } else {
            exchange.setLastModified(this.urlConnection.getLastModified());
        }
        exchange.setResponseStatus(responseCode);
        exchange.onResponseComplete();
    }

    private void addHeaders(URLConnection urlConnection) {
        HttpFields httpHeaders = this.resourceFetcher.getHttpHeaders();
        if (httpHeaders != null) {
            Enumeration names = httpHeaders.getFieldNames();
            while (names.hasMoreElements()) {
                String name = (String)names.nextElement();
                urlConnection.setRequestProperty(name, httpHeaders.getStringField(name));
            }
        }
    }

    protected void setupConnection(URL url) throws ConnectionException, AuthenticationException {
        boolean hasAuthentication;
        this.previousHttpProxyHost = System.getProperty("http.proxyHost");
        this.previousHttpProxyPort = System.getProperty("http.proxyPort");
        this.previousProxyExclusions = System.getProperty("http.nonProxyHosts");
        final ProxyInfo proxyInfo = this.resourceFetcher.getProxyInfo();
        if (proxyInfo != null) {
            System.setProperty("http.proxyHost", proxyInfo.getHost());
            System.setProperty("http.proxyPort", String.valueOf(proxyInfo.getPort()));
            if (proxyInfo.getNonProxyHosts() != null) {
                System.setProperty("http.nonProxyHosts", proxyInfo.getNonProxyHosts());
            } else {
                System.getProperties().remove("http.nonProxyHosts");
            }
        } else {
            System.getProperties().remove("http.proxyHost");
            System.getProperties().remove("http.proxyPort");
        }
        AuthenticationInfo authenticationInfo = this.resourceFetcher.getAuthenticationInfo();
        final boolean hasProxy = proxyInfo != null && proxyInfo.getUserName() != null;
        boolean bl = hasAuthentication = authenticationInfo != null && authenticationInfo.getUserName() != null;
        if (hasProxy || hasAuthentication) {
            Authenticator.setDefault(new Authenticator(){

                protected PasswordAuthentication getPasswordAuthentication() {
                    if (hasProxy && this.getRequestorType() == Authenticator.RequestorType.PROXY) {
                        String password = "";
                        if (proxyInfo.getPassword() != null) {
                            password = proxyInfo.getPassword();
                        }
                        return new PasswordAuthentication(proxyInfo.getUserName(), password.toCharArray());
                    }
                    if (hasAuthentication) {
                        String password = "";
                        AuthenticationInfo authenticationInfo = NtlmConnectionHelper.this.resourceFetcher.getAuthenticationInfo();
                        if (authenticationInfo.getPassword() != null) {
                            password = authenticationInfo.getPassword();
                        }
                        return new PasswordAuthentication(authenticationInfo.getUserName(), password.toCharArray());
                    }
                    return super.getPasswordAuthentication();
                }
            });
        } else {
            Authenticator.setDefault(null);
        }
    }

    public void closeConnection() throws ConnectionException {
        if (this.urlConnection != null) {
            this.urlConnection.disconnect();
        }
        if (this.previousHttpProxyHost != null) {
            System.setProperty("http.proxyHost", this.previousHttpProxyHost);
        } else {
            System.getProperties().remove("http.proxyHost");
        }
        if (this.previousHttpProxyPort != null) {
            System.setProperty("http.proxyPort", this.previousHttpProxyPort);
        } else {
            System.getProperties().remove("http.proxyPort");
        }
        if (this.previousProxyExclusions != null) {
            System.setProperty("http.nonProxyHosts", this.previousProxyExclusions);
        } else {
            System.getProperties().remove("http.nonProxyHosts");
        }
    }
}

