/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.security.appletextendedsecurity;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import net.sourceforge.jnlp.JARDesc;
import net.sourceforge.jnlp.JNLPFile;
import net.sourceforge.jnlp.LaunchException;
import net.sourceforge.jnlp.PluginBridge;
import net.sourceforge.jnlp.runtime.JNLPClassLoader;
import net.sourceforge.jnlp.runtime.Translator;
import net.sourceforge.jnlp.security.CertVerifier;
import net.sourceforge.jnlp.security.SecurityDialogs;
import net.sourceforge.jnlp.security.appletextendedsecurity.AppletSecurityLevel;
import net.sourceforge.jnlp.security.appletextendedsecurity.AppletStartupSecuritySettings;
import net.sourceforge.jnlp.security.appletextendedsecurity.UnsignedAppletActionEntry;
import net.sourceforge.jnlp.security.appletextendedsecurity.UnsignedAppletActionStorage;
import net.sourceforge.jnlp.security.appletextendedsecurity.UrlRegEx;
import net.sourceforge.jnlp.security.dialogresults.BasicDialogValue;
import net.sourceforge.jnlp.security.dialogresults.YesNoSandbox;
import net.sourceforge.jnlp.security.dialogresults.YesNoSandboxLimited;
import net.sourceforge.jnlp.security.dialogs.remember.AppletSecurityActions;
import net.sourceforge.jnlp.security.dialogs.remember.ExecuteAppletAction;
import net.sourceforge.jnlp.security.dialogs.remember.RememberableDialog;
import net.sourceforge.jnlp.security.dialogs.remember.SavedRememberAction;
import net.sourceforge.jnlp.util.UrlUtils;
import net.sourceforge.jnlp.util.logging.OutputController;

public class UnsignedAppletTrustConfirmation {
    private static final AppletStartupSecuritySettings securitySettings = AppletStartupSecuritySettings.getInstance();

    private static boolean unsignedConfirmationIsRequired() {
        return AppletSecurityLevel.ALLOW_UNSIGNED != securitySettings.getSecurityLevel();
    }

    private static boolean unsignedAppletsAreForbidden() {
        return AppletSecurityLevel.DENY_UNSIGNED == securitySettings.getSecurityLevel() || AppletSecurityLevel.DENY_ALL == securitySettings.getSecurityLevel();
    }

    public static UnsignedAppletActionEntry getStoredEntry(JNLPFile file, Class<? extends RememberableDialog> id) {
        ExecuteAppletAction userAction;
        UnsignedAppletActionStorage userActionStorage = securitySettings.getUnsignedAppletActionCustomStorage();
        UnsignedAppletActionStorage globalActionStorage = securitySettings.getUnsignedAppletActionGlobalStorage();
        UnsignedAppletActionEntry globalEntry = UnsignedAppletTrustConfirmation.getMatchingItem(globalActionStorage, file, id);
        UnsignedAppletActionEntry userEntry = UnsignedAppletTrustConfirmation.getMatchingItem(userActionStorage, file, id);
        ExecuteAppletAction globalAction = globalEntry == null ? null : globalEntry.getAppletSecurityActions().getAction(id);
        ExecuteAppletAction executeAppletAction = userAction = userEntry == null ? null : userEntry.getAppletSecurityActions().getAction(id);
        if (userAction == ExecuteAppletAction.ALWAYS || userAction == ExecuteAppletAction.NEVER) {
            return userEntry;
        }
        if (globalAction == ExecuteAppletAction.ALWAYS || globalAction == ExecuteAppletAction.NEVER) {
            return globalEntry;
        }
        return userEntry;
    }

    public static ExecuteAppletAction getStoredAction(JNLPFile file, Class<? extends RememberableDialog> id) {
        UnsignedAppletActionEntry x = UnsignedAppletTrustConfirmation.getStoredEntry(file, id);
        if (x != null) {
            return x.getAppletSecurityActions().getAction(id);
        }
        return null;
    }

    private static UnsignedAppletActionEntry getMatchingItem(UnsignedAppletActionStorage actionStorage, JNLPFile file, Class<? extends RememberableDialog> id) {
        URL location = file.getSourceLocation() != null ? file.getSourceLocation() : file.getFileLocation();
        return actionStorage.getMatchingItem(UrlUtils.normalizeUrlAndStripParams(location, true).toString(), UrlUtils.normalizeUrlAndStripParams(file.getNotNullProbalbeCodeBase(), true).toString(), UnsignedAppletTrustConfirmation.toRelativePaths(UnsignedAppletTrustConfirmation.getJars(file), file.getNotNullProbalbeCodeBase().toExternalForm()), id);
    }

    static List<String> toRelativePaths(List<String> paths, String rootPath) {
        ArrayList<String> fileNames = new ArrayList<String>();
        for (String path : paths) {
            if (path.startsWith(rootPath)) {
                fileNames.add(path.substring(rootPath.length()));
                continue;
            }
            fileNames.add(path);
        }
        return fileNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateAppletAction(JNLPFile file, SavedRememberAction behaviour, Boolean rememberForCodeBase, Class<? extends RememberableDialog> id) {
        UnsignedAppletActionStorage userActionStorage = securitySettings.getUnsignedAppletActionCustomStorage();
        userActionStorage.lock();
        try {
            UnsignedAppletActionEntry oldEntry = UnsignedAppletTrustConfirmation.getMatchingItem(userActionStorage, file, id);
            URL codebase = UrlUtils.normalizeUrlAndStripParams(file.getNotNullProbalbeCodeBase(), true);
            URL location = file.getSourceLocation() != null ? file.getSourceLocation() : file.getFileLocation();
            URL documentbase = UrlUtils.normalizeUrlAndStripParams(location, true);
            UrlRegEx codebaseRegex = null;
            UrlRegEx documentbaseRegex = null;
            List<String> archiveMatches = null;
            if (rememberForCodeBase != null) {
                codebaseRegex = UrlRegEx.quote(codebase.toExternalForm());
                if (!rememberForCodeBase.booleanValue()) {
                    documentbaseRegex = UrlRegEx.quote(documentbase.toExternalForm());
                    archiveMatches = UnsignedAppletTrustConfirmation.toRelativePaths(UnsignedAppletTrustConfirmation.getJars(file), file.getNotNullProbalbeCodeBase().toString());
                } else {
                    documentbaseRegex = UrlRegEx.quoteAndStar(UrlUtils.stripFile(documentbase));
                }
            }
            if (oldEntry != null) {
                oldEntry.getAppletSecurityActions().setAction(id, behaviour);
                oldEntry.setTimeStamp(new Date());
                if (rememberForCodeBase != null) {
                    oldEntry.setDocumentBase(documentbaseRegex);
                    oldEntry.setCodeBase(codebaseRegex);
                }
                oldEntry.setArchives(archiveMatches);
                userActionStorage.update(oldEntry);
                return;
            }
            if (rememberForCodeBase == null) {
                throw new RuntimeException("Trying to create new entry without codebase. Thats forbidden.");
            }
            UnsignedAppletActionEntry entry = new UnsignedAppletActionEntry(AppletSecurityActions.fromAction(id, behaviour), new Date(), documentbaseRegex, codebaseRegex, archiveMatches);
            userActionStorage.add(entry);
        }
        finally {
            userActionStorage.unlock();
        }
    }

    private static List<String> getJars(JNLPFile file) {
        if (file instanceof PluginBridge) {
            return ((PluginBridge)file).getArchiveJars();
        }
        List<JARDesc> jars = Arrays.asList(file.getResources().getJARs());
        ArrayList<String> result = new ArrayList<String>();
        for (JARDesc jar : jars) {
            result.add(jar.getLocation().toString());
        }
        return result;
    }

    public static void checkUnsignedWithUserIfRequired(JNLPFile file) throws LaunchException {
        if (UnsignedAppletTrustConfirmation.unsignedAppletsAreForbidden()) {
            OutputController.getLogger().log(OutputController.Level.ERROR_DEBUG, "Not running unsigned applet at " + file.getCodeBase() + " because unsigned applets are disallowed by security policy.");
            throw new LaunchException(file, null, Translator.R("LSFatal"), Translator.R("LCClient"), Translator.R("LUnsignedApplet"), Translator.R("LUnsignedAppletPolicyDenied"));
        }
        if (!UnsignedAppletTrustConfirmation.unsignedConfirmationIsRequired()) {
            OutputController.getLogger().log(OutputController.Level.ERROR_DEBUG, "Running unsigned applet at " + file.getCodeBase() + " does not require confirmation according to security policy.");
            return;
        }
        YesNoSandboxLimited warningResponse = SecurityDialogs.showUnsignedWarningDialog(file);
        OutputController.getLogger().log(OutputController.Level.ERROR_DEBUG, "Decided action for unsigned applet at " + file.getCodeBase() + " was " + warningResponse);
        if (warningResponse == null || !warningResponse.compareValue(BasicDialogValue.Primitive.YES)) {
            throw new LaunchException(file, null, Translator.R("LSFatal"), Translator.R("LCClient"), Translator.R("LUnsignedApplet"), Translator.R("LUnsignedAppletUserDenied"));
        }
    }

    public static void checkPartiallySignedWithUserIfRequired(JNLPClassLoader.SecurityDelegate securityDelegate, JNLPFile file, CertVerifier certVerifier) throws LaunchException {
        if (!UnsignedAppletTrustConfirmation.unsignedConfirmationIsRequired()) {
            OutputController.getLogger().log(OutputController.Level.ERROR_DEBUG, "Running partially signed applet at " + file.getCodeBase() + " does not require confirmation according to security policy.");
            return;
        }
        YesNoSandbox warningResponse = SecurityDialogs.showPartiallySignedWarningDialog(file, certVerifier, securityDelegate);
        OutputController.getLogger().log(OutputController.Level.ERROR_DEBUG, "Decided action for unsigned applet at " + file.getCodeBase() + " was " + warningResponse);
        if (warningResponse == null || warningResponse.compareValue(BasicDialogValue.Primitive.NO)) {
            throw new LaunchException(file, null, Translator.R("LSFatal"), Translator.R("LCClient"), Translator.R("LPartiallySignedApplet"), Translator.R("LPartiallySignedAppletUserDenied"));
        }
        if (YesNoSandbox.sandbox().compareValue(warningResponse)) {
            securityDelegate.setRunInSandbox();
        }
    }
}

