/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.openapi.util.text;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.com.intellij.util.containers.UnmodifiableHashMap;

public abstract class HtmlChunk {
    @Contract(pure=true)
    @NotNull
    public Element wrapWith(@NotNull @NonNls String tagName) {
        if (tagName == null) {
            HtmlChunk.$$$reportNull$$$0(1);
        }
        return new Element(tagName, UnmodifiableHashMap.empty(), Collections.singletonList(this));
    }

    @Contract(pure=true)
    @NotNull
    public static Element tag(@NotNull @NonNls String tagName) {
        if (tagName == null) {
            HtmlChunk.$$$reportNull$$$0(8);
        }
        return new Element(tagName, UnmodifiableHashMap.empty(), Collections.emptyList());
    }

    @Contract(pure=true)
    @NotNull
    public static HtmlChunk text(@NotNull @Nls String text) {
        if (text == null) {
            HtmlChunk.$$$reportNull$$$0(31);
        }
        return text.isEmpty() ? HtmlChunk.empty() : new Text(text);
    }

    @Contract(pure=true)
    @NotNull
    public static HtmlChunk empty() {
        Empty empty = Empty.INSTANCE;
        if (empty == null) {
            HtmlChunk.$$$reportNull$$$0(32);
        }
        return empty;
    }

    public abstract void appendTo(@NotNull StringBuilder var1);

    @Contract(pure=true)
    @NotNull
    public String toString() {
        StringBuilder builder = new StringBuilder();
        this.appendTo(builder);
        String string = builder.toString();
        if (string == null) {
            HtmlChunk.$$$reportNull$$$0(44);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 32: 
            case 34: 
            case 44: 
            case 46: 
            case 47: 
            case 48: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 32: 
            case 34: 
            case 44: 
            case 46: 
            case 47: 
            case 48: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 1: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tagName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 32: 
            case 34: 
            case 44: 
            case 46: 
            case 47: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/openapi/util/text/HtmlChunk";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icon";
                break;
            }
            case 12: 
            case 15: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "style";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "color";
                break;
            }
            case 31: 
            case 40: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 33: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "template";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitution";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rawHtml";
                break;
            }
            case 39: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "htmlEntity";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chunks";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/openapi/util/text/HtmlChunk";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "wrapWith";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "code";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "bold";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "italic";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "strikethrough";
                break;
            }
            case 11: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "div";
                break;
            }
            case 14: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "span";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "br";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "li";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "ul";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "hr";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "p";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "head";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "styleTag";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "font";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "body";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "html";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "nbsp";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "empty";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "template";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "toString";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "fragment";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "toFragment";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findIcon";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "wrapWith";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 32: 
            case 34: 
            case 44: 
            case 46: 
            case 47: 
            case 48: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "tag";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "icon";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "div";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "span";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "styleTag";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "font";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "text";
                break;
            }
            case 33: 
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "template";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "raw";
                break;
            }
            case 39: 
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "link";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "htmlEntity";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "fragment";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 32: 
            case 34: 
            case 44: 
            case 46: 
            case 47: 
            case 48: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Element
    extends HtmlChunk {
        private static final Element HEAD = Element.tag("head");
        private static final Element BODY = Element.tag("body");
        private static final Element HTML = Element.tag("html");
        private static final Element BR = Element.tag("br");
        private static final Element UL = Element.tag("ul");
        private static final Element LI = Element.tag("li");
        private static final Element HR = Element.tag("hr");
        private static final Element P = Element.tag("p");
        private static final Element DIV = Element.tag("div");
        private static final Element SPAN = Element.tag("span");
        private final String myTagName;
        private final UnmodifiableHashMap<String, String> myAttributes;
        private final List<HtmlChunk> myChildren;

        private Element(String name2, UnmodifiableHashMap<String, String> attributes, List<HtmlChunk> children) {
            this.myTagName = name2;
            this.myAttributes = attributes;
            this.myChildren = children;
        }

        @Override
        public void appendTo(@NotNull StringBuilder builder) {
            if (builder == null) {
                Element.$$$reportNull$$$0(0);
            }
            builder.append('<').append(this.myTagName);
            this.myAttributes.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(entry -> {
                builder.append(' ').append((String)entry.getKey());
                if (entry.getValue() != null) {
                    builder.append("=\"").append(StringUtil.escapeXmlEntities((String)entry.getValue())).append('\"');
                }
            });
            if (this.myChildren.isEmpty()) {
                builder.append("/>");
            } else {
                builder.append(">");
                for (HtmlChunk child : this.myChildren) {
                    child.appendTo(builder);
                }
                builder.append("</").append(this.myTagName).append(">");
            }
        }

        @Contract(pure=true)
        @NotNull
        public Element addText(@NotNull @Nls String text) {
            if (text == null) {
                Element.$$$reportNull$$$0(4);
            }
            Element element = this.child(Element.text(text));
            if (element == null) {
                Element.$$$reportNull$$$0(5);
            }
            return element;
        }

        @Contract(pure=true)
        @NotNull
        public Element child(@NotNull HtmlChunk chunk) {
            if (chunk == null) {
                Element.$$$reportNull$$$0(10);
            }
            if (this.myChildren.isEmpty()) {
                return new Element(this.myTagName, this.myAttributes, Collections.singletonList(chunk));
            }
            ArrayList<HtmlChunk> newChildren = new ArrayList<HtmlChunk>(this.myChildren.size() + 1);
            newChildren.addAll(this.myChildren);
            newChildren.add(chunk);
            return new Element(this.myTagName, this.myAttributes, newChildren);
        }

        public boolean equals(Object o2) {
            if (this == o2) {
                return true;
            }
            if (o2 == null || this.getClass() != o2.getClass()) {
                return false;
            }
            Element element = (Element)o2;
            return Objects.equals(this.myTagName, element.myTagName) && Objects.equals(this.myAttributes, element.myAttributes) && Objects.equals(this.myChildren, element.myChildren);
        }

        public int hashCode() {
            int result2 = Objects.hashCode(this.myTagName);
            result2 = 31 * result2 + Objects.hashCode(this.myAttributes);
            result2 = 31 * result2 + Objects.hashCode(this.myChildren);
            return result2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n2) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n3;
            String string;
            switch (n2) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 5: 
                case 7: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n2) {
                default: {
                    n3 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 5: 
                case 7: {
                    n3 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "builder";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 2: 
                case 3: 
                case 5: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/kotlin/com/intellij/openapi/util/text/HtmlChunk$Element";
                    break;
                }
                case 4: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 8: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "chunks";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "chunk";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "id";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/kotlin/com/intellij/openapi/util/text/HtmlChunk$Element";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "style";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setClass";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "addText";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "addRaw";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "appendTo";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "attr";
                    break;
                }
                case 2: 
                case 3: 
                case 5: 
                case 7: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "addText";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "addRaw";
                    break;
                }
                case 8: 
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "children";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "child";
                    break;
                }
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "findIcon";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n2) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 5: 
                case 7: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static final class Text
    extends HtmlChunk {
        private final String myContent;

        private Text(String content) {
            this.myContent = content;
        }

        @Override
        public void appendTo(@NotNull StringBuilder builder) {
            if (builder == null) {
                Text.$$$reportNull$$$0(0);
            }
            builder.append(StringUtil.escapeXmlEntities(this.myContent).replaceAll("\n", "<br/>"));
        }

        public boolean equals(Object o2) {
            return this == o2 || o2 instanceof Text && Objects.equals(this.myContent, ((Text)o2).myContent);
        }

        public int hashCode() {
            return Objects.hashCode(this.myContent);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n2) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "org/jetbrains/kotlin/com/intellij/openapi/util/text/HtmlChunk$Text", "appendTo"));
        }
    }

    private static final class Empty
    extends HtmlChunk {
        private static final Empty INSTANCE = new Empty();

        private Empty() {
        }

        @Override
        public void appendTo(@NotNull StringBuilder builder) {
            if (builder == null) {
                Empty.$$$reportNull$$$0(0);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n2) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "org/jetbrains/kotlin/com/intellij/openapi/util/text/HtmlChunk$Empty", "appendTo"));
        }
    }
}

