/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingbinding.adapters;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jdesktop.beansbinding.ext.BeanAdapterProvider;
import org.jdesktop.swingbinding.adapters.BeanAdapterBase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JSliderAdapterProvider
implements BeanAdapterProvider {
    private static final String PROPERTY_BASE = "value";
    private static final String IGNORE_ADJUSTING = "value_IGNORE_ADJUSTING";

    @Override
    public boolean providesAdapter(Class<?> type, String property) {
        if (!JSlider.class.isAssignableFrom(type)) {
            return false;
        }
        return (property = property.intern()) == PROPERTY_BASE || property == IGNORE_ADJUSTING;
    }

    @Override
    public Object createAdapter(Object source, String property) {
        if (!this.providesAdapter(source.getClass(), property)) {
            throw new IllegalArgumentException();
        }
        return new Adapter((JSlider)source, property);
    }

    @Override
    public Class<?> getAdapterClass(Class<?> type) {
        return JSlider.class.isAssignableFrom(type) ? Adapter.class : null;
    }

    public static final class Adapter
    extends BeanAdapterBase {
        private JSlider slider;
        private Handler handler;
        private int cachedValue;

        private Adapter(JSlider slider, String property) {
            super(property);
            this.slider = slider;
        }

        public int getValue() {
            return this.slider.getValue();
        }

        public int getValue_IGNORE_ADJUSTING() {
            return this.getValue();
        }

        public void setValue(int value) {
            this.slider.setValue(value);
        }

        public void setValue_IGNORE_ADJUSTING(int value) {
            this.setValue(value);
        }

        protected void listeningStarted() {
            this.handler = new Handler();
            this.cachedValue = this.getValue();
            this.slider.addChangeListener(this.handler);
            this.slider.addPropertyChangeListener("model", this.handler);
        }

        protected void listeningStopped() {
            this.slider.removeChangeListener(this.handler);
            this.slider.removePropertyChangeListener("model", this.handler);
            this.handler = null;
        }

        private class Handler
        implements ChangeListener,
        PropertyChangeListener {
            private Handler() {
            }

            private void sliderValueChanged() {
                int oldValue = Adapter.this.cachedValue;
                Adapter.this.cachedValue = Adapter.this.getValue();
                Adapter.this.firePropertyChange(oldValue, Adapter.this.cachedValue);
            }

            public void stateChanged(ChangeEvent ce) {
                if (Adapter.this.property == JSliderAdapterProvider.IGNORE_ADJUSTING && Adapter.this.slider.getValueIsAdjusting()) {
                    return;
                }
                this.sliderValueChanged();
            }

            public void propertyChange(PropertyChangeEvent pe) {
                this.sliderValueChanged();
            }
        }
    }
}

