gap> START_TEST( "grpisom.tst");

# tests based on IdGroup
#
# n= 2
#
gap> n:=2;;List([1..NrSmallGroups(n)],i->IdGroup(PcNormalizedUnitGroupSmallGroup(n,i)));
[ [ 2, 1 ] ]
gap> List([1..NrSmallGroups(n)],i->IdGroup(PcNormalizedUnitGroup(GroupRing(GF(2),SmallGroup(n,i)))));
[ [ 2, 1 ] ]

# n=3
#
gap> n:=3;;List([1..NrSmallGroups(n)],i->IdGroup(PcNormalizedUnitGroupSmallGroup(n,i)));
[ [ 9, 2 ] ]
gap> List([1..NrSmallGroups(n)],i->IdGroup(PcNormalizedUnitGroup(GroupRing(GF(3),SmallGroup(n,i)))));
[ [ 9, 2 ] ]

# n=4
#
gap> n:=4;;List([1..NrSmallGroups(n)],i->IdGroup(PcNormalizedUnitGroupSmallGroup(n,i)));
[ [ 8, 2 ], [ 8, 5 ] ]
gap> List([1..NrSmallGroups(n)],i->IdGroup(PcNormalizedUnitGroup(GroupRing(GF(2),SmallGroup(n,i)))));
[ [ 8, 2 ], [ 8, 5 ] ]

# n=5
gap> n:=5;;List([1..NrSmallGroups(n)],i->IdGroup(PcNormalizedUnitGroupSmallGroup(n,i)));
[ [ 625, 15 ] ]
gap> List([1..NrSmallGroups(n)],i->IdGroup(PcNormalizedUnitGroup(GroupRing(GF(5),SmallGroup(n,i)))));
[ [ 625, 15 ] ]

# n=8
#
gap> n:=8;;List([1..NrSmallGroups(n)],i->IdGroup(PcNormalizedUnitGroupSmallGroup(n,i)));
[ [ 128, 1601 ], [ 128, 2319 ], [ 128, 170 ], [ 128, 178 ], [ 128, 2328 ] ]
gap> List([1..NrSmallGroups(n)],i->IdGroup(PcNormalizedUnitGroup(GroupRing(GF(2),SmallGroup(n,i)))));
[ [ 128, 1601 ], [ 128, 2319 ], [ 128, 170 ], [ 128, 178 ], [ 128, 2328 ] ]

# Tests bases on CodePcGroup
# 
# n=7
#
gap> n:=7;;
gap> id1:=List([1..NrSmallGroups(n)],i->CodePcGroup(PcNormalizedUnitGroupSmallGroup(n,i)));
[ 0 ]
gap> id2:=List([1..NrSmallGroups(n)],i->CodePcGroup(PcNormalizedUnitGroup(GroupRing(GF(7),SmallGroup(n,i)))));;
gap> id1=id2;
true

# n=9
#
gap> n:=9;;
gap> id1:=List([1..NrSmallGroups(n)],i->CodePcGroup(PcNormalizedUnitGroupSmallGroup(n,i)));
[ 2037257607315459, 0 ]
gap> id2:=List([1..NrSmallGroups(n)],i->CodePcGroup(PcNormalizedUnitGroup(GroupRing(GF(3),SmallGroup(n,i)))));;
gap> id1=id2;
true

# n=11
#
gap> n:=11;;
gap> id1:=List([1..NrSmallGroups(n)],i->CodePcGroup(PcNormalizedUnitGroupSmallGroup(n,i)));
[ 0 ]
gap> id2:=List([1..NrSmallGroups(n)],i->CodePcGroup(PcNormalizedUnitGroup(GroupRing(GF(11),SmallGroup(n,i)))));;
gap> id1=id2;
true

# n=16
#
gap> n:=16;;
gap> id1:=List([1..NrSmallGroups(n)],i->CodePcGroup(PcNormalizedUnitGroupSmallGroup(n,i)));
[ 1645705449099660590566903618369588263470096056141654562525151359, 
  5731292877151837831128533449569058634109812743, 
  2845851127858423712142032428763695088730558585892663129640860441137447778218\
196997, 
  9325284975766482819947011862572876066752867503472737253606096654171182402301\
8555883527, 5711779725103123535879689696080491317792079897, 
  3055709380859160991496801219526705800871526244113126020048569394657748759492\
668989954113565, 
  1899594102058760892371677555288954106081641888984017128144589644837032421591\
889161951584196853696802090791328328985744671397491915612316294538200300173740\
01669253323439687581820, 
  6224589953626147692123513013170844814808324141822827325504191348201987839072\
302405882951096250193681091105024668474408032569602788667772064160455218514195\
312715814301366144797229181, 
  2039673636004216075755032744155822428916391654792504058021213420978827375107\
212050926288780225468770663170234919561356026259289211614953213962528396172520\
68444268576040411454048549453951, 170141183460469231731687303715884105729, 
  8684848412654538857986743776637532811842779785874663021721336512319119197799\
2, 
  9325284975767189235253563230547433068247915726051034189940042046598395266185\
9162996747, 
  2845851127858639292985096200728586751784642250376593039426878394627004467357\
499404, 0 ]
gap> id2:=List([1..NrSmallGroups(n)],i->CodePcGroup(PcNormalizedUnitGroup(GroupRing(GF(2),SmallGroup(n,i)))));;
gap> id1=id2;
true

# n=27
#
gap> n:=27;;
gap> id1:=List([1..NrSmallGroups(n)],i->CodePcGroup(PcNormalizedUnitGroupSmallGroup(n,i)));
[ 1415172402750239379365294796315437350316324779463925280310673443730244853972\
953855911563537691447869009035259150708474964680464683733933636554132997831019\
5795036316875520101968811872802717040895, 
  1147472803289490287019941268419984269861122860523029077729009254008228201085\
49996880615990075204949569977311652614770786309, 
  3019681167620550265493221447223745049671728319984380971472607046398798445920\
770959763797936123247535501088913766495955688609583372070031441984519782661917\
526970423697922862808022102153736473025791438862834928999322222589969359310689\
737292522884618397494569774770478691218651542011303360131607969475679859569948\
170012099190994897969792532333153551181927560955600906875051520548564428585219\
272255985570706482969671665079236876477660525743525413006529587219973520930850\
952189311350522148211685149896060299022176448348645245640816892451623081618839\
489499004234075858209967239864122408577411583432568266311243363064960921486028\
095067655747605899842654241342921804422528316334909015782519487568380221936855\
247910538161935355778018426985166239266424147508475444273500928928213613295090\
722762549874302441564597613730084431062653726539112823672593486706635662011999\
10258400722010767368, 
  3902081460670091302341204190970562590949690319778521175019490859720999690429\
705540658424290989021576550114758692189752458667985241224799495114547479385641\
596894065224238799344666183005808720489311967190444785554704139923255507520216\
333846594476436259582330280768531321305639753837455005411482266087213851837438\
495797265517487253570045218128234214694273610649979056463809708781020694105890\
478629410401612632123166603985715733731071479046138095396903865935294196385779\
742240258176785119620029988140797127203218491200936273995691054004131014148920\
322910823770327845769160972537484251053584689455852014114088886831177221298307\
324858844894922587968672223350931510987232414808816676050804157289957319555715\
728127891353404304454770341300440833081492417758357364530789890427717385383339\
261694698439036633916965383367249237805978982863334120943804780557760643865046\
921787981825037715712188531641785009209081869, 0 ]
gap> id2:=List([1..NrSmallGroups(n)],i->CodePcGroup(PcNormalizedUnitGroup(GroupRing(GF(3),SmallGroup(n,i)))));;
gap> id1=id2;
true

# n=32
#
gap> n:=32;;
gap> id1:=List([1..NrSmallGroups(n)],i->CodePcGroup(PcNormalizedUnitGroupSmallGroup(n,i)));
[ 9076030952438768916978426484234669505940345925721991228230194108256452630534\
145388318138050398124717196034594088306516744263659560699552675164307366313000\
898223349084078204103954979196982179420972419664719789485893495022749343558740\
612808721541324003894287164227464771397014814719, 
  1296985767920742944364092339742709855642062340864847143076053726552972526939\
549451726085583714647884354359945270364500097281069664279007719804979356588270\
967062002774611527343347111665134127437022423091982462380610911885886180669096\
890769844869100487795865937638942118904701577810438115985377344215287226517567\
881744102640459122716646731677195188606400162545841454945143140020703090223606\
855285817731435544356197196890119, 
  8026330894587563600627323577412129481751562794878239956961986149398782161098\
741816002433264143242291308871463588759467262602679217927509103071488536485932\
3276581707342988406881403345904502222271885518832303, 
  2758383668567758686430085567910947168586778039185909798082637563387689495286\
629449756963092918886646543808579644472899921030575463353255184790331087274894\
671866788472329830449226907028407986035753423489121102500071326871655594851015\
597780027066260255742772606543902194760989180944199831935761747127400496088998\
864552615330287312013458917527619623252372219709682890385870376278204978372070\
8795383899208087621466227455963707612059244245447542027999096550195887, 
  5923583824998435803117777390090651338662464418950495574701657408243180391461\
753009790815094937573187592162156934318915084468858963214966752597333790254044\
528928786544509021281780419879984854429209929573325682231090775580250033683041\
828667783993666460826824974433583542866553548197067880731204382845272396829060\
416472375132644693125155187953968386968237126869632006270936752779992689659544\
130758253830558250203437702172531775304174958230585042592617286550073047934677\
3, 
  1797985969037568141736226843287539448762705457176576741697767197335205530851\
172667283271681759162072373206299960185197107323052838540796372167517865335160\
984396613966474905757365480250231971978511193000801990423298177460647598193580\
939964629513715863819770994921842648890293834462640837158033064598948222424419\
593995956971585439005372706789580859340198663024885293374795941431423702825928\
531411715205536885981990407963808660470238693374409328692131728402825762656452\
783864708488993015730514090140133917091094200524252516022424046170526695730761\
431982593433825683782585282872029618327192608635599492774424554020262008604758\
734969465149719300691401888475884244718950669669321440723966776055705657250990\
658596863193139013083990141882785206115288690539380955883988018163661066711058\
495814992410045396003524708970317849568597404615359483403395327107053979272741\
540476736362391121806706258520747188495289200145032664182077814632650204974840\
8601757973246642469, 
  1068383434680238013727794386566635555797344980868855104411738462178275938491\
779382766599326238697611171425973792444518081868291024790122934845985900543512\
395422617137499360516044909570066307373189938920006817511246942634913732394799\
155014763798934943450455426722414620130047695421293576974892701983903961891530\
651025272395373426248369318856945858213868556226853920667171872508687593307013\
568505025899949151560299731393446084971056220105696042330957658925342702064909\
148842708424304027534580298164715946807414100801131337852053894900377619393782\
246569470025395715581559480741486209290143949610353194590437836568793488011188\
385532297918595235675231233221497743655355201205858366423472682234121609997573\
798386366678274347300455604024158579387122255513566831231334781406395413739041\
646513599650605381064274750055164868438622197131453462002474128233681536930949\
038178697054198266958202252798221956492552443104988989761693462101265656050897\
04772313903244984538683298490578173688765482357, 
  2294335955769887243228437968258040718450189948230739169205541006780514038742\
950006914805053665420464807299403561751148528052480265441951634491524119855747\
181655380352144444318663284935356105359667227428833420653922865398471274208479\
065638422456795150875657727039247631805409059377312427561011384064970917364477\
222767566903810223722107098910189281735609211318537373117440846617947344567285\
882078670925957287007217359146217721844961785965671082564046572928613217265684\
177216013581197334942095691056190378799709770509527823455266797518932354733832\
571957714344158502144652572084303737445465863359620404769731857801501300406777\
917838013737586765228912953741722828122014888677091508956388379225330226095169\
720333759050403729353134250256140999024230387573942252045323815976684977904906\
405109934099918902307109818772746806951696508730139346212027357032765706048383\
361870226685711150440415128006989124196420817265013443917719326955909168081627\
52457442816915280883952599939166161842790689215883511159, 
  1078791581958382459870127379391966449482630946399544940416222557706262395560\
068738328054554250347815963007398852350049194382101855615168900006036702379615\
659403889633779180092051373860118319176979056489750159399949650672823922056215\
617970868826085868086759292526454137682726685231212299101198218119543159096570\
083822794711888184063677328991273659608306135220769638805987446641412645869819\
115821843675828127854037423847523433048503792277738761253242406855767425459480\
708070709047354876029011104412280921431912801509029960841599485028859873737594\
429894140733236427611319665219294976444869087629783320892877019935121729070605\
759826473471795705133144495873334576261023235257842071001275342575116958727487\
668827193501069835543986944561428229477899353183129103112937783954064336943647\
243158825767598566093584217970746170866929501198615713682766629581865792369677\
968051798650025348805944375901143897742991043598248287370480667236439463887021\
3944799765794390701, 
  2316687281855678149101114750921340132828568017411787234184972256602934881662\
555417315488014904550833093071761938435697016931137198804032193521110919648067\
317094590416137497690527460140538729777807341850206746916785366843201570598949\
576354655744372357560200626012608868095596168587271511536308270618456243390146\
707895440973440746481161254757076518701955510364679669310724286155706176625851\
287945227375053117424998698492595566037984220889201128979218291045290548775541\
964363650708795017393504107695042045868100815962092311959985856892927862449759\
756762787864116300676307608731972325189063381572640624732847030441624915031124\
118515451788548862551830814536504146930203048833807278282228555659406731746054\
280039135422126179336284361198526046865728664036041383419946791074222487707994\
764682026705887273849005452640833950563371031954014523383977716839790835458686\
822625278131198945822914262010934695677825114453801333205670147210110221103363\
8879797871580514286127022767, 
  1058075704879922685871192407144843132621023560090318171678243971136046937208\
013313428066254760603919349751523806430924346204726390080254105808757117688907\
379483034161481670349569855348280272119070103311948974518711440747234092017628\
012540016671685905574852896015772640682954755871052917054090886673984421043097\
573235024752273147603834879177088065670120237038759661034070202243581163350125\
970825355691417524578556657844777889092491901339068882031006568301814060641755\
909566643757297540950092071848742803789175273632671821115428608200282795016926\
423432178866346962614674639603591553780097384783617898768076315191964439418343\
449202557215170888691796147286183069241648131505049249259314910284477176076032\
869839237691195132077387964185662643666519127807803636663734934216038030710393\
264167446533766442363217442178080113715941442952984321159218827173219919567642\
462420906820921360599468265771078022185086102911127810910812691135653395070510\
208075700049240783351303146376696468791919532654430556878951778144594429693, 
  2731770870472791334024323907829065207491210382792223950751233817445420974019\
105812682245719316713679394739572101433327612825195262257756708684804716641578\
286661533314376032956657231382140691826369946148631590268176365227033084748909\
049066809565813446926399131189643952707061149567136385772728219550663716518060\
548310683506865511785560627017769494793520262449856643257003882635502753770617\
493749078273371059713275767552967681568647366478749627180135658722608479257506\
94115850022950012247, 
  2385056240028050940268019914762618467494333342694763734472411791236838227496\
386288318681022650545770391497351807857037934982297503241464581298288337156251\
274291371096263037948424586366168242214030607283839084612778637016611200465892\
020946798740973761216708458369817755582392753040273644035573468198140308873414\
932678469382189727643702186742745733277010605108408561965997973203402925365584\
109140531982538168102827347333603949711483510156689963872613556505549750613907\
071963946961228303852074347026088023986206032744647832489939751438309868799993\
865087133415987680640252474000027516133687025355976367237237741891655404964966\
813362073630977542131781011945397369497633677364072584489774814926399023272640\
681628069857955425858849310303765638346540345403185949659090214729955746033937\
352077263459840056055648406910589848281261162536360214707730359111147696346244\
8207013794616900059823, 
  2385056240028050940268019914762618467494333342694763734472411791236838227496\
386288318681022650545770391497351807857037934982297503241464581298288337156251\
274291371096263037948424586366168242214030607283839084612778637016611200465892\
020946798740973761216708458369817755582392753040273644035573468198140308873414\
932678469382189727643702186742745733277010605108408561965997973581345010939460\
045697809078233928005145376945683193695157277761195594907585043430290230810626\
748001497400981466991393594562313355969677588092498137967002248362941233378394\
624125964448876986592117972546789140549080916406539871056524133002960423185480\
456295847143474138457820248852819123726781976496018872488683671522247860333905\
290402671782812804895944335531505726577232129245526662505217483347536829838303\
993814897443535181697696121140228022648044711937627919166821847163605973535295\
8662962820391882457775, 
  5023514767914928774675947518050514391772013204296322854263110117364441315691\
760142845980510035160947697595402850942798032723276682615349401491334064873910\
975075190404341876434958912036866639924554074080848229793723379228401987113045\
852062361774228595841821620368190412025157313555959426045884554425623390673200\
596989626698219053868114282204680260829248696361070335788782698279835455892503\
465344991542150630017829192249675973046206240245285787722146254865909780801238\
920182038339726071636200628371328151659078580004383150513488894074030102274325\
118566092459496158853582445500713890690987942793502957856746029024748913665965\
549255930943799287087688294376223314756486155948796072259573814387625812800669\
234574671629450710268461335077808490309559325567450539905520295655414658736978\
408950250520342816375212839867664719468647162326912533214656994312049562660838\
515271896703282543394858474483799143630707616363825101424562536847299836631846\
238554111, 
  8026330475981811957543840151709992456545696021347359029734387987485812684467\
870419300593788078352926892119480907811874178060481445629844564005055285262089\
7616256796359605261539128012502757252306518799292825, 
  1259806952890658667109116401491644040926692422003076965520267877974689467588\
654070438633746167327644790489502415985984871249533156768738034239402624779663\
183514198917601917077220559739038260523088652024851380243322372784992089026348\
522633352887172382963579152591714062807118063444558345100571320771333230242217\
073806393948236063101357330020764439942281533956466580731605586672799264631161\
898068717589274292918661792733413534758978127277434368020379253794283718953777\
920737626980068238026053772403797924317, 
  1783144452306320291480506835760970202868713306897758091174874353142789723767\
391019908756318680730880280170200935914107935764788517390638144663744996473171\
205776977831480885435798378884718260414763913491456038185301755254594643778559\
643774829670400001759518675857531099402078001577573725673968352422900950414553\
683452511877590654393788413179275309563979160902462164445424483495097203014324\
338081109706184314493925649190221939313259898298698795440893961020824351685435\
877284165962987490648590533309477011082292236697678681317958355410978932441038\
700353947576834537221370069117336143843124640083133897274794129513518487568786\
703516432005745084841400466946364378527738134245454721931882524017177848455907\
271507970933833268075040734739302879445004688601954397446510225543929278968916\
586648127715822598926607772288661292988671614734962861290839457946616124614571\
785568381745361556053058879985325691685590815501829626772672635350691270578481\
877043365390351881881950435000520529300488499544990439588460623965308106242089\
045532790746932493589502681448453354978725095200914581134575638732383341413209\
766282880364531143444599033437581849893933285629395560540765941059562194878371\
282028349431870573665509168187776219657840965967216453420429989358641832428980\
889392826061070547224847806339417333874260784890944308190127299137465276186000\
594209223664797150788527752833659096693143994846890761081677632700524715206786\
710142116275953064652153922120421052664282032330774603332697219444230821527429\
167221739275921858428327478361915554921670229645173777495339197623571003444462\
452795124378942966343927338972841146672953899115993493112198387859928275625507\
469058659368884119032436989820775286441371959921704981838372344923294439742167\
4492, 
  3829273553349738713004982140548905147275804517362941108657735781828718340892\
909170876096646383546498090311165166749842724561917715274559043950450838367952\
835110503027963701097938372479840941327711202003388429713799113354940074382841\
767999151711169233397737584754660413617425085608357779399284816097680971738912\
856432437441651707948279970074361419778783257850798421085236066724567131643797\
825797606791724899849794726963786056166073981170598682886616731794169682724674\
786220281054833809396401084529701204731137360665610487688518656990049577089627\
333145274233501392284539579586109162222486041804415404992132155696675146999660\
721001361831641411753280176186881995937999957718142833673104690183856700666882\
914567663882066233149550414786558476527462884056029049358073664020380032254178\
670102829399544622063752543099607662503709341885088598509369908133541784542923\
212030262183985641471779365149681402849095833509164037576257497672676249063633\
331614973762669803307516025510104708161103931184922409332551039492349813585525\
767273763869675378706170034384269470683551097626827644550968430534423776026138\
191434978518590194674729759645327201974567600845285706984850617555980751506168\
408058499985760707850713494515981741020824836047833857534662633720555898435419\
640087787168827086449318358940536213526320354577765188938137205492744137423051\
001623813035456813257508503551972675714590162993893979367038710349148190514929\
757081669345890292964814962573366582592823603781807482391959699665305999571342\
863386991377598399330502347726922826115326722133504166290116500269847224221899\
664560508470089762708483986863640068242916741589163320492485655607021059149684\
694968586531910289687057916215650307443293378803416428770371119033128150667061\
7724413050877, 
  8223302339537419511250764089360811548077821947081448112029478820181668173865\
212163605655382176304440896606454427422480557568486257073635377294106497623069\
720635045525606534845382301412191631142187215568701493402780915886632229757056\
388549587977607147682336943455647330036336899208948463393555405464457057530065\
484485631022729996930202865460620493017000823570757233024762867510844835083319\
191518313142762964141871832311355243787053446922120569869346869571181095388587\
189525949291219797036320079076999107486017718471276918248399133229052365509290\
128343324824919973716282110369964033815768112683226496419901373013599926149767\
659898314719181260739804188723888078382457331024403128241376099561938378257361\
754164639176297436141615054305751738538518366437242299309448090263212058011561\
273716212614055734528248599824822690442218551043069260330109052500043182630666\
751954624921261932527436840122761885028133914045860228844670529289470301262127\
891110917587282435426266980280900719543782841848138138064969814761124075492237\
721245576117558160987360172295187315389024802414622161867882604982219960082149\
073538528519981183533112284985815258128385198455048489212186162011639017768331\
387905369761962024235343828581550656048728810070831875496973444324031329466865\
624131242124791509388945265961126298876777415451491706209281397308212818426776\
485673202027019661235540306942159167927354939573846567053649110405258732520863\
830023256741124220335877202271752672657586477899644673255267275177344769049263\
311321300130075648945273443611382183016558140576323596723455654001622224989030\
523546998953917923756738257672382575691349919674280731513870617604132851271948\
518205728150228859246866729810262620466468533555065338954731978871520251160454\
4896080477642708516863, 
  2415354379436706076361129250322507026720521214828961612399551571115548368176\
353659607396425044482199162592299732126258878218077526354723394460843391404637\
72671749142872075, 
  6039560624972825492091012827923660256711425079033945268735515772957053848254\
385984784261829428580986723659642138372183238011420490038924064332059072900406\
960489986826767221148442329096252809999008014291202858535945281340538647815415\
887367063075223229482328944930578583200069039753463258543500366954496047089352\
525407381689463196468128299793612017273299065386015093980511572935092973791034\
71159009102058733174793, 
  1296985768323380318862300337572429819359526761200250510153648575927135374538\
176724660457908644844285283276417620968601684168921753961073631166679690122366\
388019762877821801611867968240523752754692060691130844895679971190156626569563\
654044017772782648167840729363220749796520986240198759843548569780421984681044\
893520364334171385799079529263308792765205432062516395952191466622311019471671\
967441678522673275769750223323147, 
  2785255729163175610841815938601673052702177552695938824058618284342009656303\
090067942531711007080942152083154705049134038178019936422884851454427796991488\
937337263880959740819386504531508089996296155609627068041897003971972454116980\
281554657239272083170024585246484232393007760377930501306653447240328967526396\
015444569140521544489835964726259004304266934764956300736958993416359711677441\
665994292015101864236620191473189536137245, 
  2758383669424073678961851350816740791926725349630378948077090564869800013515\
963969933850275568803626206825551151080700880471904343796641124784743367195128\
094178827624747892695288404581220164369170933235453081463981154822439925017726\
551077597717090951556215640739422573890755711650460786719184176142200051468914\
025937247973091497209516192492480900427589193041126646362118903075427845498451\
1760348583423418481233843022733857632431275991870404338688877276430605, 
  2731770870472791334024323908564634180295530077485759719614286565324053836556\
209290048940429487508862244281751928199610575530589277786190858839937969583720\
489436905085444001508145282229726947656364637179559877753074863733739314484301\
319410228178634931951436586110854311418006771612215518247203629147329209184339\
949843709791022503089283884352928244001831353758152057220623247915554896260152\
925619559742719683184283740703060175666058067001581228215289695120677852354302\
33199378296087773503, 
  1188616025315571895848490162141115612229554994638621011976479763148820486411\
648885826432590800382906022236608684086085975160697410119638593830961745366383\
459043474238135994149172420112594878446120924101188825743238758027611677412626\
477636494337542457531234987588941337443021780841994733609143578373476796583262\
123481300269735623708052614753383835502888049190417455434906035451277974950370\
716444196073571617728514344527525220686599992412541267624255664100102492903533\
455328467734205985230927521534983755828496155930775222950820105540289737495408\
329470885837823265694111237517991561685883773287393367709482263352165366065918\
931559529390355039226687607363811721247793294082328, 
  2552533478115944686102991708686914445740478173303166292488702451965004985094\
044125652429727168159001157664124788492973918022096189759270804228412877593038\
691648556695125582888259082293674161491752648732061661241028187021808357594538\
302342191427992118262400782098320812443583988409058790831085359320369135334421\
676486049035621021032183773294831319041367751862440888068809502146739263455439\
441187594944857499113865225923771100682324294555838391584980057103949822510785\
605616321768963289319046255943927316272396659632469076429111355444221119332941\
629225342202669098023644223961943517373592852123242003061952961793817921111462\
864717399388535830851991783000058188652898715524435124683034, 
  5481523905226557061478667538284728323802660128869459759744273740332353673727\
943502029050170562722801250096777859520120051842944070191139108484325911623676\
188946589665583110559004990413151595643650100012790350842823418336419267324007\
921811739593260325005504704581130625829865405047878966491939497147253591566757\
922470467303916098887688919395777227004302799661231197013503988001766726797122\
045890354689902599856153800277960198461931161671343191788369047170134881156909\
279389342507536492002664770094989969997181765167323162982633626507948240229701\
478906621873144951138164502067185545918249237228140884031124688693347205720248\
913712366096308055492070862532314937064526819687563971409612906692891, 
  2552533478115944686102991708686914445740478173303166292488702451965004985056\
422179029682954918097522821473841536049667455979731860507873603921704024416772\
325843766189260588489617181971282461391192719380142719085987163706791802205681\
547522858776732037654944660611038723073667981083548562669275329412509671778234\
806102936048920708929459061996121858454866930742096077538835462383723193443447\
189509546596953406999301389408991115578575859091615932730631514152214721025248\
344659199792565531356310870868336846745405108449524107672782068616533160615370\
900529058698111559876467801435982423543881549873862044717564935230870539557774\
611380243436169788363082246065894979580611143603828041974044, 
  1177148295259513302486436923929486804348866180564873756064483651899952759950\
998526604909728700332363304319901711080976568521176772640147694446147289121418\
280288688573426176995911344649390901789148129167474458484928811852511029157648\
336522057963684305313033254415860067498457498592288194206887227451365389016358\
769934931391369792526042440251889387053785185900863780847402862156208923432042\
583057095846487250259921085822643625937468783412652010929407921887797680056876\
719399637088861621893305530657057108042639814429789002665793189862774742356563\
534568517442652693105552345878686741770051492312129261652408802745469151222346\
907867912065392141678141400973900843360625036878960266630509429012158934627155\
0, 
  2527906715340880733528101035921992817370965410103281794332819476018472683967\
238617156136598900080042361222236685513617584770378660962130962128001719987774\
043488239430797162433873375492259254752169551236943253054039477897336022855701\
156744313978876966396787088413017118445736624280739014345764902878133070515194\
286882133604179453457967983078740587449160728556493560558301539142315161115928\
701073166342587612514495398064456042764899851875833211489528196678192350926144\
246460126182455839636387666940796192860642025315950432976736397838300606681350\
573447101486386750367876240911767904239256854542692821471377287887570043154789\
425607822145874130390568740681934162151559955852725174372655388869398899999900\
0540086591, 
  1177148295259513302486436923929486804348866180564873756064483651899952759968\
348587127524006225505817404133678887080789893832963465491403546996338796010909\
511635964691078170856058985545181821539644930913832620490985471069002312333972\
171800139701355954195178424560436627064199227378552294191410935155898901959807\
414209150626972922018950901847865770914454597305929459585163721644267137364383\
696555495758431503802171772906551841499638612543558366506300113621568903745451\
541644242950668796037588198633420158231626305122714734349641748653568998372488\
624822926488912832872395135632480291530689200742064738274439627841663186369164\
482809362705854175135207211892759789521352871343175961311391010385094061431225\
4, 
  1177148295259513302486436923929486804348866180564873756064483651899952760003\
048708172752561275852725603761233239080416544456536851193915252393269426054301\
464901390145955547277007010693710415837020559456433828401120188097880175103503\
943546678775503437353702860155643201598468027801311474808271639328717524403203\
905795618762229309376139121081403016598451353255184306733319026945346100524736\
085338860106693842377628582306734930169420495934596484532270874571591434060854\
763215620067668261518902419801902078026698427056486306352115862957600970009857\
523480319312603429842174331968887189969954145849848811042254459894031889147078\
010810562991180627312549101837885582051947060144752291174182738540176005398559\
8, 
  2527906715340880733528101035921992817370965410103281794332819476018472684079\
015530948510084490011745490308175677239269086249077934648342281612338957709957\
555938181270907871112263481846104254457281884472503414885443588822881899498151\
566198801105659037587677937709808341991700432384942883488553533546843762796326\
370451298139140377598731072379196182689461008568728312049067216525860616951368\
177499105779972086189077938011059610742009353642305809715644033551637152254221\
622505977150489428786185828619019469396458716605349221000192169900387414812419\
144645276486699791647539931265033945396900417762770702436113044518087886224836\
993436252162385591889493274784382501424295093220733789252954900576092040811714\
4096604479, 
  1207668119908151820093732042377765745796831977846611896329968633566301541702\
938178013130896406283067336878962443701013881373709726385540223207248300340479\
95672377765658945, 
  2785255729163175610841815938601673052702177552695938824058618284342009656303\
090067942531710266455736673740685940026557323888433830045591180832237164546638\
299867827828100509397329931032725592673506731406240454022969669047644453890274\
956032084912761296774465785689945946201677737176221985824555951460707339925512\
297803269729281234847596077299255416530558830789048268724726543607316042605103\
550470733296596203715436499346094485930313, 
  9872639708943700486814803690524936033643213283812364674106526172970045678427\
243082621688929675928651934899409044674516431054841874987823116155761832526832\
094634061496980207947535839644049793681357624236867352990520229592442293348564\
726241209766681272451863281199742408829102153832165597555554342379292513025264\
966636858172569261136103225670434560171209180904284400440871173836350913574998\
080700144647792811819372447958983134191711580155106206190097676176573269331196\
9, 
  5023514767914928775765248641844217953841115914094850425076727356036434879047\
394718834198156060688657026020128833814396381297888253761910554482312530087800\
612781458686657895000855878531535214337272385293920851064829201778189313297292\
720083126926101584001453227287922966920225024904104920955396310379906577383960\
350906335798157379087807878169266066465579792304793704937350026882553499519631\
387818845826927147937570749566354157159656343444396231259493803139253057922892\
516556815066319948423246662975509264738137300893364554445062818201422073460998\
068446012577709570973518903926752770379602834640014904159436013019128472780441\
749801745495625578591766189573763877611840182097029544977715922344349912347086\
445735394179770696010540153644810375482529433324235921060553164552791263683216\
287111303536439385337583593451832300852099283984650639371290216239545422483794\
563099936856544821560442222815356929175907753072351861024219066644319119786799\
582415688, 
  1078791581958382460104053014501466661922181521559126400885812114244251799497\
113797569799816333208098658245853718946972569582758804188497740098937926358905\
982023256232718538528443894515114612512546760434065070146796409873155407335428\
507904795627451165603001921383764195934482816146195808582804611390038204269970\
147105169810614000012160457453407505389611375881378071336629604718264405670358\
426032851779955908828321010953684864347718412284631290386258938699887994204004\
345921431472129788231511736483925055562231003203398016112141572022257626239401\
091310874581113638635514600364379342718897895211687924275100131449573384973899\
780594110611379849522767308832869379408934797929635958427469031624942906751799\
873355665935090070991174906960005837847099488701865822804373271126627432429617\
456429504626853760278435294290664287609111841334511117679777180960168175129144\
193520779208219241608762115543644872331052286249432692230784202409757509762405\
5497464605489236809, 
  2316687281855678149603466227167006528495029066035983411067374230539838617414\
626503476327244208967711249753711225238611372283516714722832806547423099022778\
775564324715477144076291246356645519216550362867528120308218249787706991415611\
971798587350733278050986685884215143457169927010945876337710956939101593765044\
668356506704556821865986383533392339704662298780040995901189579565176458117533\
198204566708263008369798210317867131531823476489768017813629322044429412125835\
213257245559858666024131146552714513107724363731309905098824031635499434186863\
692741785805642058658832076834112683696869611272354854844607003165960385547409\
590637769328453351050380338495832482528345999211270440152665974661748089790224\
617087224824379213211124456752413988437962364290174373644877590081596402551999\
849491442735316697975855560305769210612888181809282979538008153937479561166039\
309003474437033785073529929059757230129785119333897691165263829917669645075981\
3567646715620382483014486859, 
  2294335955769887243394272903306490400730423951510529236111550578519194432016\
634393751371972328565740214613602022096646485581477300956541751520776272846918\
911657772830085521806594710023376994171603335461596040549235940647323727376109\
589825698664717727052504010911295267191254073438798869694671793268119386254582\
202968450086868261975765436795027122946511170733432395170351852651374486374087\
086802900579225423839697622790261693817363516197383993281667300708877862574461\
098615788409689979528144081520495771815604162409295921263292635777142658394706\
202339422762014479756141564518952926086106988527784657054025896487195462092624\
908623086278272697457901411504886831522488799531302750571803098357940752972796\
260860639794494674275100825093433117925768640566563382736382839475251425048886\
899753997876520647676050413337997492170228076896692639587894018018295061277946\
095277522220216722622382726814213067526609710461218844836389869520887220412505\
33574686401589495179283898319959957929740100878265748428, 
  1017829723631180907820567647348265215514639509513041191583063418334428804055\
222760179292159463325154532843385233845090843949354202145005785687445176849289\
516649443717544884629360548951325304659686789677250917915779493992524975096833\
071620398777893198009395788499636853442236678073674326048438264287656636746830\
159862220372874636719587106296962614770680423139999479682633934520783409192403\
781193004665352547923879455994075671270164913197935295944304238728213911906591\
979603391938557843375148430240502533161216497599571039910984067334298598152960\
581164756639699594717206988017957912601951440064748151151574770461668468539738\
401310591714268013694575763245391133823084707515766414135606827871649065177161\
135585081810103765399163652859708514661026311441486232875337819744872230807381\
909539125457733404890170813984826824523143081638621463065589598640081794020524\
395904312422828467371486281345538927533031640128468699167679540052515123614989\
189085952565289217783325633692179623945374369263541237852552087062725543451402\
149135208968260662049583747970434818586421636190584304336994436200895395242108\
5200973625090427047872210930648, 
  2185772687946320182474464340758230111484884251293996401675063924620169252128\
786966482455460662099225066354248734646988752455757889266486449629180956180317\
397422504131723970447598319569274639685295585633511543817126704522661618252056\
237890419238764826615603606163036596705375778709055754466441628495244995652493\
684137344183720745109253672084365047287359478526869697346964603953285087390380\
005925347450832308821667480470413088927302541355905435402434071405927692065518\
779606233713387989350276383514347897266290176382910060019995794726003713441550\
625181315503577849606379917398928561296141824358846184895051410339252399347707\
176562981085915847384914726367284220495740116221267220759605037649850456390036\
577302213999618282442314468551902794348157278399039297112818002959626625669192\
447300639209353906450595971553198755532108548962349434140151651859185240747717\
996760841667259398866366009628745597906898379111361290679044565762678334670058\
166131633399810290933821393558930462033246185007659867743857484359122772146627\
932473235774495924555230273421087432951372774738439407064845273692058007864251\
7361134053825036996635022955654640831450, 
  1072624634395407767965921999856467690198349265647391470217884915497741122405\
883758144149943853352274215202548654918884068300310624955725595714691920486727\
69, 
  2812389574524899530606611822831933844268316385500182734163935891302700242633\
627214349232750664826275501586289917837354249336705074385078882266266844081987\
661131110112714905587571393857808828877182965439973388869043303204314925906592\
779094877729594925905231043542111407682536493140338714709317073065516905384212\
979317858304070988233125303271336163251128219801382644622101321402802397322789\
79844697489424, 
  1296985767920742944364092340790406614901494366537998880519661316014034426757\
293900727812302032673684844447613844533440851289980761126082600118201391027633\
109888375808227042153865949887945808272110671035381639676333849890839108891386\
853331074430863139941089015415824025008422945285746563276051981906721247256247\
183450133881365537922233164536767134392939005678905968538204177612573682345788\
465728835207260145213183983878163, 
  6039560623097899110820574410215050982783987962352106722628983277892854189301\
346897742768293398775555400399555659542981774033888993440580554856925229670634\
073616824151142696635173400342212097123780618586491978151415707035172306426739\
568501126164864469045256336293294642800276660104141415487285686004684434371630\
748319378400114580860636440836299165991752505530679388635876320585058177814137\
67910567320110363574292, 
  5376263004491073691062932740213113941972385841593093677867254721438926758130\
434646062717717979398534068457574755593767862250172130739928350738409395456086\
200024537657072799909568492330391354421364386567176859542101239675432488786408\
950881053069552502012790599849081304836254774384382677736594637939053630146175\
436942087217835586845514033879827120249675862154490761191061737694089878620705\
835550647304450580703337926828528441508083637725612951553319335501312257030455\
390268846703176999579794441462317729478420035234571055240575221904665847005134\
050580880780329708949083880569952559226990062598299749582063967613625425301566\
867174101394307014361687087852580632755914737670197328737476834464699791949145\
66265994505158745123289424848213684250459766992, 
  2479363692919990552372476104764817426236757440874878857030236298676372055702\
608004867709547307618620964408070698275222192599340155553625736001827453151693\
110547379537510892204889409522216791313461465848086459887864964254865991521990\
867888412804717514727401207653904351931895349771375414371338758168905660870367\
156945262943183985890369773894489123745511914333582532270059717291143027407810\
109351124538284069203885650664261413956911028409431303414239920750007945144195\
195825732919543926953029802899730737399656677860615963777097584877333247543987\
389945146159188824080967860467031109074740530957698284880552531082684313644724\
501068351294782894628172865927200488665754648708189112466465849103787351658410\
019665247345584808163469201899045053799506739779166033822064050390, 0 ]
gap> id2:=List([1..NrSmallGroups(n)],i->CodePcGroup(PcNormalizedUnitGroup(GroupRing(GF(2),SmallGroup(n,i)))));;
gap> id1=id2;
true
gap> ReadPackage("unitlib", "tst/testlib.g");; UNITLIBTestLibrary();
UnitLib library is complete - no missing files!!!
true

gap> STOP_TEST( "grpisom.tst" ); 
