/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.map;

import java.util.HashSet;
import java.util.Set;
import org.freeplane.view.swing.map.StepFunction;

class SegmentFunction
implements StepFunction {
    private final int x1;
    private final int x2;
    private final int y;

    public SegmentFunction(int x1, int x2, int y) {
        if (x1 >= x2) {
            throw new IllegalArgumentException();
        }
        this.x1 = x1;
        this.x2 = x2;
        this.y = y;
    }

    @Override
    public int evaluate(int x) {
        return x >= this.x1 && x <= this.x2 ? this.y : Integer.MAX_VALUE;
    }

    @Override
    public Set<Integer> samplePoints() {
        HashSet<Integer> pts = new HashSet<Integer>();
        pts.add(this.x1);
        pts.add(this.x2);
        return pts;
    }

    @Override
    public int minX() {
        return this.x1;
    }

    @Override
    public int maxX() {
        return this.x2;
    }

    public String toString() {
        return this.explain();
    }
}

