/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.networking.AttributeMessage;

public abstract class ObjectMessage
extends AttributeMessage {
    private final List<FreeColObject> objects = new ArrayList<FreeColObject>();

    public ObjectMessage(String type) {
        super(type);
        this.objects.clear();
    }

    public ObjectMessage(String type, String ... attributes) {
        super(type, attributes);
        this.objects.clear();
    }

    protected ObjectMessage(String type, FreeColXMLReader xr, String ... attributes) {
        super(type, xr.getAttributeMap(attributes));
        this.objects.clear();
    }

    @Override
    protected int getChildCount() {
        return this.objects.size();
    }

    @Override
    protected List<FreeColObject> getChildren() {
        return this.objects;
    }

    @Override
    protected void setChildren(List<? extends FreeColObject> fcos) {
        this.objects.clear();
        this.objects.addAll(fcos);
    }

    @Override
    protected <T extends FreeColObject> void appendChild(T fco) {
        if (fco != null) {
            this.objects.add(fco);
        }
    }

    @Override
    protected <T extends FreeColObject> void appendChildren(Collection<T> fcos) {
        if (fcos != null) {
            this.objects.addAll(fcos);
        }
    }
}

