\name{HausdorffDistanceImageFilter}
\alias{HausdorffDistanceImageFilter}
\title{HausdorffDistanceImageFilter}
\Rdversion{1.1}
\docType{class}
\description{
Computes the Hausdorff distance between the set of non-zero pixels of
two images.
HausdorffDistanceImageFilter}
\details{
HausdorffDistanceImageFilter computes the distance between the set non-zero pixels of two images
using the following formula: \deqn{ H(A,B) = \max(h(A,B),h(B,A)) } where \deqn{ h(A,B) = \max_{a \in A} \min_{b \in B} \| a - b\| } is the directed Hausdorff distance and \eqn{A} and \eqn{B} are respectively the set of non-zero pixels in the first and second
input images.
In particular, this filter uses the DirectedHausdorffImageFilter
inside to compute the two directed distances and then select the
largest of the two.
The Hausdorff distance measures the degree of mismatch between two
sets and behaves like a metric over the set of all closed bounded sets
- with properties of identity, symmetry and triangle inequality.
This filter requires the largest possible region of the first image
and the same corresponding region in the second image. It behaves as
filter with two inputs and one output. Thus it can be inserted in a
pipeline with other filters. The filter passes the first input through
unmodified.
This filter is templated over the two input image types. It assume
both images have the same number of dimensions.
See:
DirectedHausdorffDistanceImageFilter
itk::HausdorffDistanceImageFilter for the Doxygen on the original ITK class.
HausdorffDistanceImageFilter}
%C++ includes: sitkHausdorffDistanceImageFilter.h
\section{Methods}{
\describe{
\item{void Execute(const Image &image1, const Image &image2):}{
Execute the filter on the input images
}
\item{double GetAverageHausdorffDistance() const:}{
Return the computed Hausdorff distance.
This is a measurement. Its value is updated in the Execute methods, so
the value will only be valid after an execution.
}
\item{double GetHausdorffDistance() const:}{
Return the computed Hausdorff distance.
This is a measurement. Its value is updated in the Execute methods, so
the value will only be valid after an execution.
}
\item{std::string GetName() const:}{
Name of this class
}
\item{ HausdorffDistanceImageFilter():}{
Default Constructor that takes no arguments and initializes default
parameters
}
\item{std::string ToString() const:}{
Print ourselves out
}
\item{ ~HausdorffDistanceImageFilter():}{
Destructor
}
}
}
