/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.ConnectException;
import java.net.Socket;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.ResourceBundle;
import java.util.concurrent.atomic.AtomicBoolean;
import org.netbeans.lib.profiler.ProfilerEngineSettings;
import org.netbeans.lib.profiler.ProfilerLogger;
import org.netbeans.lib.profiler.classfile.ClassRepository;
import org.netbeans.lib.profiler.client.AppStatusHandler;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.lib.profiler.client.MonitoredData;
import org.netbeans.lib.profiler.client.RuntimeProfilingPoint;
import org.netbeans.lib.profiler.global.CalibrationDataFileIO;
import org.netbeans.lib.profiler.global.CommonConstants;
import org.netbeans.lib.profiler.global.Platform;
import org.netbeans.lib.profiler.global.ProfilingSessionStatus;
import org.netbeans.lib.profiler.instrumentation.BadLocationException;
import org.netbeans.lib.profiler.instrumentation.InstrumentationException;
import org.netbeans.lib.profiler.instrumentation.Instrumentor;
import org.netbeans.lib.profiler.marker.Marker;
import org.netbeans.lib.profiler.results.EventBufferProcessor;
import org.netbeans.lib.profiler.results.EventBufferResultsProvider;
import org.netbeans.lib.profiler.results.ProfilingResultsDispatcher;
import org.netbeans.lib.profiler.results.coderegion.CodeRegionResultsSnapshot;
import org.netbeans.lib.profiler.results.cpu.CPUCCTProvider;
import org.netbeans.lib.profiler.results.cpu.CPUResultsSnapshot;
import org.netbeans.lib.profiler.results.cpu.FlatProfileProvider;
import org.netbeans.lib.profiler.results.jdbc.JdbcCCTProvider;
import org.netbeans.lib.profiler.results.jdbc.JdbcResultsSnapshot;
import org.netbeans.lib.profiler.results.memory.AllocMemoryResultsSnapshot;
import org.netbeans.lib.profiler.results.memory.HeapHistogram;
import org.netbeans.lib.profiler.results.memory.HeapHistogramManager;
import org.netbeans.lib.profiler.results.memory.JMethodIdTable;
import org.netbeans.lib.profiler.results.memory.LivenessMemoryResultsSnapshot;
import org.netbeans.lib.profiler.results.memory.MemoryCCTProvider;
import org.netbeans.lib.profiler.results.memory.MemoryCallGraphBuilder;
import org.netbeans.lib.profiler.results.memory.MemoryResultsSnapshot;
import org.netbeans.lib.profiler.results.memory.SampledMemoryResultsSnapshot;
import org.netbeans.lib.profiler.results.threads.ThreadDump;
import org.netbeans.lib.profiler.utils.MiscUtils;
import org.netbeans.lib.profiler.utils.StringUtils;
import org.netbeans.lib.profiler.wireprotocol.CalibrationDataResponse;
import org.netbeans.lib.profiler.wireprotocol.CodeRegionCPUResultsResponse;
import org.netbeans.lib.profiler.wireprotocol.Command;
import org.netbeans.lib.profiler.wireprotocol.DefiningLoaderResponse;
import org.netbeans.lib.profiler.wireprotocol.DumpResultsResponse;
import org.netbeans.lib.profiler.wireprotocol.EventBufferDumpedCommand;
import org.netbeans.lib.profiler.wireprotocol.GetClassFileBytesCommand;
import org.netbeans.lib.profiler.wireprotocol.GetClassFileBytesResponse;
import org.netbeans.lib.profiler.wireprotocol.GetClassIdCommand;
import org.netbeans.lib.profiler.wireprotocol.GetClassIdResponse;
import org.netbeans.lib.profiler.wireprotocol.GetDefiningClassLoaderCommand;
import org.netbeans.lib.profiler.wireprotocol.GetMethodNamesForJMethodIdsCommand;
import org.netbeans.lib.profiler.wireprotocol.HeapHistogramResponse;
import org.netbeans.lib.profiler.wireprotocol.InitiateProfilingCommand;
import org.netbeans.lib.profiler.wireprotocol.InstrumentMethodGroupCommand;
import org.netbeans.lib.profiler.wireprotocol.InstrumentMethodGroupResponse;
import org.netbeans.lib.profiler.wireprotocol.InternalStatsResponse;
import org.netbeans.lib.profiler.wireprotocol.MethodNamesResponse;
import org.netbeans.lib.profiler.wireprotocol.MonitoredNumbersResponse;
import org.netbeans.lib.profiler.wireprotocol.ObjectAllocationResultsResponse;
import org.netbeans.lib.profiler.wireprotocol.Response;
import org.netbeans.lib.profiler.wireprotocol.RootClassLoadedCommand;
import org.netbeans.lib.profiler.wireprotocol.SetChangeableInstrParamsCommand;
import org.netbeans.lib.profiler.wireprotocol.SetUnchangeableInstrParamsCommand;
import org.netbeans.lib.profiler.wireprotocol.TakeHeapDumpCommand;
import org.netbeans.lib.profiler.wireprotocol.ThreadDumpResponse;
import org.netbeans.lib.profiler.wireprotocol.ThreadLivenessStatusResponse;
import org.netbeans.lib.profiler.wireprotocol.VMPropertiesResponse;
import org.netbeans.lib.profiler.wireprotocol.WireIO;

public class ProfilerClient
implements CommonConstants {
    private static final String CANNOT_OPEN_SERVER_TEMPFILE_MSG;
    private static final String PERFORMING_INSTRUMENTATION_STRING;
    private static final String INVALID_CODE_REGION_MSG;
    private static final String CLASS_NOT_FOUND_MSG;
    private static final String OUT_OF_MEMORY_MSG;
    private static final String INCORRECT_AGENT_VERSION_MSG;
    private static final String ERROR_GETTING_CALIBRATION_DATA_MSG;
    private static final String MUST_CALIBRATE_FIRST_MSG;
    private static final String MUST_CALIBRATE_FIRST_SHORT_MSG;
    private static final String INSTRUMENTATION_LIMIT_REACHED_MSG;
    private static final String CORRUPTED_TARGET_CALIBRATION_DATA_MSG;
    private static final String CONNECT_VM_MSG;
    private static final String TARGET_JVM_ERROR_MSG;
    private static final String UNSUPPORTED_JVM_MSG;
    private AppStatusHandler.ServerCommandHandler serverCommandHandler;
    private AppStatusHandler appStatusHandler;
    private CPUCCTProvider cpuCctProvider;
    private Command execInSeparateThreadCmd;
    private FlatProfileProvider flatProvider;
    private InitiateProfilingCommand commandOnStartup = null;
    private Instrumentor instrumentor;
    private MemoryCCTProvider memCctProvider;
    private JdbcCCTProvider jdbcCctProvider;
    private final Object execInSeparateThreadLock = new Object();
    private final Object forceObtainedResultsDumpLock = new Object();
    private final Object instrumentationLock = new Object();
    private final Object responseLock = new Object();
    private ObjectInputStream socketIn;
    private ObjectOutputStream socketOut;
    private ProfilerEngineSettings settings;
    private ProfilingSessionStatus status;
    private volatile Response lastResponse;
    private SeparateCmdExecutionThread separateCmdExecThread;
    private ServerListener serverListener;
    private HeapHistogramManager histogramManager;
    private Socket clientSocket;
    private WireIO wireIO;
    private int[] savedAllocatedObjectsCountResults;
    private volatile boolean forceObtainedResultsDumpCalled;
    private volatile boolean handlingEventBufferDump;
    private volatile boolean instrMethodsLimitReported;
    private boolean serverClassesInitialized;
    private volatile boolean targetVMAlive;
    private volatile boolean terminateOrDetachCommandIssued;
    private int currentAgentId = -1;
    private long instrProcessingTime;
    private long resultsStart;

    public ProfilerClient(ProfilerEngineSettings settings, ProfilingSessionStatus status, AppStatusHandler ash, AppStatusHandler.ServerCommandHandler sch) {
        this.settings = settings;
        this.status = status;
        this.appStatusHandler = ash;
        this.serverCommandHandler = sch;
        this.instrumentor = new Instrumentor(status, settings);
        this.histogramManager = new HeapHistogramManager(settings);
        EventBufferProcessor.initialize(this);
        EventBufferResultsProvider.getDefault().addDispatcher(ProfilingResultsDispatcher.getDefault());
    }

    public synchronized int[] getAllocatedObjectsCountResults() throws ClientUtils.TargetAppOrVMTerminated {
        if (!this.targetVMAlive) {
            if (this.savedAllocatedObjectsCountResults != null) {
                return this.savedAllocatedObjectsCountResults;
            }
            throw new ClientUtils.TargetAppOrVMTerminated(1);
        }
        this.savedAllocatedObjectsCountResults = null;
        this.checkForTargetVMAlive();
        this.sendSimpleCmdToServer(30);
        ObjectAllocationResultsResponse resp = (ObjectAllocationResultsResponse)this.getAndCheckLastResponse("Unknown problem when trying to get allocated object count results.");
        return resp.getResults();
    }

    public synchronized CPUResultsSnapshot getCPUProfilingResultsSnapshot() throws ClientUtils.TargetAppOrVMTerminated, CPUResultsSnapshot.NoDataAvailableException {
        return this.getCPUProfilingResultsSnapshot(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CPUResultsSnapshot getCPUProfilingResultsSnapshot(boolean dump) throws ClientUtils.TargetAppOrVMTerminated, CPUResultsSnapshot.NoDataAvailableException {
        this.checkForTargetVMAlive();
        if (dump && !this.forceObtainedResultsDump(false, 5)) {
            return null;
        }
        ProfilerClient profilerClient = this;
        synchronized (profilerClient) {
            CPUResultsSnapshot cPUResultsSnapshot;
            try {
                this.status.beginTrans(false);
                boolean twoTimeStamps = this.status.collectingTwoTimeStamps();
                int len = this.status.getNInstrMethods();
                String[] instrClassNames = new String[len];
                System.arraycopy(this.status.getInstrMethodClasses(), 0, instrClassNames, 0, len);
                String[] instrMethodNames = new String[len];
                System.arraycopy(this.status.getInstrMethodNames(), 0, instrMethodNames, 0, len);
                String[] instrMethodSigs = new String[len];
                System.arraycopy(this.status.getInstrMethodSignatures(), 0, instrMethodSigs, 0, len);
                cPUResultsSnapshot = new CPUResultsSnapshot(this.resultsStart, System.currentTimeMillis(), this.cpuCctProvider, twoTimeStamps, instrClassNames, instrMethodNames, instrMethodSigs, len);
                this.status.endTrans();
            }
            catch (Throwable throwable) {
                this.status.endTrans();
                throw throwable;
            }
            return cPUResultsSnapshot;
        }
    }

    public synchronized CodeRegionResultsSnapshot getCodeRegionProfilingResultsSnapshot() throws ClientUtils.TargetAppOrVMTerminated {
        this.checkForTargetVMAlive();
        this.sendSimpleCmdToServer(8);
        CodeRegionCPUResultsResponse resp = (CodeRegionCPUResultsResponse)this.getAndCheckLastResponse("Unknown problem when trying to get code region CPU results.");
        return new CodeRegionResultsSnapshot(this.resultsStart, System.currentTimeMillis(), resp.getResults(), this.status.timerCountsInSecond[0]);
    }

    public int getCurrentAgentId() {
        return this.currentAgentId;
    }

    public void setCurrentInstrType(int type) {
        this.status.currentInstrType = type;
    }

    public int getCurrentInstrType() {
        return this.status.currentInstrType;
    }

    public synchronized byte[] getCurrentThreadsLivenessStatus() {
        try {
            this.checkForTargetVMAlive();
            this.sendSimpleCmdToServer(16);
            ThreadLivenessStatusResponse resp = (ThreadLivenessStatusResponse)this.getAndCheckLastResponse("Unknown problem when trying to get thread liveness information.");
            return resp.getStatus();
        }
        catch (ClientUtils.TargetAppOrVMTerminated ex) {
            if (this.serverListener.isRunning()) {
                ProfilerLogger.log("in getCurrentThreadLivenessStatus(), caught exception: " + ex);
            }
            return null;
        }
    }

    public synchronized int getDefiningClassLoaderId(String className, int initiatingLoaderId) throws ClientUtils.TargetAppOrVMTerminated {
        this.checkForTargetVMAlive();
        GetDefiningClassLoaderCommand cmd = new GetDefiningClassLoaderCommand(className, initiatingLoaderId);
        this.sendComplexCmdToServer(cmd);
        DefiningLoaderResponse resp = (DefiningLoaderResponse)this.getAndCheckLastResponse("Unknown problem when trying to get a defining loader for class");
        return resp.getLoaderId();
    }

    public FlatProfileProvider getFlatProfileProvider() {
        return this.flatProvider;
    }

    public long getInstrProcessingTime() {
        return this.instrProcessingTime;
    }

    public synchronized InternalStatsResponse getInternalStats() throws ClientUtils.TargetAppOrVMTerminated {
        this.checkForTargetVMAlive();
        this.sendSimpleCmdToServer(24);
        InternalStatsResponse resp = (InternalStatsResponse)this.getLastResponse();
        return resp;
    }

    public MemoryCCTProvider getMemoryCCTProvider() {
        return this.memCctProvider;
    }

    public MemoryResultsSnapshot getMemoryProfilingResultsSnapshot() throws ClientUtils.TargetAppOrVMTerminated {
        return this.getMemoryProfilingResultsSnapshot(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public MemoryResultsSnapshot getMemoryProfilingResultsSnapshot(boolean dump) throws ClientUtils.TargetAppOrVMTerminated {
        this.checkForTargetVMAlive();
        int instrType = this.getCurrentInstrType();
        if (instrType == 7) {
            if (this.settings.getRunGCOnGetResultsInMemoryProfiling()) {
                this.runGC();
            }
            return new SampledMemoryResultsSnapshot(this.resultsStart, System.currentTimeMillis(), this);
        }
        if (dump && !this.forceObtainedResultsDump(false, 5)) {
            return null;
        }
        ProfilerClient profilerClient = this;
        synchronized (profilerClient) {
            this.memCctProvider.beginTrans(false);
            try {
                this.memCctProvider.updateInternals();
                if (instrType == 5) {
                    AllocMemoryResultsSnapshot allocMemoryResultsSnapshot = new AllocMemoryResultsSnapshot(this.resultsStart, System.currentTimeMillis(), this.memCctProvider, this);
                    return allocMemoryResultsSnapshot;
                }
                LivenessMemoryResultsSnapshot livenessMemoryResultsSnapshot = new LivenessMemoryResultsSnapshot(this.resultsStart, System.currentTimeMillis(), this.memCctProvider, this);
                return livenessMemoryResultsSnapshot;
            }
            finally {
                this.memCctProvider.endTrans();
            }
        }
    }

    public JdbcResultsSnapshot getJdbcProfilingResultsSnapshot() throws ClientUtils.TargetAppOrVMTerminated {
        return this.getJdbcProfilingResultsSnapshot(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JdbcResultsSnapshot getJdbcProfilingResultsSnapshot(boolean dump) throws ClientUtils.TargetAppOrVMTerminated {
        this.checkForTargetVMAlive();
        if (dump && !this.forceObtainedResultsDump(false, 5)) {
            return null;
        }
        ProfilerClient profilerClient = this;
        synchronized (profilerClient) {
            return new JdbcResultsSnapshot(this.resultsStart, System.currentTimeMillis(), this.jdbcCctProvider, this);
        }
    }

    public Marker getMethodMarker() {
        return this.settings.getMethodMarker();
    }

    public synchronized String[][] getMethodNamesForJMethodIds(int[] methodIds) throws ClientUtils.TargetAppOrVMTerminated {
        int PACKEDARR_ITEMS = 4;
        this.checkForTargetVMAlive();
        GetMethodNamesForJMethodIdsCommand cmd = new GetMethodNamesForJMethodIdsCommand(methodIds);
        this.sendComplexCmdToServer(cmd);
        MethodNamesResponse resp = (MethodNamesResponse)this.getAndCheckLastResponse("Unknown problem when trying to get method names for jmethodIds");
        return StringUtils.convertPackedStringsIntoStringArrays(resp.getPackedData(), resp.getPackedArrayOffsets(), 4);
    }

    public synchronized HeapHistogram getHeapHistogram() throws ClientUtils.TargetAppOrVMTerminated {
        this.checkForTargetVMAlive();
        this.sendSimpleCmdToServer(45);
        HeapHistogramResponse resp = (HeapHistogramResponse)this.getAndCheckLastResponse("Unknown problem when trying to get heap histogram");
        return this.histogramManager.getHistogram(resp);
    }

    public synchronized ThreadDump takeThreadDump() throws ClientUtils.TargetAppOrVMTerminated {
        this.checkForTargetVMAlive();
        this.sendSimpleCmdToServer(46);
        ThreadDumpResponse resp = (ThreadDumpResponse)this.getAndCheckLastResponse("Unknown problem when trying to take thread dump");
        return new ThreadDump(resp.isJDK15(), resp.getTime(), resp.getThreads());
    }

    public synchronized byte[][] getCachedClassFileBytes(String[] classes, int[] classLoaderIds) throws ClientUtils.TargetAppOrVMTerminated {
        this.checkForTargetVMAlive();
        GetClassFileBytesCommand cmd = new GetClassFileBytesCommand(classes, classLoaderIds);
        this.sendComplexCmdToServer(cmd);
        GetClassFileBytesResponse resp = (GetClassFileBytesResponse)this.getAndCheckLastResponse("Unknown problem when trying to get cached class file bytes");
        return resp.getClassBytes();
    }

    public synchronized MonitoredData getMonitoredData() {
        try {
            this.checkForTargetVMAlive();
            this.sendSimpleCmdToServer(32);
            Response resp = this.getAndCheckLastResponse("Unknown problem when trying to get memory numbers.");
            try {
                MonitoredNumbersResponse mresp = (MonitoredNumbersResponse)resp;
                return MonitoredData.getMonitoredData(mresp);
            }
            catch (ClassCastException ex) {
                MiscUtils.printErrorMessage("caught ClassCastException in getMonitoredNumbers. The real class of resp is " + resp.getClass().getName() + ", resp = " + resp);
                throw ex;
            }
        }
        catch (ClientUtils.TargetAppOrVMTerminated ex) {
            if (this.serverListener.isRunning()) {
                ProfilerLogger.log("in getMonitoredData(), caught exception: " + ex);
            }
            return null;
        }
    }

    public ProfilerEngineSettings getSettings() {
        return this.settings;
    }

    public ObjectInputStream getSocketInputStream() {
        return this.socketIn;
    }

    public ProfilingSessionStatus getStatus() {
        return this.status;
    }

    public synchronized boolean cpuResultsExist() throws ClientUtils.TargetAppOrVMTerminated {
        this.checkForTargetVMAlive();
        this.sendSimpleCmdToServer(6);
        Response resp = this.getAndCheckLastResponse("Unknown problem when trying to check for CPU profiling results.");
        return resp.yes();
    }

    public boolean currentInstrTypeIsMemoryProfiling() {
        return this.status.currentInstrType == 5 || this.status.currentInstrType == 6;
    }

    public boolean currentInstrTypeIsRecursiveCPUProfiling() {
        return this.status.currentInstrType == 3 || this.status.currentInstrType == 4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deinstrumentMemoryProfiledClasses(boolean[] unprofiledClassStatusArray) throws InstrumentationException, ClientUtils.TargetAppOrVMTerminated {
        Object object = this.instrumentationLock;
        synchronized (object) {
            if (this.getCurrentInstrType() == 0 || this.getCurrentInstrType() == 2) {
                return;
            }
            this.checkForTargetAppRunning();
            long curTime = System.currentTimeMillis();
            InstrumentMethodGroupCommand cmd = this.instrumentor.getCommandToUnprofileClasses(unprofiledClassStatusArray);
            if (!cmd.isEmpty()) {
                Response resp;
                ProfilerClient profilerClient = this;
                synchronized (profilerClient) {
                    this.sendComplexCmdToServer(cmd);
                    this.instrProcessingTime += System.currentTimeMillis() - curTime;
                    resp = this.getLastResponse();
                }
                if (!resp.isOK()) {
                    throw new InstrumentationException(resp.getErrorMessage());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepareDetachFromTargetJVM() throws ClientUtils.TargetAppOrVMTerminated {
        while (true) {
            ProfilerClient profilerClient = this;
            synchronized (profilerClient) {
                this.sendSimpleCmdToServer(44);
                Response resp = this.getAndCheckLastResponse("prepareDetachFromTargetJVM");
                if (!resp.isOK()) {
                    return;
                }
                if (resp.yes()) {
                    break;
                }
            }
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException ex) {
                MiscUtils.printWarningMessage("Interrupted while waiting for prepare detach");
            }
        }
    }

    public synchronized void detachFromTargetJVM() throws ClientUtils.TargetAppOrVMTerminated {
        this.checkForTargetVMAlive();
        this.terminateOrDetachCommandIssued = true;
        this.sendSimpleCmdToServer(25);
        try {
            this.getLastResponse();
        }
        finally {
            this.closeConnection();
            EventBufferProcessor.removeEventBufferFile();
        }
    }

    public boolean establishConnectionWithServer(int attachMode, boolean calibrationOnlyRun, AtomicBoolean cancel) {
        this.status.targetJDKVersionString = this.settings.getTargetJDKVersionString();
        return this.connectToServer(attachMode, calibrationOnlyRun, cancel);
    }

    public boolean forceObtainedResultsDump() throws ClientUtils.TargetAppOrVMTerminated {
        return this.forceObtainedResultsDump(false, 0);
    }

    public boolean forceObtainedResultsDump(boolean liveResults, int retries) throws ClientUtils.TargetAppOrVMTerminated {
        boolean dumped = false;
        int retryCounter = retries;
        do {
            if (dumped = this.forceObtainedResultsDump(liveResults)) continue;
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException e) {
                break;
            }
        } while (!dumped && --retryCounter > 0);
        if (dumped) {
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return dumped;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean forceObtainedResultsDump(boolean liveResults) throws ClientUtils.TargetAppOrVMTerminated {
        ProfilerClient profilerClient = this;
        synchronized (profilerClient) {
            Object object = this.forceObtainedResultsDumpLock;
            synchronized (object) {
                if (this.handlingEventBufferDump) {
                    return true;
                }
                this.checkForTargetVMAlive();
                this.forceObtainedResultsDumpCalled = true;
                this.sendSimpleCmdToServer(liveResults ? 40 : 27);
                DumpResultsResponse resp = (DumpResultsResponse)this.getLastResponse();
                if (resp.yes()) {
                    this.status.dumpAbsTimeStamp = resp.getDumpAbsTimeStamp();
                } else if (ProfilerLogger.isDebug()) {
                    ProfilerLogger.debug("Force Obtained Results - Received Dump Error ");
                }
                this.forceObtainedResultsDumpCalled = false;
                return resp.yes();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initiateCodeRegionInstrumentation(ClientUtils.SourceCodeSelection[] s) throws ClassNotFoundException, BadLocationException, InstrumentationException, IOException, ClassFormatError, ClientUtils.TargetAppOrVMTerminated {
        Object object = this.instrumentationLock;
        synchronized (object) {
            InitiateProfilingCommand cmd;
            this.removeAllInstrumentation();
            if (this.status.targetAppRunning && this.status.remoteProfiling && !this.getCalibrationData(true)) {
                return;
            }
            this.instrumentor.setStatusInfoFromSourceCodeSelection(s);
            this.instrumentor.setSavedSourceCodeSelection(s);
            String className = this.instrumentor.getRootClassNames()[0].replace('/', '.');
            this.commandOnStartup = cmd = new InitiateProfilingCommand(1, className, false, this.status.startProfilingPointsActive);
            this.setCurrentInstrType(1);
            if (this.status.targetAppRunning) {
                this.sendSetInstrumentationParamsCmd(false);
                String errorMessage = this.sendCommandAndGetResponse(this.commandOnStartup);
                if (errorMessage != null) {
                    this.appStatusHandler.displayWarning(errorMessage);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initiateMonitoring() throws ClientUtils.TargetAppOrVMTerminated, InstrumentationException {
        Object object = this.instrumentationLock;
        synchronized (object) {
            InitiateProfilingCommand cmd;
            this.removeAllInstrumentation();
            this.commandOnStartup = cmd = new InitiateProfilingCommand(0);
            this.setCurrentInstrType(0);
            if (this.status.targetAppRunning) {
                this.sendSetInstrumentationParamsCmd(false);
                String errorMessage = this.sendCommandAndGetResponse(this.commandOnStartup);
                if (errorMessage != null) {
                    this.appStatusHandler.displayWarning(errorMessage);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initiateMemoryProfInstrumentation(int instrType) throws ClientUtils.TargetAppOrVMTerminated, InstrumentationException {
        Object object = this.instrumentationLock;
        synchronized (object) {
            this.removeAllInstrumentation();
            if (instrType == 7) {
                this.commandOnStartup = new InitiateProfilingCommand(7);
            } else {
                String[] rootClassNames = new String[]{this.settings.getMainClassName()};
                this.commandOnStartup = this.createInitiateInstrumnetation(instrType, rootClassNames, false, this.status.startProfilingPointsActive);
            }
            this.setCurrentInstrType(instrType);
            if (this.status.targetAppRunning) {
                this.sendSetInstrumentationParamsCmd(false);
                String errorMessage = this.sendCommandAndGetResponse(this.commandOnStartup);
                if (errorMessage != null) {
                    this.appStatusHandler.displayWarning(errorMessage);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initiateRecursiveCPUProfInstrumentation(ClientUtils.SourceCodeSelection[] s) throws ClassNotFoundException, BadLocationException, InstrumentationException, IOException, ClassFormatError, ClientUtils.TargetAppOrVMTerminated {
        Object object = this.instrumentationLock;
        synchronized (object) {
            InitiateProfilingCommand cmd;
            this.removeAllInstrumentation();
            if (this.status.targetAppRunning && this.status.remoteProfiling && !this.getCalibrationData(true)) {
                return;
            }
            this.instrumentor.setStatusInfoFromSourceCodeSelection(s);
            boolean instrSpawnedThreads = this.settings.getInstrumentSpawnedThreads();
            String[] rootClassNames = this.instrumentor.getRootClassNames();
            int instrType = this.settings.getCPUProfilingType() == 0 ? 3 : 4;
            this.commandOnStartup = cmd = this.createInitiateInstrumnetation(instrType, rootClassNames, instrSpawnedThreads, this.status.startProfilingPointsActive);
            this.status.setTimerTypes(this.settings.getAbsoluteTimerOn(), this.settings.getThreadCPUTimerOn());
            this.setCurrentInstrType(instrType);
            if (this.status.targetAppRunning) {
                this.sendSetInstrumentationParamsCmd(false);
                String errorMessage = this.sendCommandAndGetResponse(this.commandOnStartup);
                if (errorMessage != null) {
                    this.appStatusHandler.displayWarning(errorMessage);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initiateCPUSampling() throws ClientUtils.TargetAppOrVMTerminated, InstrumentationException {
        Object object = this.instrumentationLock;
        synchronized (object) {
            InitiateProfilingCommand cmd;
            this.removeAllInstrumentation();
            this.commandOnStartup = cmd = new InitiateProfilingCommand(2);
            this.status.setTimerTypes(this.settings.getAbsoluteTimerOn(), this.settings.getThreadCPUTimerOn());
            this.setCurrentInstrType(2);
            if (this.status.targetAppRunning) {
                this.sendSetInstrumentationParamsCmd(false);
                String errorMessage = this.sendCommandAndGetResponse(this.commandOnStartup);
                if (errorMessage != null) {
                    this.appStatusHandler.displayWarning(errorMessage);
                }
            }
        }
    }

    public synchronized boolean memoryResultsExist() {
        return this.getMemoryCCTProvider() != null && this.getMemoryCCTProvider().getStacksForClasses() != null;
    }

    public void registerCPUCCTProvider(CPUCCTProvider provider) {
        this.cpuCctProvider = provider;
    }

    public void registerFlatProfileProvider(FlatProfileProvider provider) {
        this.flatProvider = provider;
    }

    public void registerMemoryCCTProvider(MemoryCCTProvider provider) {
        this.memCctProvider = provider;
    }

    public void registerJdbcCCTProvider(JdbcCCTProvider provider) {
        this.jdbcCctProvider = provider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllInstrumentation(boolean cleanupClient) throws InstrumentationException {
        Object object = this.instrumentationLock;
        synchronized (object) {
            this.commandOnStartup = null;
            if (cleanupClient) {
                this.status.resetInstrClassAndMethodInfo();
            }
            try {
                this.clearPreviousInstrumentationInServer();
            }
            catch (ClientUtils.TargetAppOrVMTerminated targetAppOrVMTerminated) {
                // empty catch block
            }
            this.setCurrentInstrType(0);
        }
    }

    public void removeAllInstrumentation() throws InstrumentationException {
        this.removeAllInstrumentation(true);
    }

    public void resetClientData() {
        if (this.targetJVMIsAlive()) {
            return;
        }
        this.status.resetInstrClassAndMethodInfo();
        this.instrumentor.resetPerVMInstanceData();
    }

    public synchronized void resetProfilerCollectors() throws ClientUtils.TargetAppOrVMTerminated {
        this.checkForTargetVMAlive();
        this.sendSimpleCmdToServer(29);
        this.getAndCheckLastResponse("Unknown problem when trying to reset profiler collectors.");
    }

    public synchronized void resumeTargetAppThreads() throws ClientUtils.TargetAppOrVMTerminated {
        this.checkForTargetAppRunning();
        this.sendSimpleCmdToServer(11);
        this.getAndCheckLastResponse("Unknown problem when trying to resume app threads.");
    }

    public synchronized void runGC() throws ClientUtils.TargetAppOrVMTerminated {
        this.checkForTargetVMAlive();
        this.sendSimpleCmdToServer(33);
        this.getAndCheckLastResponse("Unknown problem when trying to run GC");
    }

    public void sendSetInstrumentationParamsCmd(boolean changeableOnly) throws ClientUtils.TargetAppOrVMTerminated {
        SetUnchangeableInstrParamsCommand cmd1;
        SetChangeableInstrParamsCommand cmd = new SetChangeableInstrParamsCommand(this.settings.isLockContentionMonitoringEnabled(), this.settings.getNProfiledThreadsLimit(), this.settings.getStackDepthLimit(), this.settings.getSamplingInterval(), this.settings.getAllocTrackEvery(), this.settings.getAllocStackTraceLimit(), this.settings.getRunGCOnGetResultsInMemoryProfiling(), this.settings.getExcludeWaitTime(), this.settings.getExcludeWaitTime(), this.settings.isThreadsSamplingEnabled(), this.settings.getSamplingFrequency());
        String errorMessage = this.sendCommandAndGetResponse(cmd);
        if (errorMessage != null) {
            this.appStatusHandler.displayWarning(errorMessage);
        }
        if (!changeableOnly && (errorMessage = this.sendCommandAndGetResponse(cmd1 = new SetUnchangeableInstrParamsCommand(this.status.remoteProfiling, this.settings.getAbsoluteTimerOn(), this.settings.getThreadCPUTimerOn(), this.settings.getInstrScheme(), this.settings.getCodeRegionCPUResBufSize()))) != null) {
            this.appStatusHandler.displayWarning(errorMessage);
        }
    }

    public boolean startTargetApp(boolean sendExplicitStartCommand) throws ClientUtils.TargetAppOrVMTerminated, ClientUtils.TargetAppFailedToStart {
        String error;
        this.status.resetInstrClassAndMethodInfo();
        this.instrumentor.resetPerVMInstanceData();
        this.status.setTimerTypes(this.settings.getAbsoluteTimerOn(), this.settings.getThreadCPUTimerOn());
        this.serverCommandHandler.handleServerCommand(null);
        this.checkForTargetVMAlive();
        this.instrProcessingTime = 0L;
        this.instrMethodsLimitReported = false;
        if (this.currentInstrTypeIsRecursiveCPUProfiling()) {
            this.setCurrentInstrType(this.settings.getCPUProfilingType() == 0 ? 3 : 4);
            if (this.commandOnStartup != null) {
                this.commandOnStartup.setInstrType(this.getCurrentInstrType());
            }
        }
        if (this.commandOnStartup != null) {
            this.sendSetInstrumentationParamsCmd(false);
            switch (this.getCurrentInstrType()) {
                case 1: {
                    if (!this.status.remoteProfiling || this.getCalibrationData(true)) break;
                    try {
                        this.terminateTargetJVM();
                    }
                    catch (ClientUtils.TargetAppOrVMTerminated targetAppOrVMTerminated) {
                        // empty catch block
                    }
                    return false;
                }
                case 3: 
                case 4: {
                    if (this.status.remoteProfiling && !this.getCalibrationData(true)) {
                        try {
                            this.terminateTargetJVM();
                        }
                        catch (ClientUtils.TargetAppOrVMTerminated targetAppOrVMTerminated) {
                            // empty catch block
                        }
                        return false;
                    }
                    if (!this.settings.getInstrumentMethodInvoke() || (error = this.sendSimpleCommandAndGetResponse(20)) == null) break;
                    throw new ClientUtils.TargetAppFailedToStart(error);
                }
            }
            String errorMessage = this.sendCommandAndGetResponse(this.commandOnStartup);
            if (errorMessage != null) {
                this.appStatusHandler.displayWarning("Profiler Agent Error: " + errorMessage);
            }
            this.commandOnStartup = null;
        } else {
            this.setCurrentInstrType(0);
        }
        if (sendExplicitStartCommand && (error = this.sendSimpleCommandAndGetResponse(2)) != null) {
            throw new ClientUtils.TargetAppFailedToStart(error);
        }
        this.status.targetAppRunning = true;
        this.checkForInstrMethodsLimitReached();
        EventBufferResultsProvider.getDefault().startup(this);
        return true;
    }

    public synchronized void suspendTargetAppThreads() throws ClientUtils.TargetAppOrVMTerminated {
        this.checkForTargetAppRunning();
        this.sendSimpleCmdToServer(10);
        this.getAndCheckLastResponse("Unknown problem when trying to suspend app threads.");
    }

    public synchronized boolean takeHeapDump(String outputFile) throws ClientUtils.TargetAppOrVMTerminated {
        this.checkForTargetVMAlive();
        this.sendComplexCmdToServer(new TakeHeapDumpCommand(outputFile));
        Response resp = this.getAndCheckLastResponse("takeHeapDump.");
        return resp.isOK();
    }

    public boolean targetAppIsRunning() {
        return this.status.targetAppRunning;
    }

    public boolean targetJVMIsAlive() {
        return this.targetVMAlive;
    }

    public synchronized void terminateTargetJVM() throws ClientUtils.TargetAppOrVMTerminated {
        this.checkForTargetVMAlive();
        this.terminateOrDetachCommandIssued = true;
        this.sendSimpleCmdToServer(12);
        if (!this.getLastResponse().isOK()) {
            throw new ClientUtils.TargetAppOrVMTerminated(1, "Target JVM terminated or not responding");
        }
        this.closeConnection();
    }

    private synchronized Response getAndCheckLastResponse(String errMessage) throws ClientUtils.TargetAppOrVMTerminated {
        Response resp = this.getLastResponse();
        if (!resp.isOK()) {
            MiscUtils.printErrorMessage("error in getAndCheckLastResponse: for " + resp + " got error message: " + resp.getErrorMessage() + " and context message " + errMessage);
        }
        return resp;
    }

    private synchronized boolean getCalibrationData(boolean getStoredData) throws ClientUtils.TargetAppOrVMTerminated {
        int cmdType = getStoredData ? 37 : 34;
        this.sendSimpleCmdToServer(cmdType);
        Response resp = this.getLastResponse();
        if (!resp.isOK()) {
            String msg = resp.getErrorMessage();
            if (getStoredData) {
                msg = MessageFormat.format(CORRUPTED_TARGET_CALIBRATION_DATA_MSG, msg);
            }
            this.appStatusHandler.displayError(msg);
            return false;
        }
        CalibrationDataResponse cdr = (CalibrationDataResponse)resp;
        this.status.methodEntryExitCallTime = cdr.getMethodEntryExitCallTime();
        this.status.methodEntryExitInnerTime = cdr.getMethodEntryExitInnerTime();
        this.status.methodEntryExitOuterTime = cdr.getMethodEntryExitOuterTime();
        this.status.timerCountsInSecond = cdr.getTimerCountsInSecond();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setLastResponse(Response r) {
        Object object = this.responseLock;
        synchronized (object) {
            this.lastResponse = r;
            try {
                this.responseLock.notify();
            }
            catch (IllegalMonitorStateException ex) {
                MiscUtils.internalError("ProfilerClient.setLastResponse()");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized Response getLastResponse() throws ClientUtils.TargetAppOrVMTerminated {
        Response res;
        this.checkForTargetVMAlive();
        Object object = this.responseLock;
        synchronized (object) {
            while (this.lastResponse == null) {
                long start = System.currentTimeMillis();
                try {
                    this.responseLock.wait(60000L);
                }
                catch (InterruptedException ex) {
                    MiscUtils.internalError("InterruptedException in ProfilerClient.getLastResponse()");
                }
                if (!this.targetVMAlive) {
                    this.status.targetAppRunning = false;
                    throw new ClientUtils.TargetAppOrVMTerminated(1);
                }
                if (this.lastResponse != null || this.wireIO.wasAlive() >= start || this.appStatusHandler.confirmWaitForConnectionReply()) continue;
                this.status.targetAppRunning = false;
                this.targetVMAlive = false;
                throw new ClientUtils.TargetAppOrVMTerminated(1);
            }
            res = this.lastResponse;
            this.lastResponse = null;
        }
        return res;
    }

    private boolean setVMProperties(VMPropertiesResponse resp, boolean terminateOnError) {
        String jdkVersionString;
        if (resp.getAgentVersion() != 18) {
            this.appStatusHandler.displayWarning(INCORRECT_AGENT_VERSION_MSG);
        }
        if (!MiscUtils.isSupportedRunningJVMVersion(jdkVersionString = resp.getJDKVersionString())) {
            String message = MessageFormat.format(UNSUPPORTED_JVM_MSG, jdkVersionString);
            this.appStatusHandler.displayErrorAndWaitForConfirm(message);
            try {
                if (terminateOnError) {
                    this.terminateTargetJVM();
                } else {
                    this.detachFromTargetJVM();
                }
            }
            catch (ClientUtils.TargetAppOrVMTerminated targetAppOrVMTerminated) {
                // empty catch block
            }
            return false;
        }
        String jdkVersionName = Platform.getJDKVersionString(jdkVersionString);
        this.settings.setTargetJDKVersionString(jdkVersionName);
        this.status.targetJDKVersionString = jdkVersionName;
        this.status.fullTargetJDKVersionString = jdkVersionString;
        this.currentAgentId = resp.getAgentId();
        if (!this.status.remoteProfiling) {
            int res = CalibrationDataFileIO.readSavedCalibrationData(this.status);
            if (res < 0) {
                String message = MessageFormat.format(ERROR_GETTING_CALIBRATION_DATA_MSG, CalibrationDataFileIO.getErrorMessage());
                this.appStatusHandler.displayErrorAndWaitForConfirm(message);
                return false;
            }
            if (res > 0) {
                this.appStatusHandler.displayErrorWithDetailsAndWaitForConfirm(MUST_CALIBRATE_FIRST_SHORT_MSG, MUST_CALIBRATE_FIRST_MSG);
                try {
                    if (terminateOnError) {
                        this.terminateTargetJVM();
                    } else {
                        this.detachFromTargetJVM();
                    }
                }
                catch (ClientUtils.TargetAppOrVMTerminated targetAppOrVMTerminated) {
                    // empty catch block
                }
                return false;
            }
        }
        this.status.jvmArguments = resp.getJVMArguments();
        this.status.javaCommand = resp.getJavaCommand();
        this.status.targetMachineOSName = resp.getTargetMachineOSName();
        this.status.maxHeapSize = resp.getMaxHeapSize();
        this.status.startupTimeMillis = resp.getStartupTimeMillis();
        this.status.startupTimeInCounts = resp.getStartupTimeInCounts();
        this.status.canInstrumentConstructor = resp.canInstrumentConstructor();
        if (!this.status.remoteProfiling && this.settings.getTargetJDKVersionString() != "jdk19" && this.settings.getTargetJDKVersionString() != "jdk110") {
            this.settings.setWorkingDir(resp.getWorkingDir());
            this.settings.setVMClassPaths(resp.getJavaClassPath(), resp.getJavaExtDirs(), resp.getBootClassPath());
            ClassRepository.initClassPaths(this.settings.getWorkingDir(), this.settings.getVMClassPaths());
        }
        return true;
    }

    private void checkForInstrMethodsLimitReached() {
        if (this.status.getStartingMethodId() >= 65535 && !this.instrMethodsLimitReported && this.status.targetAppRunning) {
            this.appStatusHandler.displayWarningAndWaitForConfirm(INSTRUMENTATION_LIMIT_REACHED_MSG);
            this.instrMethodsLimitReported = true;
        }
    }

    private void checkForTargetAppRunning() throws ClientUtils.TargetAppOrVMTerminated {
        if (!this.status.targetAppRunning) {
            this.serverCommandHandler.handleServerCommand(null);
            throw new ClientUtils.TargetAppOrVMTerminated(2);
        }
    }

    private void checkForTargetVMAlive() throws ClientUtils.TargetAppOrVMTerminated {
        if (!this.targetVMAlive) {
            this.serverCommandHandler.handleServerCommand(null);
            throw new ClientUtils.TargetAppOrVMTerminated(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearPreviousInstrumentationInServer() throws InstrumentationException, ClientUtils.TargetAppOrVMTerminated {
        Response resp;
        String error;
        this.checkForTargetAppRunning();
        if (this.handlingEventBufferDump) {
            while (this.handlingEventBufferDump) {
                try {
                    Thread.sleep(20L);
                }
                catch (Exception exception) {}
            }
        }
        if ((error = this.sendSimpleCommandAndGetResponse(9)) != null) {
            throw new InstrumentationException(error);
        }
        long curTime = System.currentTimeMillis();
        InstrumentMethodGroupCommand cmd = this.instrumentor.createClearAllInstrumentationCommand();
        ProfilerClient profilerClient = this;
        synchronized (profilerClient) {
            this.sendComplexCmdToServer(cmd);
            this.instrProcessingTime += System.currentTimeMillis() - curTime;
            resp = this.getLastResponse();
        }
        if (!resp.isOK()) {
            throw new InstrumentationException(resp.getErrorMessage());
        }
    }

    private void closeConnection() {
        if (!this.serverListener.isRunning()) {
            return;
        }
        try {
            this.status.targetAppRunning = false;
            this.targetVMAlive = false;
            this.serverListener.shutdown();
            this.setLastResponse(null);
            this.socketOut.close();
            this.socketIn.close();
            this.clientSocket.close();
            try {
                Thread.sleep(400L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        catch (IOException iOException) {
        }
        finally {
            EventBufferResultsProvider.getDefault().shutdown();
            EventBufferProcessor.removeEventBufferFile();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean connectToServer(int attachMode, boolean calibrationOnlyRun, final AtomicBoolean cancel) {
        String taHost;
        this.status.targetAppRunning = false;
        this.targetVMAlive = false;
        this.terminateOrDetachCommandIssued = false;
        String string = taHost = attachMode == 1 ? this.settings.getRemoteHost() : "";
        if (taHost.isEmpty()) {
            this.status.remoteProfiling = false;
            taHost = "127.0.0.1";
        } else {
            this.status.remoteProfiling = true;
        }
        String host = taHost;
        int port = this.settings.getPortNo();
        int noOfCycles = 600;
        Runnable cancelHandler = new Runnable(){
            final /* synthetic */ ProfilerClient this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                cancel.set(true);
                this.this$0.serverListener.cancel();
            }
        };
        try (AppStatusHandler.AsyncDialog waitDialog = this.appStatusHandler.getAsyncDialogInstance(CONNECT_VM_MSG, true, cancelHandler);){
            this.serverListener = new ServerListener();
            waitDialog.display();
            this.serverListener.start();
            while (!cancel.get()) {
                try {
                    this.clientSocket = new Socket(host, port);
                    this.clientSocket.setSoTimeout(0);
                    this.clientSocket.setTcpNoDelay(true);
                    this.socketOut = new ObjectOutputStream(this.clientSocket.getOutputStream());
                    this.socketIn = new ObjectInputStream(this.clientSocket.getInputStream());
                    this.wireIO = new WireIO(this.socketOut, this.socketIn);
                    this.targetVMAlive = true;
                    this.serverListener.startRunning();
                }
                catch (ConnectException ex) {
                    try {
                        Thread.sleep(250L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (--noOfCycles != 0) continue;
                    MiscUtils.printWarningMessage("timed out while trying to connect to the target JVM.");
                    this.serverListener.cancel();
                }
                break;
            }
        }
        if (!this.serverListener.isRunning()) {
            MiscUtils.printErrorMessage("connection with server not open");
            return false;
        }
        try {
            String error = this.sendSimpleCommandAndGetResponse(1);
            if (error != null) {
                this.targetVMAlive = false;
                MiscUtils.printErrorMessage("got error message from agent:" + error);
                return false;
            }
            if (calibrationOnlyRun) {
                boolean res = this.getCalibrationData(false);
                try {
                    this.terminateTargetJVM();
                }
                catch (ClientUtils.TargetAppOrVMTerminated e) {
                    ProfilerLogger.log("terminateTargetJVM failed with TargetAppOrVMTerminated exception:");
                    ProfilerLogger.log(e.getMessage());
                }
                return res;
            }
            boolean terminateOnError = attachMode != 2;
            ProfilerClient profilerClient = this;
            synchronized (profilerClient) {
                this.sendSimpleCmdToServer(28);
                Response aResponse = this.getLastResponse();
                if (!(aResponse instanceof VMPropertiesResponse)) {
                    System.err.println("SEVERE: Received " + aResponse.getClass().getName() + "(" + aResponse.toString() + ") instead of VMPropertiesResponse");
                }
                if (!this.setVMProperties((VMPropertiesResponse)aResponse, terminateOnError)) {
                    return false;
                }
            }
            this.serverClassesInitialized = false;
            error = this.sendCommandAndGetResponse(new InitiateProfilingCommand(3, "*FAKE_CLASS_FOR_INTERNAL_TEST*"));
            if (error != null) {
                MiscUtils.printErrorMessage("got error message from agent:" + error);
                this.targetVMAlive = false;
                return false;
            }
            noOfCycles = 20;
            while (!this.serverClassesInitialized && --noOfCycles > 0) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
            if (!this.serverClassesInitialized) {
                MiscUtils.printErrorMessage("timed out while trying to initialize internals in the target JVM.");
                this.targetVMAlive = false;
                return false;
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        catch (ClientUtils.TargetAppOrVMTerminated ex) {
            this.targetVMAlive = false;
            MiscUtils.printWarningMessage("target app terminated:" + ex.getMessage());
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeInSeparateThread(Command cmd) {
        Object object = this.execInSeparateThreadLock;
        synchronized (object) {
            this.execInSeparateThreadCmd = cmd;
            try {
                this.execInSeparateThreadLock.notify();
            }
            catch (IllegalMonitorStateException ex) {
                MiscUtils.internalError("ProfilerClient.executeInSeparateThread()");
            }
        }
    }

    private void startSeparateCmdExecThread() {
        assert (this.separateCmdExecThread == null);
        SeparateCmdExecutionThread t = new SeparateCmdExecutionThread();
        t.setDaemon(true);
        t.start();
        this.separateCmdExecThread = t;
    }

    private void stopSeparateCmdExecThread() {
        assert (this.separateCmdExecThread != null);
        this.executeInSeparateThread(null);
        this.separateCmdExecThread = null;
    }

    private boolean handleFakeClassLoad(RootClassLoadedCommand cmd) {
        if (cmd.getAllLoadedClassNames()[0].equals("*FAKE_CLASS_1*")) {
            this.sendComplexRespToServer(new InstrumentMethodGroupResponse(new String[]{"*FAKE_CLASS_1*", "*FAKE_CLASS_2*"}, new int[]{0, 0}, new byte[][]{{0}, {0}}, null, 0));
            this.serverClassesInitialized = true;
            return true;
        }
        return false;
    }

    private void handleIOExceptionOnSend(IOException ex) throws ClientUtils.TargetAppOrVMTerminated {
        this.checkForTargetVMAlive();
        this.appStatusHandler.displayError(MessageFormat.format(TARGET_JVM_ERROR_MSG, ex.getMessage()));
        this.closeConnection();
        throw new ClientUtils.TargetAppOrVMTerminated(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void instrumentMethodGroupFollowUp(Command cmd) {
        Object object = this.instrumentationLock;
        synchronized (object) {
            long curTime = System.currentTimeMillis();
            InstrumentMethodGroupResponse imgr = this.instrumentor.createFollowUpInstrumentMethodGroupResponse(cmd);
            this.instrProcessingTime += System.currentTimeMillis() - curTime;
            this.sendComplexRespToServer(imgr);
        }
        this.checkForInstrMethodsLimitReached();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void instrumentMethodGroupFromRoot(RootClassLoadedCommand cmd) {
        Object object = this.instrumentationLock;
        synchronized (object) {
            AppStatusHandler.AsyncDialog waitDialog = null;
            try {
                InstrumentMethodGroupResponse imgr;
                if (!this.serverClassesInitialized && this.handleFakeClassLoad(cmd)) {
                    return;
                }
                this.appStatusHandler.pauseLiveUpdates();
                if (this.status.targetAppRunning) {
                    waitDialog = this.appStatusHandler.getAsyncDialogInstance(PERFORMING_INSTRUMENTATION_STRING, true, null);
                    waitDialog.display();
                }
                try {
                    long curTime = System.currentTimeMillis();
                    imgr = this.instrumentor.createInitialInstrumentMethodGroupResponse(cmd);
                    this.instrProcessingTime += System.currentTimeMillis() - curTime;
                }
                catch (BadLocationException ex) {
                    imgr = new InstrumentMethodGroupResponse((Object)null);
                    this.appStatusHandler.displayError(INVALID_CODE_REGION_MSG);
                }
                catch (ClassNotFoundException ex) {
                    imgr = new InstrumentMethodGroupResponse((Object)null);
                    if (this.getCurrentInstrType() == 1) {
                        this.appStatusHandler.displayError(MessageFormat.format(CLASS_NOT_FOUND_MSG, ex.getMessage()));
                    }
                    MiscUtils.printErrorMessage("problem in instrumentMethodGroupFromRoot: " + ex);
                }
                this.sendComplexRespToServer(imgr);
            }
            finally {
                if (waitDialog != null) {
                    waitDialog.close();
                }
                this.appStatusHandler.resumeLiveUpdates();
            }
        }
    }

    private void readAndProcessProfilingResults(EventBufferDumpedCommand cmd) {
        int bufSize = cmd.getBufSize();
        if (bufSize == 0) {
            this.sendSimpleRespToServer(true, null);
            return;
        }
        this.handlingEventBufferDump = true;
        if (!this.status.remoteProfiling && !this.forceObtainedResultsDumpCalled) {
            this.executeInSeparateThread(cmd);
            this.handlingEventBufferDump = false;
        } else {
            byte[] buf = EventBufferProcessor.readDataAndPrepareForProcessing(cmd);
            EventBufferResultsProvider.getDefault().dataReady(buf, this.getCurrentInstrType());
            this.handlingEventBufferDump = false;
            this.sendSimpleRespToServer(true, null);
            this.forceObtainedResultsDumpCalled = false;
        }
    }

    private synchronized String sendCommandAndGetResponse(Command cmd) throws ClientUtils.TargetAppOrVMTerminated {
        this.sendComplexCmdToServer(cmd);
        Response resp = this.getLastResponse();
        if (!resp.isOK()) {
            MiscUtils.printErrorMessage("error in sendCommandAndGetResponse: for cmd = " + cmd + " and resp = " + resp + " got error message: " + resp.getErrorMessage());
            return resp.getErrorMessage();
        }
        return null;
    }

    private void sendComplexCmdToServer(Command cmd) throws ClientUtils.TargetAppOrVMTerminated {
        try {
            this.wireIO.sendComplexCommand(cmd);
        }
        catch (IOException ex) {
            this.handleIOExceptionOnSend(ex);
        }
    }

    private void sendComplexRespToServer(Response resp) {
        try {
            this.wireIO.sendComplexResponse(resp);
        }
        catch (IOException ex) {
            MiscUtils.printErrorMessage("exception when trying to send a response: " + ex);
            try {
                this.handleIOExceptionOnSend(ex);
            }
            catch (ClientUtils.TargetAppOrVMTerminated targetAppOrVMTerminated) {
                // empty catch block
            }
        }
    }

    private void sendSimpleCmdToServer(int cmdType) throws ClientUtils.TargetAppOrVMTerminated {
        try {
            this.wireIO.sendSimpleCommand(cmdType);
        }
        catch (IOException ex) {
            this.handleIOExceptionOnSend(ex);
        }
    }

    private synchronized String sendSimpleCommandAndGetResponse(int cmdType) throws ClientUtils.TargetAppOrVMTerminated {
        this.sendSimpleCmdToServer(cmdType);
        Response resp = this.getLastResponse();
        if (!resp.isOK()) {
            MiscUtils.printErrorMessage("error in sendCommandAndGetResponse: for cmdType = " + cmdType + " and resp = " + resp + " got error message: " + resp.getErrorMessage());
            return resp.getErrorMessage();
        }
        return null;
    }

    private void sendSimpleRespToServer(boolean val, String errorMessage) {
        try {
            this.wireIO.sendSimpleResponse(val, errorMessage);
        }
        catch (IOException ex) {
            try {
                this.handleIOExceptionOnSend(ex);
            }
            catch (ClientUtils.TargetAppOrVMTerminated targetAppOrVMTerminated) {
                // empty catch block
            }
        }
    }

    private InitiateProfilingCommand createInitiateInstrumnetation(int instrType, String[] classNames, boolean instrSpawnedThreads, boolean startProfilingPointsActive) {
        Object[] points = this.settings.getRuntimeProfilingPoints();
        String[] profilingPointHandlers = new String[points.length];
        String[] profilingPointInfos = new String[points.length];
        int[] profilingPointIDs = new int[points.length];
        Arrays.sort(points);
        for (int i = 0; i < points.length; ++i) {
            Object point = points[i];
            profilingPointIDs[i] = ((RuntimeProfilingPoint)point).getId();
            profilingPointHandlers[i] = ((RuntimeProfilingPoint)point).getServerHandlerClass();
            profilingPointInfos[i] = ((RuntimeProfilingPoint)point).getServerInfo();
        }
        return new InitiateProfilingCommand(instrType, classNames, profilingPointIDs, profilingPointHandlers, profilingPointInfos, instrSpawnedThreads, startProfilingPointsActive);
    }

    static /* synthetic */ int[] access$1502(ProfilerClient x0, int[] x1) {
        x0.savedAllocatedObjectsCountResults = x1;
        return x1;
    }

    static {
        ResourceBundle messages = ResourceBundle.getBundle("org.netbeans.lib.profiler.Bundle");
        CANNOT_OPEN_SERVER_TEMPFILE_MSG = messages.getString("ProfilerClient_CannotOpenServerTempFileMsg");
        PERFORMING_INSTRUMENTATION_STRING = messages.getString("ProfilerClient_PerformingInstrumentationString");
        INVALID_CODE_REGION_MSG = messages.getString("ProfilerClient_InvalidCodeRegionMsg");
        CLASS_NOT_FOUND_MSG = messages.getString("ProfilerClient_ClassNotFoundMsg");
        OUT_OF_MEMORY_MSG = messages.getString("ProfilerClient_OutOfMemoryMsg");
        INCORRECT_AGENT_VERSION_MSG = messages.getString("ProfilerClient_IncorrectAgentVersionMsg");
        ERROR_GETTING_CALIBRATION_DATA_MSG = messages.getString("ProfilerClient_ErrorGettingCalibrationDataMsg");
        MUST_CALIBRATE_FIRST_MSG = messages.getString("ProfilerClient_MustCalibrateFirstMsg");
        MUST_CALIBRATE_FIRST_SHORT_MSG = messages.getString("ProfilerClient_MustCalibrateFirstShortMsg");
        INSTRUMENTATION_LIMIT_REACHED_MSG = messages.getString("ProfilerClient_InstrumentationLimitReachedMsg");
        CORRUPTED_TARGET_CALIBRATION_DATA_MSG = messages.getString("ProfilerClient_CorruptedTargetCalibrationDataMsg");
        CONNECT_VM_MSG = messages.getString("ProfilerClient_ConnectVmMsg");
        TARGET_JVM_ERROR_MSG = messages.getString("ProfilerClient_TargetJvmErrorMsg");
        UNSUPPORTED_JVM_MSG = messages.getString("ProfilerClient_UnsupportedJvmMsg");
    }

    private class ServerListener
    extends Thread {
        private final Object startedFlagLock = new Object();
        private int startedFlag = 0;

        private ServerListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isRunning() {
            Object object = this.startedFlagLock;
            synchronized (object) {
                return this.startedFlag == 1;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cancel() {
            Object object = this.startedFlagLock;
            synchronized (object) {
                this.startedFlag = -1;
                this.startedFlagLock.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            Object object = this.startedFlagLock;
            synchronized (object) {
                while (this.startedFlag == 0) {
                    try {
                        this.startedFlagLock.wait(500L);
                    }
                    catch (InterruptedException e) {
                        this.startedFlag = -1;
                    }
                }
                if (this.startedFlag == -1) {
                    return;
                }
            }
            ProfilerClient.this.startSeparateCmdExecThread();
            try {
                while (ProfilerClient.this.targetVMAlive) {
                    try {
                        Object o = ProfilerClient.this.wireIO.receiveCommandOrResponse();
                        if (o == null) {
                            ProfilerClient.this.closeConnection();
                            continue;
                        }
                        if (o instanceof Command) {
                            this.handleServerCommand((Command)o);
                            continue;
                        }
                        ProfilerClient.this.setLastResponse((Response)o);
                    }
                    catch (IOException ex) {
                        if (!ProfilerClient.this.targetVMAlive || ProfilerClient.this.terminateOrDetachCommandIssued) continue;
                        MiscUtils.printErrorMessage("exception while trying to get response from the target JVM:\n" + ex);
                        ProfilerClient.this.closeConnection();
                    }
                }
                return;
            }
            finally {
                ProfilerClient.this.stopSeparateCmdExecThread();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void shutdown() {
            Object object = this.startedFlagLock;
            synchronized (object) {
                this.startedFlag = 0;
                this.startedFlagLock.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void startRunning() {
            Object object = this.startedFlagLock;
            synchronized (object) {
                this.startedFlag = 1;
                this.startedFlagLock.notifyAll();
            }
        }

        private void handleServerCommand(Command cmd) {
            switch (cmd.getType()) {
                case 18: {
                    ((ProfilerClient)ProfilerClient.this).status.targetAppRunning = false;
                    new Thread(){

                        @Override
                        public void run() {
                            try {
                                if (ProfilerClient.this.currentInstrTypeIsRecursiveCPUProfiling() || ProfilerClient.this.currentInstrTypeIsMemoryProfiling()) {
                                    ProfilerClient.this.forceObtainedResultsDump(false, 15);
                                }
                                if (ProfilerClient.this.currentInstrTypeIsMemoryProfiling()) {
                                    ProfilerClient.access$1502(ProfilerClient.this, ProfilerClient.this.getAllocatedObjectsCountResults());
                                    if (ProfilerClient.this.memCctProvider instanceof MemoryCallGraphBuilder) {
                                        ((MemoryCallGraphBuilder)ProfilerClient.this.memCctProvider).updateInternals();
                                    }
                                }
                                ((ProfilerClient)ProfilerClient.this).status.savedInternalStats = ProfilerClient.this.getInternalStats();
                                ProfilerClient.this.appStatusHandler.handleShutdown();
                                ProfilerClient.this.sendSimpleCmdToServer(15);
                            }
                            catch (ClientUtils.TargetAppOrVMTerminated targetAppOrVMTerminated) {
                                // empty catch block
                            }
                        }
                    }.start();
                    break;
                }
                case 19: {
                    ProfilerClient.this.targetVMAlive = false;
                    ((ProfilerClient)ProfilerClient.this).status.targetAppRunning = false;
                    EventBufferProcessor.removeEventBufferFile();
                    break;
                }
                case 17: {
                    ProfilerClient.this.executeInSeparateThread(cmd);
                    break;
                }
                case 3: 
                case 22: 
                case 23: {
                    ProfilerClient.this.executeInSeparateThread(cmd);
                    break;
                }
                case 26: {
                    EventBufferDumpedCommand ebdCmd = (EventBufferDumpedCommand)cmd;
                    String bufferName = ebdCmd.getEventBufferFileName();
                    if (bufferName.length() > 0) {
                        if (!EventBufferProcessor.bufFileExists() && !EventBufferProcessor.setEventBufferFile(bufferName)) {
                            ProfilerClient.this.appStatusHandler.displayError(MessageFormat.format(CANNOT_OPEN_SERVER_TEMPFILE_MSG, ebdCmd.getEventBufferFileName()));
                        }
                        JMethodIdTable.reset();
                    }
                    ProfilerClient.this.readAndProcessProfilingResults(ebdCmd);
                    break;
                }
                case 36: {
                    ProfilerClient.this.executeInSeparateThread(cmd);
                    break;
                }
                case 38: {
                    ProfilerClient.this.resultsStart = System.currentTimeMillis();
                    break;
                }
                case 42: {
                    GetClassIdCommand cidCmd = (GetClassIdCommand)cmd;
                    int classId = ProfilerClient.this.instrumentor.getClassId(cidCmd.getClassName(), cidCmd.getClassLoaderId());
                    ProfilerClient.this.sendComplexRespToServer(new GetClassIdResponse(classId != -1, classId));
                    break;
                }
            }
            if (!ProfilerClient.this.targetVMAlive) {
                ProfilerClient.this.closeConnection();
            }
            ProfilerClient.this.serverCommandHandler.handleServerCommand(cmd);
        }
    }

    private class SeparateCmdExecutionThread
    extends Thread {
        private SeparateCmdExecutionThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.setName("*** JFluid Separate Command Execution Thread");
            Object object = ProfilerClient.this.execInSeparateThreadLock;
            synchronized (object) {
                while (true) {
                    try {
                        ProfilerClient.this.execInSeparateThreadLock.wait();
                    }
                    catch (InterruptedException ex) {
                        MiscUtils.internalError("ProfilerClient.SpecialExecutionThread.run()");
                    }
                    if (ProfilerClient.this.execInSeparateThreadCmd == null) {
                        return;
                    }
                    Command cmd = ProfilerClient.this.execInSeparateThreadCmd;
                    ProfilerClient.this.execInSeparateThreadCmd = null;
                    switch (cmd.getType()) {
                        case 17: {
                            ProfilerClient.this.instrumentMethodGroupFromRoot((RootClassLoadedCommand)cmd);
                            break;
                        }
                        case 3: 
                        case 22: 
                        case 23: {
                            ProfilerClient.this.instrumentMethodGroupFollowUp(cmd);
                            break;
                        }
                        case 26: {
                            EventBufferDumpedCommand bufferDumpedCmd = (EventBufferDumpedCommand)cmd;
                            byte[] buf = EventBufferProcessor.readDataAndPrepareForProcessing(bufferDumpedCmd);
                            EventBufferResultsProvider.getDefault().dataReady(buf, ProfilerClient.this.getCurrentInstrType());
                            ProfilerClient.this.sendSimpleRespToServer(true, null);
                            break;
                        }
                        case 36: {
                            ProfilerClient profilerClient = ProfilerClient.this;
                            synchronized (profilerClient) {
                                Object object2 = ProfilerClient.this.forceObtainedResultsDumpLock;
                                synchronized (object2) {
                                    if (ProfilerClient.this.memCctProvider != null) {
                                        ProfilerClient.this.memCctProvider.updateInternals();
                                    }
                                    ProfilerClient.this.sendSimpleRespToServer(true, null);
                                }
                            }
                        }
                    }
                }
            }
        }
    }
}

