/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Properties;
import org.netbeans.api.project.Project;
import org.netbeans.modules.gradle.Bundle;
import org.netbeans.modules.gradle.api.NbGradleProject;
import org.netbeans.modules.gradle.api.execute.GradleDistributionManager;
import org.netbeans.modules.gradle.spi.execute.GradleDistributionProvider;
import org.netbeans.modules.gradle.spi.execute.GradleJavaPlatformProvider;
import org.netbeans.spi.project.ui.ProjectProblemsProvider;

public final class GradleJavaCompatProblemsProvider
implements ProjectProblemsProvider {
    private final PropertyChangeSupport support = new PropertyChangeSupport(this);
    private final Project project;
    private final PropertyChangeListener listener;

    public GradleJavaCompatProblemsProvider(Project project) {
        this.project = project;
        this.listener = evt -> {
            if ("ProjectInfo".equals(evt.getPropertyName())) {
                this.support.firePropertyChange("problems", null, null);
            }
        };
        NbGradleProject.addPropertyChangeListener(project, this.listener);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(listener);
    }

    public Collection<? extends ProjectProblemsProvider.ProjectProblem> getProblems() {
        int javaVersion;
        GradleDistributionManager.GradleDistribution dist = this.getGradleDistribution();
        if (!dist.isCompatibleWithJava(javaVersion = this.getJavaVersion())) {
            GradleDistributionManager.GradleDistribution compatDist = GradleDistributionManager.get(dist.getGradleUserHome()).defaultDistribution();
            ProjectProblemsProvider.ProjectProblem problem = ProjectProblemsProvider.ProjectProblem.createWarning((String)Bundle.LBL_JavaVersionMismatch(), (String)Bundle.TXT_JavaVersionMismatch(javaVersion, dist.lastSupportedJava(), dist.getVersion(), compatDist.getVersion()));
            return Collections.singleton(problem);
        }
        return Collections.emptySet();
    }

    private GradleDistributionManager.GradleDistribution getGradleDistribution() {
        GradleDistributionManager.GradleDistribution dist = null;
        GradleDistributionProvider pvd = (GradleDistributionProvider)this.project.getLookup().lookup(GradleDistributionProvider.class);
        if (pvd != null) {
            dist = pvd.getGradleDistribution();
        }
        return dist != null ? dist : GradleDistributionManager.get().defaultDistribution();
    }

    private int getJavaVersion() {
        File javaHome = null;
        GradleJavaPlatformProvider pvd = (GradleJavaPlatformProvider)this.project.getLookup().lookup(GradleJavaPlatformProvider.class);
        try {
            javaHome = pvd != null ? pvd.getJavaHome() : null;
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        if (javaHome == null) {
            String javaVersion = System.getProperty("java.specification.version");
            int dot = javaVersion.indexOf(46);
            if (dot > 0) {
                javaVersion = javaVersion.substring(0, dot);
            }
            return Integer.parseInt(javaVersion);
        }
        return GradleJavaCompatProblemsProvider.getJavaMajorVersion(javaHome);
    }

    private static int getJavaMajorVersion(File javaHome) {
        int ret = 8;
        File release = new File(javaHome, "release");
        if (release.isFile()) {
            Properties releasePros = new Properties();
            try (FileInputStream is2 = new FileInputStream(release);){
                releasePros.load(is2);
            }
            catch (IOException is2) {
                // empty catch block
            }
            String javaVersion = releasePros.getProperty("JAVA_VERSION");
            if (javaVersion != null && javaVersion.startsWith("\"") && javaVersion.endsWith("\"")) {
                int dot = javaVersion.indexOf(46);
                javaVersion = dot > 0 ? javaVersion.substring(1, javaVersion.indexOf(46)) : javaVersion.substring(1, javaVersion.length() - 1);
                try {
                    ret = Integer.parseInt(javaVersion);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        return ret;
    }
}

