/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ant.freeform;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import org.apache.tools.ant.module.api.support.ActionUtils;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.ant.freeform.FreeformProject;
import org.netbeans.modules.ant.freeform.Util;
import org.netbeans.modules.ant.freeform.ui.UnboundTargetAlert;
import org.netbeans.spi.project.ActionProgress;
import org.netbeans.spi.project.ActionProvider;
import org.netbeans.spi.project.SingleMethod;
import org.netbeans.spi.project.ui.support.DefaultProjectOperations;
import org.netbeans.spi.project.ui.support.ProjectSensitiveActions;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.awt.DynamicMenuContent;
import org.openide.awt.StatusDisplayer;
import org.openide.execution.ExecutorTask;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.ContextAwareAction;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.Task;
import org.openide.util.TaskListener;
import org.openide.util.Union2;
import org.openide.util.actions.Presenter;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class Actions
implements ActionProvider {
    private static final Logger LOG = Logger.getLogger(Actions.class.getName());
    private static final Set<String> COMMON_IDE_GLOBAL_ACTIONS = new HashSet<String>(Arrays.asList("debug", "profile", "delete", "copy", "move", "rename"));
    private static final Set<String> COMMON_NON_IDE_GLOBAL_ACTIONS = new HashSet<String>(Arrays.asList("build", "clean", "rebuild", "run", "test", "javadoc", "redeploy", "deploy"));
    private final FreeformProject project;
    static TargetRunner TARGET_RUNNER = new TargetRunner();

    public Actions(FreeformProject project) {
        this.project = project;
    }

    public String[] getSupportedActions() {
        Element genldata = this.project.getPrimaryConfigurationData();
        Element actionsEl = XMLUtil.findElement((Element)genldata, (String)"ide-actions", (String)"http://www.netbeans.org/ns/freeform-project/2");
        LinkedHashSet<String> names = new LinkedHashSet<String>();
        if (actionsEl != null) {
            for (Element actionEl : XMLUtil.findSubElements((Element)actionsEl)) {
                names.add(actionEl.getAttribute("name"));
            }
            names.addAll(COMMON_NON_IDE_GLOBAL_ACTIONS);
        }
        names.add("rename");
        names.add("move");
        names.add("copy");
        names.add("delete");
        return names.toArray(new String[0]);
    }

    public boolean isActionEnabled(String command, Lookup context) throws IllegalArgumentException {
        if ("delete".equals(command)) {
            return true;
        }
        if ("copy".equals(command)) {
            return true;
        }
        if ("rename".equals(command)) {
            return true;
        }
        if ("move".equals(command)) {
            return true;
        }
        Element genldata = this.project.getPrimaryConfigurationData();
        Element actionsEl = XMLUtil.findElement((Element)genldata, (String)"ide-actions", (String)"http://www.netbeans.org/ns/freeform-project/2");
        if (actionsEl == null) {
            throw new IllegalArgumentException("No commands supported");
        }
        boolean foundAction = false;
        for (Element actionEl : XMLUtil.findSubElements((Element)actionsEl)) {
            if (!actionEl.getAttribute("name").equals(command)) continue;
            foundAction = true;
            Element contextEl = XMLUtil.findElement((Element)actionEl, (String)"context", (String)"http://www.netbeans.org/ns/freeform-project/2");
            if (contextEl != null) {
                Map<String, FileObject> selection = Actions.findSelection(contextEl, context, this.project, command.equals("run.single.method") || command.equals("debug.single.method") ? new AtomicReference<String>() : null);
                LOG.log(Level.FINE, "detected selection {0} for command {1} in {2}", new Object[]{selection, command, this.project});
                if (selection.size() == 1) {
                    return true;
                }
                if (selection.isEmpty()) continue;
                Element arityEl = XMLUtil.findElement((Element)contextEl, (String)"arity", (String)"http://www.netbeans.org/ns/freeform-project/2");
                assert (arityEl != null) : "No <arity> in <context> for " + command;
                if (XMLUtil.findElement((Element)arityEl, (String)"separated-files", (String)"http://www.netbeans.org/ns/freeform-project/2") == null) continue;
                return true;
            }
            return true;
        }
        if (COMMON_NON_IDE_GLOBAL_ACTIONS.contains(command)) {
            return true;
        }
        if (foundAction) {
            return false;
        }
        throw new IllegalArgumentException("Unrecognized command: " + command);
    }

    public void invokeAction(String command, Lookup context) throws IllegalArgumentException {
        if ("delete".equals(command)) {
            DefaultProjectOperations.performDefaultDeleteOperation((Project)this.project);
            return;
        }
        if ("copy".equals(command)) {
            DefaultProjectOperations.performDefaultCopyOperation((Project)this.project);
            return;
        }
        if ("rename".equals(command)) {
            DefaultProjectOperations.performDefaultRenameOperation((Project)this.project, null);
            return;
        }
        if ("move".equals(command)) {
            DefaultProjectOperations.performDefaultMoveOperation((Project)this.project);
            return;
        }
        Element genldata = this.project.getPrimaryConfigurationData();
        Element actionsEl = XMLUtil.findElement((Element)genldata, (String)"ide-actions", (String)"http://www.netbeans.org/ns/freeform-project/2");
        if (actionsEl == null) {
            throw new IllegalArgumentException("No commands supported");
        }
        boolean foundAction = false;
        for (Element actionEl : XMLUtil.findSubElements((Element)actionsEl)) {
            if (!actionEl.getAttribute("name").equals(command)) continue;
            foundAction = true;
            Actions.runConfiguredAction(command, this.project, actionEl, context);
        }
        if (!foundAction) {
            if (COMMON_NON_IDE_GLOBAL_ACTIONS.contains(command)) {
                if (this.addGlobalBinding(command)) {
                    this.invokeAction(command, context);
                }
            } else {
                throw new IllegalArgumentException("Unrecognized command: " + command);
            }
        }
    }

    private static Map<String, FileObject> findSelection(Element contextEl, Lookup context, FreeformProject project, AtomicReference<String> methodName) {
        Collection<Object> files;
        if (methodName == null) {
            Collection filesDO = context.lookupAll(DataObject.class);
            if (filesDO.isEmpty()) {
                return Collections.emptyMap();
            }
            ArrayList<FileObject> _files = new ArrayList<FileObject>(filesDO.size());
            for (DataObject d : filesDO) {
                _files.add(d.getPrimaryFile());
            }
            files = _files;
        } else {
            SingleMethod meth = (SingleMethod)context.lookup(SingleMethod.class);
            if (meth == null) {
                return Collections.emptyMap();
            }
            methodName.set(meth.getMethodName());
            files = Collections.singleton(meth.getFile());
        }
        Element folderEl = XMLUtil.findElement((Element)contextEl, (String)"folder", (String)"http://www.netbeans.org/ns/freeform-project/2");
        assert (folderEl != null) : "Must have <folder> in <context>";
        String rawtext = XMLUtil.findText((Node)folderEl);
        assert (rawtext != null) : "Must have text contents in <folder>";
        String evaltext = project.evaluator().evaluate(rawtext);
        if (evaltext == null) {
            return Collections.emptyMap();
        }
        FileObject folder = project.helper().resolveFileObject(evaltext);
        if (folder == null) {
            return Collections.emptyMap();
        }
        Pattern pattern = null;
        Element patternEl = XMLUtil.findElement((Element)contextEl, (String)"pattern", (String)"http://www.netbeans.org/ns/freeform-project/2");
        if (patternEl != null) {
            String text = XMLUtil.findText((Node)patternEl);
            assert (text != null) : "Must have text contents in <pattern>";
            try {
                pattern = Pattern.compile(text);
            }
            catch (PatternSyntaxException e) {
                Util.err.annotate((Throwable)e, 0, "From <pattern> in " + FileUtil.getFileDisplayName((FileObject)project.getProjectDirectory().getFileObject("nbproject/project.xml")), null, null, null);
                Util.err.notify((Throwable)e);
                return Collections.emptyMap();
            }
        }
        HashMap<String, FileObject> result = new HashMap<String, FileObject>();
        for (FileObject fileObject : files) {
            String path = FileUtil.getRelativePath((FileObject)folder, (FileObject)fileObject);
            if (path == null) {
                return Collections.emptyMap();
            }
            if (pattern != null && !pattern.matcher(path).find()) {
                return Collections.emptyMap();
            }
            result.put(path, fileObject);
        }
        return result;
    }

    private static void runConfiguredAction(final String command, final FreeformProject project, final Element actionEl, final Lookup context) {
        final ArrayList targetNames = new ArrayList();
        final Properties props = new Properties();
        Union2 scriptFile = (Union2)ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<Union2<FileObject, String>>(){

            public Union2<FileObject, String> run() {
                FileObject sf;
                Element scriptEl = XMLUtil.findElement((Element)actionEl, (String)"script", (String)"http://www.netbeans.org/ns/freeform-project/2");
                String script = scriptEl != null ? XMLUtil.findText((Node)scriptEl) : "build.xml";
                String scriptLocation = project.evaluator().evaluate(script);
                FileObject fileObject = sf = scriptLocation == null ? null : project.helper().resolveFileObject(scriptLocation);
                if (sf == null) {
                    return Union2.createSecond((Object)scriptLocation);
                }
                Union2 result = Union2.createFirst((Object)sf);
                List targets = XMLUtil.findSubElements((Element)actionEl);
                for (Element targetEl : targets) {
                    if (!targetEl.getLocalName().equals("target")) continue;
                    targetNames.add(XMLUtil.findText((Node)targetEl));
                }
                Element contextEl = XMLUtil.findElement((Element)actionEl, (String)"context", (String)"http://www.netbeans.org/ns/freeform-project/2");
                if (contextEl != null) {
                    AtomicReference methodName = "run.single.method".equals(command) || "debug.single.method".equals(command) ? new AtomicReference() : null;
                    Map selection = Actions.findSelection(contextEl, context, project, methodName);
                    if (selection.isEmpty()) {
                        return null;
                    }
                    if (methodName != null && methodName.get() != null) {
                        props.setProperty("method", (String)methodName.get());
                    }
                    String separator = null;
                    if (selection.size() > 1) {
                        Element arityEl = XMLUtil.findElement((Element)contextEl, (String)"arity", (String)"http://www.netbeans.org/ns/freeform-project/2");
                        assert (arityEl != null) : "No <arity> in <context> for " + actionEl.getAttribute("name");
                        Element sepFilesEl = XMLUtil.findElement((Element)arityEl, (String)"separated-files", (String)"http://www.netbeans.org/ns/freeform-project/2");
                        if (sepFilesEl == null) {
                            return null;
                        }
                        separator = XMLUtil.findText((Node)sepFilesEl);
                        if (separator == null) {
                            String message = "No separator found for " + command + " command. <separated-files>,</separated-files> could be used.";
                            LOG.log(Level.WARNING, message);
                            StatusDisplayer.getDefault().setStatusText(message);
                            return null;
                        }
                    }
                    Element formatEl = XMLUtil.findElement((Element)contextEl, (String)"format", (String)"http://www.netbeans.org/ns/freeform-project/2");
                    assert (formatEl != null) : "No <format> in <context> for " + actionEl.getAttribute("name");
                    String format = XMLUtil.findText((Node)formatEl);
                    StringBuilder buf = new StringBuilder();
                    Iterator it = selection.entrySet().iterator();
                    while (it.hasNext()) {
                        String path;
                        File f;
                        Map.Entry entry = it.next();
                        if (format.equals("absolute-path")) {
                            f = FileUtil.toFile((FileObject)((FileObject)entry.getValue()));
                            if (f == null) {
                                return null;
                            }
                            buf.append(f.getAbsolutePath());
                        } else if (format.equals("relative-path")) {
                            buf.append((String)entry.getKey());
                        } else if (format.equals("absolute-path-noext")) {
                            f = FileUtil.toFile((FileObject)((FileObject)entry.getValue()));
                            if (f == null) {
                                return null;
                            }
                            String path2 = f.getAbsolutePath();
                            int dot = path2.lastIndexOf(46);
                            if (dot > path2.lastIndexOf(47)) {
                                path2 = path2.substring(0, dot);
                            }
                            buf.append(path2);
                        } else if (format.equals("relative-path-noext")) {
                            path = (String)entry.getKey();
                            int dot = path.lastIndexOf(46);
                            if (dot > path.lastIndexOf(47)) {
                                path = path.substring(0, dot);
                            }
                            buf.append(path);
                        } else {
                            assert (format.equals("java-name")) : format;
                            path = (String)entry.getKey();
                            int dot = path.lastIndexOf(46);
                            String dotless = dot == -1 || dot < path.lastIndexOf(47) ? path : path.substring(0, dot);
                            String javaname = dotless.replace('/', '.');
                            buf.append(javaname);
                        }
                        if (!it.hasNext()) continue;
                        assert (separator != null);
                        buf.append(separator);
                    }
                    Element propEl = XMLUtil.findElement((Element)contextEl, (String)"property", (String)"http://www.netbeans.org/ns/freeform-project/2");
                    assert (propEl != null) : "No <property> in <context> for " + actionEl.getAttribute("name");
                    String prop = XMLUtil.findText((Node)propEl);
                    assert (prop != null) : "Must have text contents in <property>";
                    props.setProperty(prop, buf.toString());
                }
                for (Element propEl : targets) {
                    String evaltext;
                    if (!propEl.getLocalName().equals("property")) continue;
                    String rawtext = XMLUtil.findText((Node)propEl);
                    if (rawtext == null) {
                        rawtext = "";
                    }
                    if ((evaltext = project.evaluator().evaluate(rawtext)) == null) continue;
                    props.setProperty(propEl.getAttribute("name"), evaltext);
                }
                return result;
            }
        });
        if (scriptFile == null) {
            return;
        }
        if (scriptFile.hasFirst()) {
            String[] targetNameArray = !targetNames.isEmpty() ? targetNames.toArray(new String[0]) : null;
            TARGET_RUNNER.runTarget((FileObject)scriptFile.first(), targetNameArray, props, ActionProgress.start((Lookup)context));
        } else {
            assert (scriptFile.hasSecond());
            NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)MessageFormat.format(NbBundle.getMessage(Actions.class, (String)"LBL_ScriptFileNotFoundError"), scriptFile.second()), 0);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
        }
    }

    static Action[] contextMenuCustomActions(FreeformProject p) {
        Element contextMenuEl;
        ArrayList<Action> actions = new ArrayList<Action>();
        Element genldata = p.getPrimaryConfigurationData();
        Element viewEl = XMLUtil.findElement((Element)genldata, (String)"view", (String)"http://www.netbeans.org/ns/freeform-project/2");
        if (viewEl != null && (contextMenuEl = XMLUtil.findElement((Element)viewEl, (String)"context-menu", (String)"http://www.netbeans.org/ns/freeform-project/2")) != null) {
            actions.add(null);
            for (Element actionEl : XMLUtil.findSubElements((Element)contextMenuEl)) {
                if (actionEl.getLocalName().equals("ide-action")) {
                    String cmd = actionEl.getAttribute("name");
                    String displayName = COMMON_IDE_GLOBAL_ACTIONS.contains(cmd) || COMMON_NON_IDE_GLOBAL_ACTIONS.contains(cmd) ? NbBundle.getMessage(Actions.class, (String)("CMD_" + cmd)) : cmd;
                    actions.add(ProjectSensitiveActions.projectCommandAction((String)cmd, (String)displayName, null));
                    continue;
                }
                if (actionEl.getLocalName().equals("separator")) {
                    actions.add(null);
                    continue;
                }
                assert (actionEl.getLocalName().equals("action")) : actionEl;
                actions.add(new CustomAction(p, actionEl));
            }
        }
        return actions.toArray(new Action[0]);
    }

    private boolean addGlobalBinding(String command) {
        try {
            return new UnboundTargetAlert(this.project, command).accepted();
        }
        catch (IOException e) {
            ErrorManager.getDefault().notify((Throwable)e);
            return false;
        }
    }

    static class TargetRunner {
        public void runTarget(FileObject scriptFile, String[] targetNameArray, Properties props, final ActionProgress listener) {
            try {
                ActionUtils.runTarget((FileObject)scriptFile, (String[])targetNameArray, (Properties)props).addTaskListener(new TaskListener(){
                    final /* synthetic */ TargetRunner this$0;
                    {
                        this.this$0 = this$0;
                    }

                    public void taskFinished(Task task) {
                        listener.finished(((ExecutorTask)task).result() == 0);
                    }
                });
            }
            catch (IOException e) {
                ErrorManager.getDefault().notify((Throwable)e);
                listener.finished(false);
            }
        }
    }

    private static final class CustomAction
    extends AbstractAction {
        private final FreeformProject p;
        private final Element actionEl;

        public CustomAction(FreeformProject p, Element actionEl) {
            this.p = p;
            this.actionEl = actionEl;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Actions.runConfiguredAction(null, this.p, this.actionEl, Lookup.EMPTY);
        }

        @Override
        public boolean isEnabled() {
            Element scriptEl = XMLUtil.findElement((Element)this.actionEl, (String)"script", (String)"http://www.netbeans.org/ns/freeform-project/2");
            String script = scriptEl != null ? XMLUtil.findText((Node)scriptEl) : "build.xml";
            String scriptLocation = this.p.evaluator().evaluate(script);
            return this.p.helper().resolveFileObject(scriptLocation) != null;
        }

        @Override
        public Object getValue(String key) {
            if (key.equals("Name")) {
                Element labelEl = XMLUtil.findElement((Element)this.actionEl, (String)"label", (String)"http://www.netbeans.org/ns/freeform-project/2");
                return XMLUtil.findText((Node)labelEl);
            }
            return super.getValue(key);
        }
    }

    public static final class Custom
    extends AbstractAction
    implements ContextAwareAction {
        public Custom() {
            this.setEnabled(false);
            this.putValue("hideWhenDisabled", true);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            assert (false);
        }

        public Action createContextAwareInstance(Lookup actionContext) {
            Collection projects = actionContext.lookupAll(FreeformProject.class);
            if (projects.size() != 1) {
                return this;
            }
            final FreeformProject p = (FreeformProject)projects.iterator().next();
            class A
            extends AbstractAction
            implements Presenter.Popup {
                final /* synthetic */ Custom this$0;

                A() {
                    this.this$0 = this$0;
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    assert (false);
                }

                public JMenuItem getPopupPresenter() {
                    class M
                    extends JMenuItem
                    implements DynamicMenuContent {
                        final /* synthetic */ A this$1;

                        M() {
                            this.this$1 = this$1;
                        }

                        public JComponent[] getMenuPresenters() {
                            Action[] actions = Actions.contextMenuCustomActions(p);
                            JComponent[] comps = new JComponent[actions.length];
                            for (int i = 0; i < actions.length; ++i) {
                                if (actions[i] != null) {
                                    JMenuItem item = new JMenuItem();
                                    org.openide.awt.Actions.connect((JMenuItem)item, (Action)actions[i], (boolean)true);
                                    comps[i] = item;
                                    continue;
                                }
                                comps[i] = new JSeparator();
                            }
                            return comps;
                        }

                        public JComponent[] synchMenuPresenters(JComponent[] items) {
                            return this.getMenuPresenters();
                        }
                    }
                    return new M();
                }
            }
            return new A();
        }
    }
}

