/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.docker.ui;

import java.util.regex.Pattern;
import org.netbeans.modules.docker.api.DockerName;
import org.netbeans.modules.docker.ui.Bundle;
import org.openide.util.Parameters;

public final class Validations {
    private static final Pattern CONTAINER_PATTERN = Pattern.compile("^[a-zA-Z0-9][a-zA-Z0-9_.-]+$");
    private static final Pattern REPOSITORY_PATTERN = Pattern.compile("^[a-z0-9_\\.-]+$");
    private static final Pattern NAMESPACE_PATTERN = Pattern.compile("^[a-z0-9_-]+$");
    private static final Pattern FORBIDDEN_REPOSITORY_PATTERN = Pattern.compile("^[a-f0-9]{64}$");
    private static final Pattern TAG_PATTERN = Pattern.compile("^[A-Za-z0-9_\\.-]+$");

    private Validations() {
    }

    public static String validateContainer(String container) {
        Parameters.notNull((CharSequence)"container", (Object)container);
        if (container.isEmpty()) {
            return null;
        }
        if (container.length() < 2) {
            return Bundle.MSG_ErrorContainerShort();
        }
        if (!CONTAINER_PATTERN.matcher(container).matches()) {
            return Bundle.MSG_ErrorContainerCharacter(container);
        }
        return null;
    }

    public static String validateRepository(String repository) {
        Parameters.notNull((CharSequence)"repository", (Object)repository);
        if (repository.isEmpty()) {
            return null;
        }
        if (repository.contains("://")) {
            return Bundle.MSG_ErrorSchema();
        }
        DockerName parsed = DockerName.parse((String)repository);
        String registry = parsed.getRegistry();
        String ns = parsed.getNamespace();
        String repo = parsed.getRepository();
        if (registry != null && (registry.startsWith("-") || registry.endsWith("-"))) {
            return Bundle.MSG_ErrorRegistryStartEndHyphen(registry);
        }
        if (ns != null) {
            if (ns.length() < 2) {
                return Bundle.MSG_ErrorNamespaceShort();
            }
            if (ns.length() > 255) {
                return Bundle.MSG_ErrorNamespaceLong();
            }
            if (ns.startsWith("-") || ns.endsWith("-")) {
                return Bundle.MSG_ErrorNamespaceStartEndHyphen(ns);
            }
            if (ns.contains("--")) {
                return Bundle.MSG_ErrorNamespaceConsecutiveHyphens();
            }
            if (!NAMESPACE_PATTERN.matcher(ns).matches()) {
                return Bundle.MSG_ErrorNamespaceCharacter(ns);
            }
        }
        if (repo.isEmpty()) {
            return Bundle.MSG_ErrorRepositoryEmpty();
        }
        if (ns == null && FORBIDDEN_REPOSITORY_PATTERN.matcher(repo).matches()) {
            return Bundle.MSG_ErrorRepository64HexBytes();
        }
        if (!REPOSITORY_PATTERN.matcher(repo).matches()) {
            return Bundle.MSG_ErrorRepositoryCharacter(repo);
        }
        return null;
    }

    public static String validateTag(String tag) {
        Parameters.notNull((CharSequence)"tag", (Object)tag);
        if (tag.isEmpty()) {
            return null;
        }
        if (!TAG_PATTERN.matcher(tag).matches()) {
            return Bundle.MSG_ErrorTagCharacter(tag);
        }
        if (tag.length() > 128) {
            return Bundle.MSG_ErrorTagLong();
        }
        return null;
    }
}

