/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.team.commons.treelist;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.plaf.ListUI;
import org.netbeans.modules.team.commons.treelist.AbstractListUI;
import org.netbeans.modules.team.commons.treelist.ListListener;
import org.netbeans.modules.team.commons.treelist.ListNode;
import org.openide.util.Utilities;

public final class SelectionList
extends JList<ListNode> {
    static final int INSETS_LEFT = 5;
    static final int INSETS_TOP = 5;
    static final int INSETS_BOTTOM = 5;
    static final int INSETS_RIGHT = 5;
    private static final int MAX_VISIBLE_ROWS = 10;
    private static final String ACTION_SELECT = "selectProject";
    private static final String ACTION_SHOW_POPUP = "showPopup";
    private int mouseOverRow = -1;
    private final RendererImpl renderer = new RendererImpl();
    static final int ROW_HEIGHT = Math.max(16, new JLabel((String)"X").getPreferredSize().height);
    private final ListListener nodeListener;

    public SelectionList() {
        this.setSelectionMode(0);
        this.setBorder(BorderFactory.createEmptyBorder());
        this.setOpaque(false);
        this.setBackground(new Color(0, 0, 0, 0));
        this.setFixedCellHeight(ROW_HEIGHT + 5 + 5 + 2);
        this.setCellRenderer(this.renderer);
        this.setVisibleRowCount(10);
        ToolTipManager.sharedInstance().registerComponent(this);
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                if (SelectionList.this.getSelectedIndex() < 0 && SelectionList.this.isShowing() && SelectionList.this.getModel().getSize() > 0) {
                    SelectionList.this.setSelectedIndex(0);
                }
            }
        });
        this.nodeListener = new ListListener(){

            @Override
            public void contentChanged(ListNode node) {
                int index = ((DefaultListModel)SelectionList.this.getModel()).indexOf(node);
                if (index >= 0) {
                    SelectionList.this.repaintRow(index);
                }
            }

            @Override
            public void contentSizeChanged(ListNode node) {
                SelectionListModel model = (SelectionListModel)SelectionList.this.getModel();
                int index = model.indexOf(node);
                if (index >= 0) {
                    model.fireContentsChanged(node, index, index);
                    Container p = SelectionList.this;
                    while ((p = p.getParent()) != null) {
                        if (!(p instanceof JDialog)) continue;
                        SelectionList.this.invalidate();
                        SelectionList.this.revalidate();
                        ((JDialog)p).pack();
                        return;
                    }
                }
            }
        };
        MouseAdapter adapter = new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                this.mouseMoved(e);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                SelectionList.this.setMouseOver(-1);
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                int row = SelectionList.this.locationToIndex(e.getPoint());
                SelectionList.this.setMouseOver(row);
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.isPopupTrigger() || e.isConsumed()) {
                    return;
                }
                if (e.getButton() == 1 && e.getClickCount() == 1) {
                    int index = SelectionList.this.locationToIndex(e.getPoint());
                    SelectionList.this.selectProjectAtIndex(index);
                }
            }
        };
        this.addMouseMotionListener(adapter);
        this.addMouseListener(adapter);
        this.initKeysAndActions();
    }

    private void selectProjectAtIndex(int index) {
        Action al;
        Object value;
        if (index >= 0 && index < this.getModel().getSize() && (value = this.getModel().getElementAt(index)) instanceof ListNode && (al = ((ListNode)value).getDefaultAction()) != null) {
            al.actionPerformed(new ActionEvent(this, 1001, ""));
        }
    }

    private void initKeysAndActions() {
        this.unregisterKeyboardAction(KeyStroke.getKeyStroke(10, 0));
        this.unregisterKeyboardAction(KeyStroke.getKeyStroke(121, 64));
        InputMap imp = this.getInputMap();
        ActionMap am = this.getActionMap();
        imp.put(KeyStroke.getKeyStroke(10, 0), ACTION_SELECT);
        imp.put(KeyStroke.getKeyStroke(121, 64), ACTION_SHOW_POPUP);
        am.put(ACTION_SELECT, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SelectionList.this.selectProjectAtIndex(SelectionList.this.getSelectedIndex());
            }
        });
        am.put(ACTION_SHOW_POPUP, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int index = SelectionList.this.getSelectedIndex();
                if (index >= 0 && index < SelectionList.this.getModel().getSize()) {
                    SelectionList.this.showPopupMenuAt(index, SelectionList.this.getUI().indexToLocation(SelectionList.this, index));
                }
            }
        });
    }

    int getMouseOverRow() {
        return this.mouseOverRow;
    }

    private void setMouseOver(int newRow) {
        int oldRow = this.mouseOverRow;
        this.mouseOverRow = newRow;
        this.repaintRow(oldRow);
        this.repaintRow(this.mouseOverRow);
    }

    private void repaintRow(int row) {
        Rectangle rect;
        if (row >= 0 && row < this.getModel().getSize() && null != (rect = this.getCellBounds(row, row))) {
            this.repaint(rect);
        }
    }

    @Override
    public void setUI(ListUI ui) {
        super.setUI(new SelectionListUI());
    }

    private void showPopupMenuAt(int rowIndex, Point location) {
        ListNode node = (ListNode)this.getModel().getElementAt(rowIndex);
        Action[] actions = node.getPopupActions();
        if (null == actions || actions.length == 0) {
            return;
        }
        JPopupMenu popup = Utilities.actionsToPopup((Action[])actions, (Component)this);
        popup.show(this, location.x, location.y);
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        if (event != null) {
            Rectangle cellBounds;
            Point p = event.getPoint();
            int index = this.locationToIndex(p);
            ListCellRenderer<ListNode> r = this.getCellRenderer();
            if (index != -1 && r != null && (cellBounds = this.getCellBounds(index, index)) != null && cellBounds.contains(p.x, p.y)) {
                ListSelectionModel lsm = this.getSelectionModel();
                Component rComponent = r.getListCellRendererComponent(this, (ListNode)this.getModel().getElementAt(index), index, lsm.isSelectedIndex(index), this.hasFocus() && lsm.getLeadSelectionIndex() == index);
                if (rComponent instanceof JComponent) {
                    rComponent.setBounds(cellBounds);
                    rComponent.doLayout();
                    p.translate(-cellBounds.x, -cellBounds.y);
                    MouseEvent newEvent = new MouseEvent(rComponent, event.getID(), event.getWhen(), event.getModifiers(), p.x, p.y, event.getClickCount(), event.isPopupTrigger());
                    String tip = ((JComponent)rComponent).getToolTipText(newEvent);
                    if (tip != null) {
                        return tip;
                    }
                }
            }
        }
        return super.getToolTipText();
    }

    @Override
    public int getVisibleRowCount() {
        return Math.min(10, this.getModel().getSize());
    }

    public void setItems(List<ListNode> items) {
        SelectionListModel model = new SelectionListModel();
        for (ListNode item : items) {
            model.addElement(item);
            item.setListener(this.nodeListener);
        }
        this.setModel(model);
    }

    static class RendererImpl
    extends DefaultListCellRenderer {
        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (!(value instanceof ListNode)) {
                return new JLabel();
            }
            if (list instanceof SelectionList) {
                isSelected |= index == ((SelectionList)list).getMouseOverRow();
            }
            ListNode node = (ListNode)value;
            int rowHeight = list.getFixedCellHeight();
            int rowWidth = list.getWidth();
            JScrollPane scroll = (JScrollPane)SwingUtilities.getAncestorOfClass(JScrollPane.class, list);
            if (null != scroll) {
                rowWidth = scroll.getViewport().getWidth();
            }
            Color background = isSelected ? list.getSelectionBackground() : list.getBackground();
            Color foreground = isSelected ? list.getSelectionForeground() : list.getForeground();
            return node.getListRenderer(foreground, background, isSelected, cellHasFocus, rowHeight, rowWidth);
        }
    }

    private static class SelectionListUI
    extends AbstractListUI {
        private SelectionListUI() {
        }

        @Override
        boolean showPopupAt(int rowIndex, Point location) {
            JList list = this.list;
            if (!(list instanceof SelectionList)) {
                return false;
            }
            ((SelectionList)list).showPopupMenuAt(rowIndex, location);
            return true;
        }
    }

    private static class SelectionListModel
    extends DefaultListModel<ListNode> {
        private SelectionListModel() {
        }

        @Override
        protected void fireContentsChanged(Object source, int index0, int index1) {
            super.fireContentsChanged(source, index0, index1);
        }
    }
}

