/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.browser.api;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import org.netbeans.core.IDESettings;
import org.netbeans.modules.extbrowser.ExtWebBrowser;
import org.netbeans.modules.extbrowser.PrivateBrowserFamilyId;
import org.netbeans.modules.web.browser.api.BrowserFamilyId;
import org.netbeans.modules.web.browser.api.WebBrowser;
import org.netbeans.modules.web.browser.api.WebBrowserFactoryDescriptor;
import org.netbeans.modules.web.browser.spi.EnhancedBrowserFactory;
import org.openide.awt.HtmlBrowser;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbPreferences;
import org.openide.util.lookup.Lookups;

public final class WebBrowsers {
    public static final String PROP_BROWSERS = "browsers";
    public static final String PROP_DEFAULT_BROWSER = "browser";
    private static final WebBrowsers INST = new WebBrowsers();
    private static final String BROWSERS_FOLDER = "Services/Browsers";
    private static final String BROWSERS2_FOLDER = "Services/Browsers2";
    private PropertyChangeSupport sup = new PropertyChangeSupport(this);
    private PropertyChangeListener l;
    private FileChangeListener lis;
    private PreferenceChangeListener lis2;
    static final String DEFAULT = "default";

    private WebBrowsers() {
        FileObject servicesBrowsers = this.getConfigFolder();
        if (servicesBrowsers != null) {
            this.lis = new FileChangeListener(){

                public void fileFolderCreated(FileEvent fe) {
                }

                public void fileDataCreated(FileEvent fe) {
                    WebBrowsers.this.fireBrowsersChange();
                }

                public void fileChanged(FileEvent fe) {
                    WebBrowsers.this.fireBrowsersChange();
                }

                public void fileDeleted(FileEvent fe) {
                    WebBrowsers.this.fireBrowsersChange();
                }

                public void fileRenamed(FileRenameEvent fe) {
                    WebBrowsers.this.fireBrowsersChange();
                }

                public void fileAttributeChanged(FileAttributeEvent fe) {
                    WebBrowsers.this.fireBrowsersChange();
                }
            };
            servicesBrowsers.addRecursiveListener(this.lis);
        }
        this.lis2 = new PreferenceChangeListener(){

            @Override
            public void preferenceChange(PreferenceChangeEvent evt) {
                if ("WWWBrowser".equals(evt.getKey())) {
                    WebBrowsers.this.fireDefaultBrowserChange();
                }
            }
        };
        NbPreferences.forModule(IDESettings.class).addPreferenceChangeListener(this.lis2);
    }

    public static WebBrowsers getInstance() {
        return INST;
    }

    public WebBrowser getPreferred() {
        WebBrowserFactoryDescriptor someFactory = null;
        for (WebBrowserFactoryDescriptor desc : this.getFactories(true)) {
            if (someFactory == null) {
                someFactory = desc;
            }
            if (!desc.isDefault()) continue;
            return new WebBrowser(desc);
        }
        if (someFactory != null) {
            return new WebBrowser(someFactory);
        }
        assert (false) : "there are no browsers registered on your classpath. can you fix that";
        return null;
    }

    public WebBrowser getEmbedded() {
        for (WebBrowserFactoryDescriptor desc : this.getFactories(true)) {
            if (desc.getBrowserFamily() != BrowserFamilyId.JAVAFX_WEBVIEW) continue;
            return new WebBrowser(desc);
        }
        return null;
    }

    public List<WebBrowser> getAll(boolean includeSystemDefaultBrowser, boolean includeIDEGlobalBrowserOption, boolean sortBrowsers) {
        return this.getAll(includeSystemDefaultBrowser, includeIDEGlobalBrowserOption, false, sortBrowsers);
    }

    public List<WebBrowser> getAll(boolean includeSystemDefaultBrowser, boolean includeIDEGlobalBrowserOption, boolean includePhoneGap, boolean sortBrowsers) {
        if (sortBrowsers) {
            return this.getSortedBrowsers(includeSystemDefaultBrowser, includeIDEGlobalBrowserOption, includePhoneGap);
        }
        return this.getUnsortedBrowsers(includeSystemDefaultBrowser, includeIDEGlobalBrowserOption, includePhoneGap);
    }

    private List<WebBrowser> getSortedBrowsers(boolean includeSystemDefaultBrowser, boolean includeIDEGlobalBrowserOption, boolean includePhoneGap) {
        ArrayList<BrowserWrapper> browsers = new ArrayList<BrowserWrapper>();
        int chrome = 200;
        int chromium = 300;
        int others = 1000;
        int android = 1400;
        int ios = 1500;
        int phonegap = 1600;
        for (WebBrowserFactoryDescriptor desc : this.getFactories(includeSystemDefaultBrowser)) {
            BrowserWrapper wrapper;
            if (desc.getBrowserFamily().equals((Object)BrowserFamilyId.PHONEGAP) && !includePhoneGap) continue;
            WebBrowser browser = new WebBrowser(desc);
            if (browser.getBrowserFamily() == BrowserFamilyId.JAVAFX_WEBVIEW) {
                browsers.add(new BrowserWrapper(browser, 100));
                continue;
            }
            if (browser.getBrowserFamily() == BrowserFamilyId.CHROME || browser.getId().endsWith("ChromeBrowser")) {
                wrapper = new BrowserWrapper(browser, chrome++);
                browsers.add(wrapper);
                continue;
            }
            if (browser.getBrowserFamily() == BrowserFamilyId.CHROMIUM || browser.getId().endsWith("ChromiumBrowser")) {
                wrapper = new BrowserWrapper(browser, chromium++);
                browsers.add(wrapper);
                continue;
            }
            if (browser.getBrowserFamily() == BrowserFamilyId.ANDROID) {
                browsers.add(new BrowserWrapper(browser, android++));
                continue;
            }
            if (browser.getBrowserFamily() == BrowserFamilyId.IOS) {
                browsers.add(new BrowserWrapper(browser, ios++));
                continue;
            }
            if (browser.getBrowserFamily() == BrowserFamilyId.PHONEGAP) {
                browsers.add(new BrowserWrapper(browser, phonegap++));
                continue;
            }
            browsers.add(new BrowserWrapper(browser, others++));
        }
        browsers.sort(new Comparator<BrowserWrapper>(){

            @Override
            public int compare(BrowserWrapper o1, BrowserWrapper o2) {
                return o1.getOrder() - o2.getOrder();
            }
        });
        ArrayList<WebBrowser> result = new ArrayList<WebBrowser>();
        if (includeIDEGlobalBrowserOption) {
            result.add(this.createIDEGlobalDelegate());
        }
        for (BrowserWrapper bw : browsers) {
            result.add(bw.getBrowser());
        }
        return result;
    }

    private WebBrowser createIDEGlobalDelegate() {
        return WebBrowser.createIDEGlobalDelegate();
    }

    private List<WebBrowser> getUnsortedBrowsers(boolean includeSystemDefaultBrowser, boolean includeIDEGlobalBrowserOption, boolean includeMobileBrowsers) {
        ArrayList<WebBrowser> browsers = new ArrayList<WebBrowser>();
        if (includeIDEGlobalBrowserOption) {
            browsers.add(this.createIDEGlobalDelegate());
        }
        for (WebBrowserFactoryDescriptor desc : this.getFactories(includeSystemDefaultBrowser)) {
            if (desc.getBrowserFamily().isMobile() && !includeMobileBrowsers) continue;
            WebBrowser browser = new WebBrowser(desc);
            browsers.add(browser);
        }
        return browsers;
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.sup.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.sup.removePropertyChangeListener(l);
    }

    private void fireBrowsersChange() {
        this.sup.firePropertyChange(PROP_BROWSERS, null, null);
    }

    private void fireDefaultBrowserChange() {
        this.sup.firePropertyChange(PROP_DEFAULT_BROWSER, null, null);
    }

    private FileObject getConfigFolder() {
        return FileUtil.getConfigFile((String)BROWSERS_FOLDER);
    }

    private List<WebBrowserFactoryDescriptor> getFactories(boolean includeSystemDefaultBrowser) {
        ArrayList<WebBrowserFactoryDescriptor> browsers = new ArrayList<WebBrowserFactoryDescriptor>();
        ArrayList<WebBrowserFactoryDescriptor> browsersToUpdate = new ArrayList<WebBrowserFactoryDescriptor>();
        WebBrowserFactoryDescriptor advancedChrome = null;
        WebBrowserFactoryDescriptor advancedChromium = null;
        Lookup l = Lookups.forPath((String)BROWSERS2_FOLDER);
        for (HtmlBrowser.Factory f : l.lookupAll(HtmlBrowser.Factory.class)) {
            EnhancedBrowserFactory fact;
            if (!(f instanceof EnhancedBrowserFactory) || !(fact = (EnhancedBrowserFactory)f).canCreateHtmlBrowserImpl()) continue;
            String browserId = fact.getId();
            if (browserId == null) {
                browserId = fact.getBrowserFamilyId().toString();
            }
            WebBrowserFactoryDescriptor desc = new WebBrowserFactoryDescriptor(browserId, null, false, f);
            browsers.add(desc);
            if (fact.getBrowserFamilyId() == BrowserFamilyId.CHROME && !fact.hasNetBeansIntegration()) {
                advancedChrome = desc;
            }
            if (fact.getBrowserFamilyId() == BrowserFamilyId.CHROMIUM && !fact.hasNetBeansIntegration()) {
                advancedChromium = desc;
            }
            browsersToUpdate.add(desc);
        }
        FileObject servicesBrowsers = this.getConfigFolder();
        if (servicesBrowsers == null) {
            return browsers;
        }
        DataFolder folder = DataFolder.findFolder((FileObject)servicesBrowsers);
        Lookup.getDefault().lookupAll(HtmlBrowser.Factory.class).toArray();
        for (DataObject browserSetting : folder.getChildren()) {
            HtmlBrowser.Factory fact;
            InstanceCookie cookie;
            if (Boolean.TRUE.equals(browserSetting.getPrimaryFile().getAttribute("hidden")) || !includeSystemDefaultBrowser && this.isSystemDefaultBrowser(browserSetting) || (cookie = (InstanceCookie)browserSetting.getCookie(InstanceCookie.class)) == null) continue;
            try {
                fact = (HtmlBrowser.Factory)cookie.instanceCreate();
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                continue;
            }
            catch (ClassNotFoundException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                continue;
            }
            Lookup.Item item = Lookup.getDefault().lookupItem(new Lookup.Template(HtmlBrowser.Factory.class, null, (Object)fact));
            if (item == null) continue;
            ExtWebBrowser extFact = fact instanceof ExtWebBrowser ? (ExtWebBrowser)fact : null;
            boolean isDefault = IDESettings.getWWWBrowser() == null ? false : IDESettings.getWWWBrowser().equals((Object)fact);
            if (extFact != null && !this.isSystemDefaultBrowser(browserSetting)) {
                if (extFact.getPrivateBrowserFamilyId() == PrivateBrowserFamilyId.CHROME) {
                    this.setBrowserExecutableDelegate(extFact, browsersToUpdate, BrowserFamilyId.CHROME);
                } else if (extFact.getPrivateBrowserFamilyId() == PrivateBrowserFamilyId.CHROMIUM) {
                    this.setBrowserExecutableDelegate(extFact, browsersToUpdate, BrowserFamilyId.CHROMIUM);
                }
            }
            if (advancedChrome != null && extFact != null && extFact.getPrivateBrowserFamilyId() == PrivateBrowserFamilyId.CHROME) {
                if (!isDefault) continue;
                advancedChrome.setDefault(true);
                continue;
            }
            if (advancedChromium != null && extFact != null && extFact.getPrivateBrowserFamilyId() == PrivateBrowserFamilyId.CHROMIUM) {
                if (!isDefault) continue;
                advancedChromium.setDefault(true);
                continue;
            }
            browsers.add(new WebBrowserFactoryDescriptor(item.getId(), browserSetting, isDefault, fact));
        }
        return browsers;
    }

    static BrowserFamilyId getIDEOptionsBrowserFamily() {
        HtmlBrowser.Factory factory = IDESettings.getWWWBrowser();
        if (factory instanceof ExtWebBrowser) {
            return WebBrowserFactoryDescriptor.convertBrowserFamilyId(((ExtWebBrowser)factory).getPrivateBrowserFamilyId());
        }
        if (factory instanceof EnhancedBrowserFactory) {
            return ((EnhancedBrowserFactory)factory).getBrowserFamilyId();
        }
        return BrowserFamilyId.UNKNOWN;
    }

    private boolean isSystemDefaultBrowser(DataObject browserSetting) {
        return browserSetting.getPrimaryFile().getName().startsWith("SystemDefaultBrowser");
    }

    private void setBrowserExecutableDelegate(ExtWebBrowser fact, List<WebBrowserFactoryDescriptor> browsersToUpdate, BrowserFamilyId family) {
        for (WebBrowserFactoryDescriptor desc : browsersToUpdate) {
            if (desc.getBrowserFamily() != family || !(desc.getFactory() instanceof ExtWebBrowser)) continue;
            ((ExtWebBrowser)desc.getFactory()).useBrowserExecutableDelegate(fact);
        }
    }

    private static final class BrowserWrapper {
        private final WebBrowser browser;
        private final int order;

        public BrowserWrapper(WebBrowser browser, int order) {
            this.browser = browser;
            this.order = order;
        }

        public WebBrowser getBrowser() {
            return this.browser;
        }

        int getOrder() {
            return this.order;
        }
    }
}

