/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.nbimpl.actions;

import org.netbeans.api.project.Project;
import org.netbeans.modules.profiler.api.project.ProjectProfilingSupport;
import org.netbeans.modules.profiler.nbimpl.actions.ProfilerLauncher;
import org.netbeans.modules.profiler.v2.ProfilerSession;
import org.netbeans.spi.project.ActionProvider;
import org.netbeans.spi.project.ui.support.ProjectActionPerformer;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

public class ProjectSensitivePerformer
implements ProjectActionPerformer {
    private final String command;
    private final boolean attach;

    public static ProjectSensitivePerformer profileProject(String command) {
        return new ProjectSensitivePerformer(command, false);
    }

    public static ProjectSensitivePerformer attachProject() {
        return new ProjectSensitivePerformer(null, true);
    }

    private ProjectSensitivePerformer(String command, boolean attach) {
        this.command = command;
        this.attach = attach;
    }

    static boolean supportsProfileProject(String command, Project project) {
        if (project == null) {
            return false;
        }
        ActionProvider ap = (ActionProvider)project.getLookup().lookup(ActionProvider.class);
        try {
            if (ap != null && ProjectSensitivePerformer.contains(ap.getSupportedActions(), command)) {
                ProjectProfilingSupport ppp = ProjectProfilingSupport.get((Lookup.Provider)project);
                return ppp.isProfilingSupported() && ap.isActionEnabled(command, project.getLookup());
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return false;
    }

    static boolean supportsAttachProject(Project project) {
        if (project == null) {
            return false;
        }
        ProjectProfilingSupport ppp = ProjectProfilingSupport.get((Lookup.Provider)project);
        return ppp.isAttachSupported();
    }

    public boolean enable(Project project) {
        if (this.attach) {
            return ProjectSensitivePerformer.supportsAttachProject(project);
        }
        return ProjectSensitivePerformer.supportsProfileProject(this.command, project);
    }

    public void perform(final Project project) {
        RequestProcessor.getDefault().post(new Runnable(){
            final /* synthetic */ ProjectSensitivePerformer this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                ProfilerSession session;
                ProjectProfilingSupport ppp = ProjectProfilingSupport.get((Lookup.Provider)project);
                if (!ppp.checkProjectCanBeProfiled(null)) {
                    return;
                }
                if (ppp.startProfilingSession(null, false)) {
                    return;
                }
                Lookup projectLookup = project.getLookup();
                if (this.this$0.attach) {
                    ProxyLookup context = new ProxyLookup(new Lookup[]{projectLookup, Lookups.fixed((Object[])new Object[]{project})});
                    session = ProfilerSession.forContext((Lookup)context);
                } else {
                    ProfilerLauncher.Command _command = new ProfilerLauncher.Command(this.this$0.command);
                    ProxyLookup context = new ProxyLookup(new Lookup[]{projectLookup, Lookups.fixed((Object[])new Object[]{project, _command})});
                    session = ProfilerSession.forContext((Lookup)context);
                }
                if (session != null) {
                    session.setAttach(this.this$0.attach);
                    session.open();
                }
            }
        });
    }

    private static boolean contains(String[] actions, String action) {
        for (String a : actions) {
            if (!action.equals(a)) continue;
            return true;
        }
        return false;
    }
}

