/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.editor.refactoring;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.html.editor.CssPreferences;
import org.netbeans.modules.refactoring.spi.ui.CustomRefactoringPanel;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class RenamePanel
extends JPanel
implements CustomRefactoringPanel {
    private final transient String oldName;
    private final transient ChangeListener parent;
    private boolean initialized;
    private JPanel jPanel1;
    private JLabel label;
    private JTextField nameField;
    private JCheckBox refactorAllCheckBox;
    private JCheckBox textCheckBox;
    private JCheckBox updateReferencesCheckBox;
    private JLabel warningLabel;

    public RenamePanel(String oldName, ChangeListener parent, String name, boolean editable, boolean showUpdateReferences) {
        this.setName(name);
        this.oldName = oldName;
        this.parent = parent;
        this.initComponents();
        this.updateReferencesCheckBox.setVisible(showUpdateReferences);
        this.nameField.setEnabled(editable);
        this.nameField.requestFocus();
        this.nameField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent event) {
                RenamePanel.this.parent.stateChanged(null);
            }

            @Override
            public void insertUpdate(DocumentEvent event) {
                RenamePanel.this.parent.stateChanged(null);
            }

            @Override
            public void removeUpdate(DocumentEvent event) {
                RenamePanel.this.parent.stateChanged(null);
            }
        });
    }

    public void initialize() {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
    }

    @Override
    public void requestFocus() {
        this.nameField.requestFocus();
    }

    private void initComponents() {
        this.label = new JLabel();
        this.nameField = new JTextField();
        this.jPanel1 = new JPanel();
        this.warningLabel = new JLabel();
        this.textCheckBox = new JCheckBox();
        this.updateReferencesCheckBox = new JCheckBox();
        this.refactorAllCheckBox = new JCheckBox();
        this.setBorder(BorderFactory.createEmptyBorder(12, 12, 11, 11));
        this.setLayout(new GridBagLayout());
        this.label.setHorizontalAlignment(2);
        this.label.setLabelFor(this.nameField);
        Mnemonics.setLocalizedText((JLabel)this.label, (String)NbBundle.getMessage(RenamePanel.class, (String)"LBL_NewName"));
        this.add((Component)this.label, new GridBagConstraints());
        this.nameField.setText(this.oldName);
        this.nameField.selectAll();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.nameField, gridBagConstraints);
        ResourceBundle bundle = ResourceBundle.getBundle("org/netbeans/modules/css/refactoring/Bundle");
        this.nameField.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_nameField"));
        this.jPanel1.setMinimumSize(new Dimension(0, 0));
        this.jPanel1.setPreferredSize(new Dimension(0, 0));
        this.jPanel1.setLayout(new BorderLayout());
        Mnemonics.setLocalizedText((JLabel)this.warningLabel, (String)NbBundle.getMessage(RenamePanel.class, (String)"LBL_NonAccurateRefactoringWarning"));
        this.jPanel1.add((Component)this.warningLabel, "North");
        this.warningLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RenamePanel.class, (String)"LBL_NonAccurateRefactoringWarning"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.add((Component)this.jPanel1, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.textCheckBox, (String)NbBundle.getBundle(RenamePanel.class).getString("LBL_RenameComments"));
        this.textCheckBox.setActionCommand(NbBundle.getMessage(RenamePanel.class, (String)"LBL_RenameComments"));
        this.textCheckBox.setEnabled(false);
        this.textCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                RenamePanel.this.textCheckBoxItemStateChanged(evt);
            }
        });
        this.textCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RenamePanel.this.textCheckBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.textCheckBox, gridBagConstraints);
        this.textCheckBox.getAccessibleContext().setAccessibleDescription(this.textCheckBox.getText());
        Mnemonics.setLocalizedText((AbstractButton)this.updateReferencesCheckBox, (String)NbBundle.getBundle(RenamePanel.class).getString("LBL_RenameWithoutRefactoring"));
        this.updateReferencesCheckBox.setEnabled(false);
        this.updateReferencesCheckBox.setMargin(new Insets(2, 2, 0, 2));
        this.updateReferencesCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RenamePanel.this.updateReferencesCheckBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.updateReferencesCheckBox, gridBagConstraints);
        this.refactorAllCheckBox.setSelected(CssPreferences.findInUnrelatedFiles());
        Mnemonics.setLocalizedText((AbstractButton)this.refactorAllCheckBox, (String)NbBundle.getMessage(RenamePanel.class, (String)"refactorAllCheckBoxText"));
        this.refactorAllCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RenamePanel.this.refactorAllCheckBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        this.add((Component)this.refactorAllCheckBox, gridBagConstraints);
    }

    private void updateReferencesCheckBoxActionPerformed(ActionEvent evt) {
        this.textCheckBox.setEnabled(!this.updateReferencesCheckBox.isSelected());
    }

    private void textCheckBoxItemStateChanged(ItemEvent evt) {
    }

    private void textCheckBoxActionPerformed(ActionEvent evt) {
    }

    private void refactorAllCheckBoxActionPerformed(ActionEvent evt) {
        CssPreferences.setFindInUnrelatedFiles(this.refactorAllCheckBox.isSelected());
    }

    public String getNameValue() {
        return this.nameField.getText();
    }

    public boolean isRefactorAllOccurances() {
        return this.refactorAllCheckBox.isSelected();
    }

    public boolean searchJavadoc() {
        return this.textCheckBox.isSelected();
    }

    public boolean isUpdateReferences() {
        return !this.updateReferencesCheckBox.isVisible() || !this.updateReferencesCheckBox.isSelected();
    }

    public Component getComponent() {
        return this;
    }
}

