/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.project.libraries;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import javax.swing.border.EmptyBorder;
import org.netbeans.api.progress.BaseProgressUtils;
import org.netbeans.api.project.libraries.Bundle;
import org.netbeans.api.project.libraries.LibrariesCustomizer;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryChooser;
import org.netbeans.api.project.libraries.LibraryManager;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.BeanTreeView;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.NodeNotFoundException;
import org.openide.nodes.NodeOp;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;

class LibraryChooserGUI
extends JPanel
implements ExplorerManager.Provider,
HelpCtx.Provider,
LibraryChooser.Panel {
    private final LibraryManager manager;
    private final LibraryChooser.Filter filter;
    private final ExplorerManager explorer;
    private LibraryChooser.LibraryImportHandler importHandler;
    private DialogDescriptor dialogDescriptor;
    private JButton createButton;
    private JButton importButton;
    private JLabel librariesLabel;
    private JButton manageLibrariesButton;
    private BeanTreeView tree;

    private LibraryChooserGUI(LibraryManager manager, LibraryChooser.Filter filter, LibraryChooser.LibraryImportHandler importHandler) {
        if (manager == null) {
            manager = LibraryManager.getDefault();
        }
        this.manager = manager;
        this.filter = filter;
        this.importHandler = importHandler;
        this.explorer = new ExplorerManager();
        this.initComponents();
        this.tree.setDefaultActionAllowed(true);
    }

    public static LibraryChooser.Panel createPanel(LibraryManager manager, LibraryChooser.Filter filter) {
        LibraryChooserGUI l = new LibraryChooserGUI(manager, filter, null);
        l.configureForEmbedded();
        return l;
    }

    public static Set<Library> showChooser(LibraryManager manager, LibraryChooser.Filter filter, LibraryChooser.LibraryImportHandler handler, boolean addOperation) {
        LibraryChooserGUI l = new LibraryChooserGUI(manager, filter, handler);
        return l.showDialog(addOperation);
    }

    private Set<Library> showDialog(boolean addOperatation) {
        String buttonA11YDesc;
        String buttonA11YName;
        String buttonLabel;
        String title;
        this.manageLibrariesButton.setVisible(false);
        this.importButton.setVisible(this.manager.getLocation() != null && this.importHandler != null);
        JPanel inset = new JPanel(new BorderLayout());
        inset.setBorder(new EmptyBorder(12, 12, 0, 12));
        inset.add(this);
        if (addOperatation) {
            title = NbBundle.getMessage(LibraryChooserGUI.class, (String)"LibraryChooserGUI.add.title");
            buttonLabel = NbBundle.getMessage(LibraryChooserGUI.class, (String)"LibraryChooserGUI.add.button");
            buttonA11YName = NbBundle.getMessage(LibraryChooserGUI.class, (String)"LibraryChooserGUI.add.button");
            buttonA11YDesc = NbBundle.getMessage(LibraryChooserGUI.class, (String)"LibraryChooserGUI.add.button.a11y.desc");
        } else {
            title = NbBundle.getMessage(LibraryChooserGUI.class, (String)"LibraryChooserGUI.import.title");
            buttonLabel = NbBundle.getMessage(LibraryChooserGUI.class, (String)"LibraryChooserGUI.import.button");
            buttonA11YName = NbBundle.getMessage(LibraryChooserGUI.class, (String)"LibraryChooserGUI.import.button");
            buttonA11YDesc = NbBundle.getMessage(LibraryChooserGUI.class, (String)"LibraryChooserGUI.import.button.a11y.desc");
            this.createButton.setVisible(false);
        }
        inset.getAccessibleContext().setAccessibleName(NbBundle.getMessage(LibraryChooserGUI.class, (String)"LibraryChooserGUI.AccessibleContext.accessibleName"));
        inset.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(LibraryChooserGUI.class, (String)"LibraryChooserGUI.accessibleDescription"));
        this.dialogDescriptor = new DialogDescriptor((Object)inset, title);
        this.dialogDescriptor.setModal(true);
        final JButton add = new JButton(buttonLabel);
        add.setEnabled(false);
        add.setDefaultCapable(true);
        add.getAccessibleContext().setAccessibleName(buttonA11YName);
        add.getAccessibleContext().setAccessibleDescription(buttonA11YDesc);
        this.explorer.addPropertyChangeListener(new PropertyChangeListener(){
            final /* synthetic */ LibraryChooserGUI this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                add.setEnabled(!this.this$0.getSelectedLibraries().isEmpty());
            }
        });
        this.dialogDescriptor.setOptions(new Object[]{add, NotifyDescriptor.CANCEL_OPTION});
        this.dialogDescriptor.setClosingOptions(new Object[]{add, NotifyDescriptor.CANCEL_OPTION});
        if (DialogDisplayer.getDefault().notify((NotifyDescriptor)this.dialogDescriptor) == add) {
            Set<Library> selection = this.getSelectedLibraries();
            assert (!selection.isEmpty());
            return selection;
        }
        return null;
    }

    private void configureForEmbedded() {
        this.explorer.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                LibraryChooserGUI.this.firePropertyChange("selectedLibraries", null, null);
            }
        });
        this.createButton.setVisible(false);
        this.importButton.setVisible(false);
    }

    @Override
    public Set<Library> getSelectedLibraries() {
        HashSet<Library> s = new HashSet<Library>();
        for (Node n : this.explorer.getSelectedNodes()) {
            Library l = (Library)n.getLookup().lookup(Library.class);
            if (l == null) {
                return Collections.emptySet();
            }
            s.add(l);
        }
        return s;
    }

    @Override
    public Component getVisualComponent() {
        return this;
    }

    public ExplorerManager getExplorerManager() {
        return this.explorer;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(LibraryChooserGUI.class);
    }

    private void setRootNode() {
        this.explorer.setRootContext((Node)new AbstractNode((Children)new LibraryManagerChildren()));
        this.tree.expandAll();
        try {
            if (this.explorer.getRootContext().getChildren().getNodes(true).length > 0) {
                this.explorer.setSelectedNodes(new Node[]{this.explorer.getRootContext().getChildren().getNodes(true)[0]});
            }
        }
        catch (PropertyVetoException x) {
            Exceptions.printStackTrace((Throwable)x);
        }
        this.tree.requestFocus();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.setRootNode();
    }

    private void initComponents() {
        this.librariesLabel = new JLabel();
        this.tree = new BeanTreeView();
        this.createButton = new JButton();
        this.importButton = new JButton();
        this.manageLibrariesButton = new JButton();
        this.librariesLabel.setLabelFor((Component)this.tree);
        Mnemonics.setLocalizedText((JLabel)this.librariesLabel, (String)NbBundle.getMessage(LibraryChooserGUI.class, (String)"LibraryChooserGUI.librariesLabel"));
        this.tree.setBorder(BorderFactory.createEtchedBorder());
        this.tree.setRootVisible(false);
        Mnemonics.setLocalizedText((AbstractButton)this.createButton, (String)NbBundle.getMessage(LibraryChooserGUI.class, (String)"LibraryChooserGUI.createButton.text"));
        this.createButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LibraryChooserGUI.this.createButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.importButton, (String)NbBundle.getMessage(LibraryChooserGUI.class, (String)"LibraryChooserGUI.importButton.text"));
        this.importButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LibraryChooserGUI.this.importButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.manageLibrariesButton, (String)NbBundle.getMessage(LibraryChooserGUI.class, (String)"LibraryChooserGUI.manageLibrariesButton.text"));
        this.manageLibrariesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LibraryChooserGUI.this.manageLibrariesButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.librariesLabel).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent((Component)this.tree, -1, 249, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.createButton).addComponent(this.importButton))).addGroup(layout.createSequentialGroup().addComponent(this.manageLibrariesButton).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.librariesLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.createButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.importButton)).addComponent((Component)this.tree, -1, 284, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.manageLibrariesButton)));
        this.librariesLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(LibraryChooserGUI.class, (String)"ACSD_AvailableLibraries"));
        this.tree.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(LibraryChooserGUI.class, (String)"ACSD_AvailableLibrariesTree"));
        this.createButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(LibraryChooserGUI.class, (String)"LibraryChooserGUI.create.a11y.name"));
        this.createButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(LibraryChooserGUI.class, (String)"LibraryChooserGUI.create.a11y.desc"));
        this.importButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(LibraryChooserGUI.class, (String)"LibraryChooserGUI.import.a11y.name"));
        this.importButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(LibraryChooserGUI.class, (String)"LibraryChooserGUI.import.a11y.desc"));
        this.manageLibrariesButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(LibraryChooserGUI.class, (String)"ACSD_ManageLibraries"));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(LibraryChooserGUI.class, (String)"LibraryChooserGUI.AccessibleContext.accessibleName"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(LibraryChooserGUI.class, (String)"LibraryChooserGUI.accessibleDescription"));
    }

    private void manageLibrariesButtonActionPerformed(ActionEvent evt) {
        if (LibrariesCustomizer.showCustomizer(null, this.manager)) {
            this.setRootNode();
        }
    }

    private void createButtonActionPerformed(ActionEvent evt) {
        Library l = LibrariesCustomizer.showCreateNewLibraryCustomizer(this.manager);
        if (l != null) {
            this.setRootNode();
            this.selectLibrary(Collections.singleton(l));
        }
    }

    private void selectLibrary(Collection<Library> libraries) {
        Node root = this.explorer.getRootContext();
        ArrayList<Node> selection = new ArrayList<Node>();
        for (Library lib : libraries) {
            String[] path = new String[]{lib.getManager().getDisplayName(), lib.getName()};
            try {
                Node node = NodeOp.findPath((Node)root, (String[])path);
                if (node == null) continue;
                selection.add(node);
            }
            catch (NodeNotFoundException nodeNotFoundException) {}
        }
        try {
            this.explorer.setSelectedNodes(selection.toArray(new Node[0]));
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    private void importButtonActionPerformed(ActionEvent evt) {
        final Set<Library> libs = LibraryChooserGUI.showChooser(LibraryManager.getDefault(), new IgnoreAlreadyImportedLibrariesFilter(), null, false);
        if (libs != null) {
            Runnable r = new Runnable(){
                final /* synthetic */ LibraryChooserGUI this$0;
                {
                    this.this$0 = this$0;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        final HashSet<Library> importedLibs = new HashSet<Library>();
                        for (Library lib : libs) {
                            importedLibs.add(this.this$0.importHandler.importLibrary(lib));
                        }
                        EventQueue.invokeLater(new Runnable(){
                            final /* synthetic */ 6 this$1;
                            {
                                this.this$1 = this$1;
                            }

                            @Override
                            public void run() {
                                this.this$1.this$0.setRootNode();
                                this.this$1.this$0.selectLibrary(importedLibs);
                            }
                        });
                    }
                    catch (IOException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                    finally {
                        this.this$0.enableButtons(true);
                    }
                }
            };
            this.enableButtons(false);
            BaseProgressUtils.showProgressDialogAndRun((Runnable)r, (String)Bundle.LBL_Importing());
        }
    }

    private void enableButtons(boolean enable) {
        this.importButton.setEnabled(enable);
        this.createButton.setEnabled(enable);
        this.manageLibrariesButton.setEnabled(enable);
    }

    private class LibraryManagerChildren
    extends Children.Keys<LibraryManager> {
        private LibraryManagerChildren() {
        }

        protected void addNotify() {
            super.addNotify();
            if (LibraryChooserGUI.this.manager != null) {
                this.setKeys(Collections.singleton(LibraryChooserGUI.this.manager));
            }
        }

        protected Node[] createNodes(LibraryManager mgr) {
            ArrayList<Library> libs = new ArrayList<Library>();
            for (Library lib : mgr.getLibraries()) {
                if (LibraryChooserGUI.this.filter != null && !LibraryChooserGUI.this.filter.accept(lib)) continue;
                libs.add(lib);
            }
            if (libs.isEmpty()) {
                return new Node[0];
            }
            libs.sort(new Comparator<Library>(){
                Collator COLL = Collator.getInstance();

                @Override
                public int compare(Library lib1, Library lib2) {
                    return this.COLL.compare(lib1.getDisplayName(), lib2.getDisplayName());
                }
            });
            AbstractNode n = new AbstractNode((Children)new LibraryChildren(libs)){
                Node iconDelegate;
                {
                    this.iconDelegate = DataFolder.findFolder((FileObject)FileUtil.getConfigRoot()).getNodeDelegate();
                }

                public Image getIcon(int type) {
                    return this.iconDelegate.getIcon(type);
                }

                public Image getOpenedIcon(int type) {
                    return this.iconDelegate.getOpenedIcon(type);
                }
            };
            n.setName(mgr.getDisplayName());
            n.setDisplayName(mgr.getDisplayName());
            return new Node[]{n};
        }
    }

    private class IgnoreAlreadyImportedLibrariesFilter
    implements LibraryChooser.Filter {
        private IgnoreAlreadyImportedLibrariesFilter() {
        }

        @Override
        public boolean accept(Library library) {
            return LibraryChooserGUI.this.manager.getLibrary(library.getName()) == null;
        }
    }

    private class LibraryNode
    extends AbstractNode {
        private final Action[] actions;
        private final Action addAction;

        LibraryNode(Library lib) {
            super(Children.LEAF, Lookups.singleton((Object)lib));
            this.actions = new Action[0];
            this.addAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ((JButton)LibraryChooserGUI.this.dialogDescriptor.getOptions()[0]).doClick();
                }
            };
            this.setName(lib.getName());
            this.setDisplayName(lib.getDisplayName());
            this.setShortDescription(lib.getDescription());
            this.setIconBaseWithExtension("org/netbeans/modules/project/libraries/resources/libraries.gif");
        }

        public Action[] getActions(boolean context) {
            return this.actions;
        }

        public Action getPreferredAction() {
            return LibraryChooserGUI.this.dialogDescriptor == null ? null : this.addAction;
        }
    }

    private class LibraryChildren
    extends Children.Keys<Library> {
        LibraryChildren(List<Library> libs) {
            this.setKeys(libs);
        }

        protected Node[] createNodes(Library lib) {
            return new Node[]{new LibraryNode(lib)};
        }
    }
}

