/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle.java.spi.support;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.modules.gradle.java.spi.support.Bundle;
import org.netbeans.modules.gradle.spi.Utils;
import org.netbeans.spi.java.platform.JavaPlatformFactory;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;

public final class JavaToolchainSupport {
    private final Map<File, JavaPlatform> platformCache = new ConcurrentHashMap<File, JavaPlatform>();
    private static JavaToolchainSupport instance;
    private static final Pattern GRADLE_JDK_DIST;

    private JavaToolchainSupport() {
    }

    public static JavaToolchainSupport getDefault() {
        if (instance == null) {
            instance = new JavaToolchainSupport();
        }
        return instance;
    }

    public JavaPlatform platformByHome(File home) {
        return home.isDirectory() ? this.platformCache.computeIfAbsent(home, this::detectPlatform) : null;
    }

    private JavaPlatform detectPlatform(File home) {
        FileObject h = FileUtil.toFileObject((File)home);
        for (JavaPlatform platform : JavaPlatformManager.getDefault().getInstalledPlatforms()) {
            FileObject ph;
            if (!platform.isValid() || !(ph = (FileObject)platform.getInstallFolders().iterator().next()).equals(h)) continue;
            return platform;
        }
        for (JavaPlatformFactory.Provider pvd : Lookup.getDefault().lookupAll(JavaPlatformFactory.Provider.class)) {
            JavaPlatformFactory factory = pvd.forType("j2se");
            if (factory == null) continue;
            try {
                JavaPlatform ret = factory.create(h, JavaToolchainSupport.toolchainName(home), false);
                return ret;
            }
            catch (IOException iOException) {
            }
        }
        return null;
    }

    private static String toolchainName(File home) {
        Matcher m;
        File distDir = home.getParentFile();
        if (distDir != null && (m = GRADLE_JDK_DIST.matcher(distDir.getName())).matches()) {
            String vendor = Utils.capitalize((String)m.group(1).replace('_', ' '));
            String version = m.group(2);
            String arch = m.group(3);
            String os = m.group(4);
            return Bundle.GRADLE_INSTALLED_JDK_NAME(vendor, version, arch, os);
        }
        return Bundle.OTHER_JDK_NAME(home.getName(), home.getAbsolutePath());
    }

    static {
        GRADLE_JDK_DIST = Pattern.compile("(\\w+)-(\\d+)-(\\w+)-(\\w+)");
    }
}

