/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.i18n;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditorSupport;
import java.util.Locale;
import org.netbeans.modules.properties.LocalePanel;

public class LocalePropertyEditor
extends PropertyEditorSupport {
    private Locale locale;

    @Override
    public void setValue(Object value) {
        if (!(value instanceof Locale)) {
            throw new IllegalArgumentException("I18N module: Bad class type of value:" + value.getClass().getName());
        }
        if (this.locale != null && this.locale.equals(value)) {
            return;
        }
        this.locale = (Locale)value;
        this.firePropertyChange();
    }

    @Override
    public Object getValue() {
        return this.locale;
    }

    @Override
    public String getAsText() {
        if (this.locale == null) {
            return super.getAsText();
        }
        return this.locale.toString();
    }

    @Override
    public void setAsText(String text) throws IllegalArgumentException {
        this.setValue(LocalePropertyEditor.createLocaleFromText(text));
    }

    @Override
    public String getJavaInitializationString() {
        if (this.locale == null) {
            return super.getJavaInitializationString();
        }
        StringBuffer localeInit = new StringBuffer("new Locale(");
        String language = this.locale.getLanguage();
        String country = this.locale.getCountry();
        String variant = this.locale.getVariant();
        if (language == null) {
            localeInit.append("\"\"");
        } else {
            localeInit.append("\"" + language + "\"");
        }
        if (country == null) {
            localeInit.append(",\"\"");
        } else {
            localeInit.append(",\"" + country + "\"");
        }
        if (variant == null) {
            localeInit.append(")");
        } else {
            localeInit.append(",\"" + variant + "\")");
        }
        return localeInit.toString();
    }

    @Override
    public boolean supportsCustomEditor() {
        return true;
    }

    @Override
    public Component getCustomEditor() {
        final LocalePanel localePanel = new LocalePanel(this.locale);
        localePanel.addPropertyChangeListener(new PropertyChangeListener(){
            final /* synthetic */ LocalePropertyEditor this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("customized_locale".equals(evt.getPropertyName())) {
                    this.this$0.setValue(localePanel.getLocale());
                }
            }
        });
        return localePanel;
    }

    private static Locale createLocaleFromText(String text) {
        if (text == null || "".equals(text)) {
            return new Locale("", "");
        }
        int underscore = text.indexOf(95);
        if (underscore == -1) {
            return new Locale(text, "");
        }
        String language = underscore == 0 ? "" : text.substring(0, underscore);
        if (text.length() <= underscore + 1) {
            return new Locale(language, "");
        }
        if ((underscore = (text = text.substring(underscore + 1)).indexOf(95)) == -1) {
            return new Locale(language, text);
        }
        String country = underscore == 0 ? "" : text.substring(0, underscore);
        if (text.length() <= underscore + 1) {
            return new Locale(language, country);
        }
        String variant = text.substring(underscore + 1);
        return new Locale(language, country, variant);
    }
}

