/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.builder;

import com.sun.tools.javac.code.Scope;
import com.sun.tools.javac.code.Source;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.TypeTag;
import com.sun.tools.javac.model.JavacTypes;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Names;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;
import org.netbeans.modules.java.source.base.SourceLevelUtils;

public class ElementsService {
    private com.sun.tools.javac.code.Types jctypes;
    private Names names;
    private Types types;
    private final boolean allowDefaultMethods;
    private static final Context.Key<ElementsService> KEY = new Context.Key();

    public static ElementsService instance(Context context) {
        ElementsService instance = context.get(KEY);
        if (instance == null) {
            instance = new ElementsService(context);
        }
        return instance;
    }

    protected ElementsService(Context context) {
        context.put(KEY, this);
        this.jctypes = com.sun.tools.javac.code.Types.instance(context);
        this.names = Names.instance(context);
        this.types = JavacTypes.instance(context);
        this.allowDefaultMethods = SourceLevelUtils.allowDefaultMethods(Source.instance(context));
    }

    public TypeElement outermostTypeElement(Element element) {
        Element e = element;
        Element prev = null;
        while (e.getKind() != ElementKind.PACKAGE) {
            prev = e;
            e = e.getEnclosingElement();
        }
        return prev instanceof TypeElement ? (TypeElement)prev : null;
    }

    public PackageElement packageElement(Element element) {
        Element e = element;
        while (e.getKind() != ElementKind.PACKAGE) {
            e = e.getEnclosingElement();
        }
        return (PackageElement)e;
    }

    public boolean overridesMethod(ExecutableElement element) {
        Symbol.MethodSymbol m = (Symbol.MethodSymbol)element;
        if ((m.flags() & 8L) == 0L) {
            Symbol.ClassSymbol owner = (Symbol.ClassSymbol)m.owner;
            Type sup = this.jctypes.supertype(m.owner.type);
            while (sup.hasTag(TypeTag.CLASS)) {
                for (Symbol sym : sup.tsym.members().getSymbolsByName(m.name)) {
                    if (!m.overrides(sym, owner, this.jctypes, true)) continue;
                    return true;
                }
                sup = this.jctypes.supertype(sup);
            }
        }
        return false;
    }

    public boolean implementsMethod(ExecutableElement element) {
        Symbol.MethodSymbol m = (Symbol.MethodSymbol)element;
        Symbol.TypeSymbol owner = (Symbol.TypeSymbol)m.owner;
        for (Type type : this.jctypes.interfaces(m.owner.type)) {
            for (Symbol sym : type.tsym.members().getSymbolsByName(m.name)) {
                if (!m.overrides(sym, owner, this.jctypes, true)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean alreadyDefinedIn(CharSequence name, ExecutableType method, TypeElement enclClass) {
        Type.MethodType meth = ((Type)((Object)method)).asMethodType();
        Symbol.ClassSymbol clazz = (Symbol.ClassSymbol)enclClass;
        Scope.WriteableScope scope = clazz.members();
        Name n = this.names.fromString(name.toString());
        for (Symbol sym : scope.getSymbolsByName(n, Scope.LookupKind.NON_RECURSIVE)) {
            if (!(sym.type instanceof ExecutableType) || !this.types.isSubsignature(meth, (ExecutableType)((Object)sym.type))) continue;
            return true;
        }
        return false;
    }

    public boolean alreadyDefinedIn(CharSequence name, TypeMirror returnType, java.util.List<TypeMirror> paramTypes, TypeElement enclClass) {
        Symbol.ClassSymbol clazz = (Symbol.ClassSymbol)enclClass;
        Scope.WriteableScope scope = clazz.members();
        Name n = this.names.fromString(name.toString());
        ListBuffer<Type> buff = new ListBuffer<Type>();
        for (TypeMirror tm : paramTypes) {
            buff.append((Type)tm);
        }
        for (Symbol sym : scope.getSymbolsByName(n, Scope.LookupKind.NON_RECURSIVE)) {
            if (!(sym.type instanceof ExecutableType) || !this.jctypes.containsTypeEquivalent((List<Type>)sym.type.asMethodType().getParameterTypes(), buff.toList()) || !this.jctypes.isSameType(sym.type.asMethodType().getReturnType(), (Type)returnType)) continue;
            return true;
        }
        return false;
    }

    public boolean isMemberOf(Element e, TypeElement type) {
        return ((Symbol)e).isMemberOf((Symbol.TypeSymbol)((Object)type), this.jctypes);
    }

    public boolean isDeprecated(Element element) {
        Symbol sym = (Symbol)element;
        if ((sym.flags() & 0x20000L) != 0L && (sym.owner.flags() & 0x20000L) == 0L) {
            return true;
        }
        Symbol.ClassSymbol owner = sym.enclClass();
        Type sup = this.jctypes.supertype(owner.type);
        while (sup.hasTag(TypeTag.CLASS)) {
            for (Symbol symbol : sup.tsym.members().getSymbolsByName(sym.name)) {
                if (!sym.overrides(symbol, owner, this.jctypes, true) || (symbol.flags() & 0x20000L) == 0L) continue;
                return true;
            }
            sup = this.jctypes.supertype(sup);
        }
        return false;
    }

    public boolean isLocal(Element element) {
        Element encl = element.getEnclosingElement();
        if (encl == null || encl.getKind() == ElementKind.PACKAGE || encl.getKind() == ElementKind.MODULE) {
            return false;
        }
        if (encl.getKind().isClass() || encl.getKind().isInterface()) {
            return this.isLocal(encl);
        }
        return true;
    }

    public CharSequence getFullName(Element element) {
        Symbol sym = (Symbol)element;
        return element instanceof Symbol.ClassSymbol ? ((Symbol.ClassSymbol)element).fullname : Symbol.TypeSymbol.formFullName(sym.name, sym.owner);
    }

    private static boolean hasImplementation(Symbol.MethodSymbol msym) {
        long f = msym.flags();
        return (f & 0x80000000000L) != 0L || (f & 0x400L) == 0L;
    }

    public Element getImplementationOf(ExecutableElement method, TypeElement origin) {
        Symbol.MethodSymbol msym = (Symbol.MethodSymbol)method;
        Symbol.MethodSymbol implmethod = msym.implementation((Symbol.TypeSymbol)((Object)origin), this.jctypes, true);
        if ((msym.flags() & 8L) != 0L) {
            if (this.jctypes.isSubtype(((Symbol.TypeSymbol)((Object)origin)).type, ((Symbol.TypeSymbol)((Symbol.MethodSymbol)method).owner).type)) {
                return method;
            }
            return null;
        }
        if ((implmethod == null || implmethod == method) && this.allowDefaultMethods) {
            List<Symbol.MethodSymbol> candidates;
            List<Symbol.MethodSymbol> ptr = candidates = this.jctypes.interfaceCandidates(((Symbol.TypeSymbol)((Object)origin)).type, (Symbol.MethodSymbol)method);
            block0: while (ptr.head != null) {
                Symbol.MethodSymbol prov = (Symbol.MethodSymbol)ptr.head;
                if (prov != null && prov.overrides((Symbol.MethodSymbol)method, (Symbol.TypeSymbol)((Object)origin), this.jctypes, true) && ElementsService.hasImplementation(prov)) {
                    List<Symbol.MethodSymbol> sibling = candidates;
                    while (sibling.head != null) {
                        Symbol.MethodSymbol redeclare = (Symbol.MethodSymbol)sibling.head;
                        if (!prov.overrides(redeclare, (Symbol.TypeSymbol)((Object)origin), this.jctypes, this.allowDefaultMethods)) break block0;
                        sibling = sibling.tail;
                    }
                    implmethod = prov;
                    break;
                }
                ptr = ptr.tail;
            }
        }
        return implmethod;
    }

    public boolean isSynthetic(Element e) {
        return (((Symbol)e).flags() & 0x1000L) != 0L || (((Symbol)e).flags() & 0x1000000000L) != 0L;
    }

    public ExecutableElement getOverriddenMethod(ExecutableElement method) {
        Symbol.MethodSymbol m = (Symbol.MethodSymbol)method;
        if ((m.flags() & 8L) != 0L) {
            return null;
        }
        Symbol.ClassSymbol origin = (Symbol.ClassSymbol)m.owner;
        Symbol.MethodSymbol bridgeCandidate = null;
        Type t = this.jctypes.supertype(origin.type);
        while (t.hasTag(TypeTag.CLASS)) {
            Symbol.TypeSymbol c = t.tsym;
            for (Symbol sym : c.members().getSymbolsByName(m.name)) {
                if (!m.overrides(sym, origin, this.jctypes, false)) continue;
                if ((sym.flags() & 0x80000000L) > 0L) {
                    if (bridgeCandidate != null) continue;
                    bridgeCandidate = (Symbol.MethodSymbol)sym;
                    continue;
                }
                return (Symbol.MethodSymbol)sym;
            }
            t = this.jctypes.supertype(t);
        }
        if (this.allowDefaultMethods) {
            List<Symbol.MethodSymbol> candidates = this.jctypes.interfaceCandidates(origin.type, (Symbol.MethodSymbol)method);
            while (candidates != null) {
                Symbol.MethodSymbol prov = (Symbol.MethodSymbol)candidates.head;
                if (prov != null && prov != method && m.overrides(prov, origin, this.jctypes, true) && ElementsService.hasImplementation(prov)) {
                    if ((prov.flags() & 0x80000000L) > 0L) {
                        if (bridgeCandidate == null) {
                            bridgeCandidate = prov;
                        }
                    } else {
                        return prov;
                    }
                }
                candidates = candidates.tail;
            }
        }
        return bridgeCandidate;
    }
}

