/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.lib2.document;

import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import javax.swing.undo.UndoManager;

public abstract class UndoRedoDocumentEventResolver {
    private static UndoRedoDocumentEventResolver resolverChain;
    private UndoRedoDocumentEventResolver next;

    public static synchronized boolean isUndoRedoEvent(DocumentEvent evt) {
        UndoRedoDocumentEventResolver resolver = resolverChain;
        while (resolver != null) {
            if (resolver.isUndoRedo(evt)) {
                return true;
            }
            resolver = resolver.next;
        }
        return false;
    }

    public static synchronized void register(UndoRedoDocumentEventResolver resolver) {
        resolver.next = resolverChain;
        resolverChain = resolver;
    }

    public abstract boolean isUndoRedo(DocumentEvent var1);

    static {
        UndoRedoDocumentEventResolver.register(new SwingUndoRedoResolver());
    }

    private static final class SwingUndoRedoResolver
    extends UndoRedoDocumentEventResolver {
        private final Class swingUndoRedoDocEventClass;

        SwingUndoRedoResolver() {
            PlainDocument doc = new PlainDocument();
            final Class[] urCls = new Class[1];
            try {
                UndoManager um = new UndoManager();
                doc.addUndoableEditListener(um);
                doc.insertString(0, "a", null);
                doc.addDocumentListener(new DocumentListener(){
                    final /* synthetic */ SwingUndoRedoResolver this$0;
                    {
                        this.this$0 = this$0;
                    }

                    @Override
                    public void insertUpdate(DocumentEvent e) {
                    }

                    @Override
                    public void removeUpdate(DocumentEvent e) {
                        urCls[0] = e.getClass();
                    }

                    @Override
                    public void changedUpdate(DocumentEvent e) {
                        throw new UnsupportedOperationException("Not supported yet.");
                    }
                });
                um.undo();
            }
            catch (BadLocationException ex) {
                throw new IllegalStateException(ex);
            }
            this.swingUndoRedoDocEventClass = urCls[0];
            assert (this.swingUndoRedoDocEventClass != null);
        }

        @Override
        public boolean isUndoRedo(DocumentEvent evt) {
            return evt.getClass() == this.swingUndoRedoDocEventClass;
        }
    }
}

