/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.connections.ui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.php.api.util.StringUtils;
import org.netbeans.modules.php.project.connections.ConfigManager;
import org.netbeans.modules.php.project.connections.RemoteConnections;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotificationLineSupport;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public final class NewRemoteConnectionPanel
extends JPanel {
    private static final long serialVersionUID = 2806958431387531044L;
    private static final Logger LOGGER = Logger.getLogger(NewRemoteConnectionPanel.class.getName());
    private final ConfigManager configManager;
    private DialogDescriptor descriptor;
    private NotificationLineSupport notificationLineSupport;
    private JLabel connectionNameLabel;
    private JTextField connectionNameTextField;
    private JComboBox<String> connectionTypeComboBox;
    private JLabel connectionTypeLabel;

    public NewRemoteConnectionPanel(ConfigManager configManager) {
        this.configManager = configManager;
        this.initComponents();
        this.connectionTypeComboBox.setModel(new DefaultComboBoxModel<String>(new Vector<String>(RemoteConnections.get().getRemoteConnectionTypes())));
        this.registerListeners();
    }

    public boolean open() {
        this.descriptor = new DialogDescriptor((Object)this, NbBundle.getMessage(NewRemoteConnectionPanel.class, (String)"LBL_CreateNewConnection"), true, 2, DialogDescriptor.OK_OPTION, null);
        this.descriptor.setValid(false);
        this.notificationLineSupport = this.descriptor.createNotificationLineSupport();
        this.notificationLineSupport.setInformationMessage(NbBundle.getMessage(NewRemoteConnectionPanel.class, (String)"TXT_ProvideConnectionName"));
        return DialogDisplayer.getDefault().notify((NotifyDescriptor)this.descriptor) == NotifyDescriptor.OK_OPTION;
    }

    public String getConnectionName() {
        return this.connectionNameTextField.getText().trim();
    }

    public String getOldConfigName() {
        return this.getConnectionName().replaceAll("[^a-zA-Z0-9_.-]", "_");
    }

    public String getConfigName() {
        MessageDigest md;
        try {
            md = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException ex) {
            LOGGER.log(Level.WARNING, null, ex);
            return this.getOldConfigName();
        }
        md.update(this.getConnectionName().getBytes(StandardCharsets.UTF_8));
        byte[] digest = md.digest();
        BigInteger hash = new BigInteger(1, digest);
        String hashWord = hash.toString(16);
        String postfix = hashWord.substring(hashWord.length() - 6);
        return this.getOldConfigName() + "-" + postfix;
    }

    public String getConnectionType() {
        return (String)this.connectionTypeComboBox.getSelectedItem();
    }

    void validateFields() {
        String name = this.getConnectionName();
        String config = this.getConfigName();
        String oldConfig = this.getOldConfigName();
        String type = this.getConnectionType();
        String err = null;
        if (name.length() == 0) {
            err = NbBundle.getMessage(NewRemoteConnectionPanel.class, (String)"MSG_EmptyConnectionName");
        } else if (name.length() > 80) {
            err = NbBundle.getMessage(NewRemoteConnectionPanel.class, (String)"MSG_LongConnectionName", (Object)80);
        } else if (type.length() == 0) {
            err = NbBundle.getMessage(NewRemoteConnectionPanel.class, (String)"MSG_EmptyConnectionType");
        } else if (this.configManager.exists(config) || this.configManager.exists(oldConfig)) {
            err = NbBundle.getMessage(NewRemoteConnectionPanel.class, (String)"MSG_ConnectionExists", (Object)name);
        }
        this.setError(err);
    }

    private void registerListeners() {
        this.connectionNameTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.processUpdate();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.processUpdate();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.processUpdate();
            }

            private void processUpdate() {
                NewRemoteConnectionPanel.this.validateFields();
            }
        });
        this.connectionTypeComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NewRemoteConnectionPanel.this.validateFields();
            }
        });
    }

    private void setError(String msg) {
        assert (this.descriptor != null);
        assert (this.notificationLineSupport != null);
        if (StringUtils.hasText((String)msg)) {
            this.notificationLineSupport.setErrorMessage(msg);
            this.descriptor.setValid(false);
        } else {
            this.notificationLineSupport.clearMessages();
            this.descriptor.setValid(true);
        }
    }

    private void initComponents() {
        this.connectionNameLabel = new JLabel();
        this.connectionNameTextField = new JTextField();
        this.connectionTypeLabel = new JLabel();
        this.connectionTypeComboBox = new JComboBox();
        this.connectionNameLabel.setLabelFor(this.connectionNameTextField);
        Mnemonics.setLocalizedText((JLabel)this.connectionNameLabel, (String)NbBundle.getMessage(NewRemoteConnectionPanel.class, (String)"NewRemoteConnectionPanel.connectionNameLabel.text"));
        this.connectionNameTextField.setText(NbBundle.getMessage(NewRemoteConnectionPanel.class, (String)"NewRemoteConnectionPanel.connectionNameTextField.text"));
        this.connectionTypeLabel.setLabelFor(this.connectionTypeComboBox);
        Mnemonics.setLocalizedText((JLabel)this.connectionTypeLabel, (String)NbBundle.getMessage(NewRemoteConnectionPanel.class, (String)"NewRemoteConnectionPanel.connectionTypeLabel.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.connectionNameLabel).addComponent(this.connectionTypeLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.connectionTypeComboBox, 0, 221, Short.MAX_VALUE).addComponent(this.connectionNameTextField, GroupLayout.Alignment.LEADING, -1, 221, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.connectionNameLabel).addComponent(this.connectionNameTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.connectionTypeLabel).addComponent(this.connectionTypeComboBox, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.connectionNameLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(NewRemoteConnectionPanel.class, (String)"NewRemoteConnectionPanel.connectionNameLabel.AccessibleContext.accessibleName"));
        this.connectionNameLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NewRemoteConnectionPanel.class, (String)"NewRemoteConnectionPanel.connectionNameLabel.AccessibleContext.accessibleDescription"));
        this.connectionNameTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(NewRemoteConnectionPanel.class, (String)"NewRemoteConnectionPanel.connectionNameTextField.AccessibleContext.accessibleName"));
        this.connectionNameTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NewRemoteConnectionPanel.class, (String)"NewRemoteConnectionPanel.connectionNameTextField.AccessibleContext.accessibleDescription"));
        this.connectionTypeLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(NewRemoteConnectionPanel.class, (String)"NewRemoteConnectionPanel.connectionTypeLabel.AccessibleContext.accessibleName"));
        this.connectionTypeLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NewRemoteConnectionPanel.class, (String)"NewRemoteConnectionPanel.connectionTypeLabel.AccessibleContext.accessibleDescription"));
        this.connectionTypeComboBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(NewRemoteConnectionPanel.class, (String)"NewRemoteConnectionPanel.connectionTypeComboBox.AccessibleContext.accessibleName"));
        this.connectionTypeComboBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NewRemoteConnectionPanel.class, (String)"NewRemoteConnectionPanel.connectionTypeComboBox.AccessibleContext.accessibleDescription"));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(NewRemoteConnectionPanel.class, (String)"NewRemoteConnectionPanel.AccessibleContext.accessibleName"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NewRemoteConnectionPanel.class, (String)"NewRemoteConnectionPanel.AccessibleContext.accessibleDescription"));
    }
}

