/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.analysis;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.fileinfo.NonRecursiveFolder;
import org.netbeans.modules.analysis.spi.Analyzer;
import org.netbeans.modules.php.analysis.Bundle;
import org.netbeans.modules.php.analysis.PsalmParams;
import org.netbeans.modules.php.analysis.commands.Psalm;
import org.netbeans.modules.php.analysis.options.AnalysisOptions;
import org.netbeans.modules.php.analysis.results.Result;
import org.netbeans.modules.php.analysis.ui.analyzer.PsalmCustomizerPanel;
import org.netbeans.modules.php.analysis.util.AnalysisUtils;
import org.netbeans.modules.php.analysis.util.Mappers;
import org.netbeans.modules.php.api.executable.InvalidPhpExecutableException;
import org.netbeans.modules.php.api.util.StringUtils;
import org.netbeans.modules.refactoring.api.Scope;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.HintsController;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class PsalmAnalyzerImpl
implements Analyzer {
    private static final Logger LOGGER = Logger.getLogger(PsalmAnalyzerImpl.class.getName());
    private final Analyzer.Context context;
    private final AtomicBoolean cancelled = new AtomicBoolean();

    public PsalmAnalyzerImpl(Analyzer.Context context) {
        this.context = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterable<? extends ErrorDescription> analyze() {
        Preferences settings = this.context.getSettings();
        if (settings != null && !settings.getBoolean("psalm.enabled", false)) {
            return Collections.emptyList();
        }
        Psalm psalm = this.getValidPsalm();
        if (psalm == null) {
            this.context.reportAnalysisProblem(Bundle.PsalmAnalyzerImpl_psalm_error(), (CharSequence)Bundle.PsalmAnalyzerImpl_psalm_error_description());
            return Collections.emptyList();
        }
        PsalmParams psalmParams = new PsalmParams().setLevel(this.getValidPsalmLevel()).setConfiguration(this.getValidPsalmConfiguration()).setMemoryLimit(this.getValidPsalmMemoryLimit());
        Scope scope = this.context.getScope();
        Map<FileObject, Integer> fileCount = AnalysisUtils.countPhpFiles(scope);
        int totalCount = 0;
        for (Integer count : fileCount.values()) {
            totalCount += count.intValue();
        }
        this.context.start(totalCount);
        try {
            Iterable<? extends ErrorDescription> iterable = this.doAnalyze(scope, psalm, psalmParams, fileCount);
            return iterable;
        }
        finally {
            this.context.finish();
        }
    }

    public boolean cancel() {
        this.cancelled.set(true);
        return true;
    }

    private Iterable<? extends ErrorDescription> doAnalyze(Scope scope, Psalm psalm, PsalmParams params, Map<FileObject, Integer> fileCount) {
        List<Result> results;
        ArrayList<Object> errors = new ArrayList<Object>();
        int progress = 0;
        psalm.startAnalyzeGroup();
        for (FileObject root : scope.getSourceRoots()) {
            if (this.cancelled.get()) {
                return Collections.emptyList();
            }
            results = psalm.analyze(params, root);
            if (results == null) {
                this.context.reportAnalysisProblem(Bundle.PsalmAnalyzerImpl_analyze_error(), (CharSequence)Bundle.PsalmAnalyzerImpl_analyze_error_description());
                return Collections.emptyList();
            }
            errors.addAll(Mappers.map(results));
            this.context.progress(progress += fileCount.get(root).intValue());
        }
        for (FileObject file : scope.getFiles()) {
            if (this.cancelled.get()) {
                return Collections.emptyList();
            }
            results = psalm.analyze(params, file);
            if (results == null) {
                this.context.reportAnalysisProblem(Bundle.PsalmAnalyzerImpl_analyze_error(), (CharSequence)Bundle.PsalmAnalyzerImpl_analyze_error_description());
                return Collections.emptyList();
            }
            errors.addAll(Mappers.map(results));
            this.context.progress(progress += fileCount.get(file).intValue());
        }
        for (NonRecursiveFolder nonRecursiveFolder : scope.getFolders()) {
            if (this.cancelled.get()) {
                return Collections.emptyList();
            }
            FileObject folder = nonRecursiveFolder.getFolder();
            List<Result> results2 = psalm.analyze(params, folder);
            if (results2 == null) {
                this.context.reportAnalysisProblem(Bundle.PsalmAnalyzerImpl_analyze_error(), (CharSequence)Bundle.PsalmAnalyzerImpl_analyze_error_description());
                return Collections.emptyList();
            }
            errors.addAll(Mappers.map(results2));
            this.context.progress(progress += fileCount.get(folder).intValue());
        }
        return errors;
    }

    @CheckForNull
    private Psalm getValidPsalm() {
        String customizerPsalmPath = null;
        Preferences settings = this.context.getSettings();
        if (settings != null) {
            customizerPsalmPath = settings.get("psalm.path", null);
        }
        try {
            if (StringUtils.hasText(customizerPsalmPath)) {
                return Psalm.getCustom(customizerPsalmPath);
            }
            return Psalm.getDefault();
        }
        catch (InvalidPhpExecutableException ex) {
            LOGGER.log(Level.INFO, null, ex);
            return null;
        }
    }

    private String getValidPsalmLevel() {
        String psalmLevel = null;
        Preferences settings = this.context.getSettings();
        if (settings != null) {
            psalmLevel = settings.get("psalm.level", null);
        }
        if (psalmLevel == null) {
            psalmLevel = AnalysisOptions.getInstance().getPsalmLevel();
        }
        assert (psalmLevel != null);
        return AnalysisOptions.getValidPsalmLevel(psalmLevel);
    }

    @CheckForNull
    private FileObject getValidPsalmConfiguration() {
        String psalmConfiguration = null;
        Preferences settings = this.context.getSettings();
        if (settings != null) {
            psalmConfiguration = settings.get("psalm.configuration", null);
        }
        if (psalmConfiguration == null) {
            psalmConfiguration = AnalysisOptions.getInstance().getPsalmConfigurationPath();
        }
        if (StringUtils.isEmpty(psalmConfiguration)) {
            return null;
        }
        return FileUtil.toFileObject((File)new File(psalmConfiguration));
    }

    private String getValidPsalmMemoryLimit() {
        Preferences settings = this.context.getSettings();
        String memoryLimit = settings != null ? settings.get("psalm.memory.limit", "") : String.valueOf(AnalysisOptions.getInstance().getPsalmMemoryLimit());
        assert (memoryLimit != null);
        return memoryLimit;
    }

    public static final class PsalmAnalyzerFactory
    extends Analyzer.AnalyzerFactory {
        private static final String ICON_PATH = "org/netbeans/modules/php/analysis/ui/resources/psalm.png";

        public PsalmAnalyzerFactory() {
            super("Psalm", Bundle.PsalmAnalyzerFactory_displayName(), ICON_PATH);
        }

        public Iterable<? extends Analyzer.WarningDescription> getWarnings() {
            return Collections.emptyList();
        }

        public Analyzer.CustomizerProvider<Void, PsalmCustomizerPanel> getCustomizerProvider() {
            return new Analyzer.CustomizerProvider<Void, PsalmCustomizerPanel>(){

                public Void initialize() {
                    return null;
                }

                public PsalmCustomizerPanel createComponent(Analyzer.CustomizerContext<Void, PsalmCustomizerPanel> context) {
                    return new PsalmCustomizerPanel(context);
                }
            };
        }

        public Analyzer createAnalyzer(Analyzer.Context context) {
            return new PsalmAnalyzerImpl(context);
        }

        public void warningOpened(ErrorDescription warning) {
            HintsController.setErrors((FileObject)warning.getFile(), (String)"psalmWarning", Collections.singleton(warning));
        }
    }
}

