/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.database.model.UpdateDataGuardAssociationDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class UpdateDataGuardAssociationRequest
extends BmcRequest<UpdateDataGuardAssociationDetails> {
    private String databaseId;
    private String dataGuardAssociationId;
    private UpdateDataGuardAssociationDetails updateDataGuardAssociationDetails;
    private String ifMatch;
    private String opcRequestId;

    public String getDatabaseId() {
        return this.databaseId;
    }

    public String getDataGuardAssociationId() {
        return this.dataGuardAssociationId;
    }

    public UpdateDataGuardAssociationDetails getUpdateDataGuardAssociationDetails() {
        return this.updateDataGuardAssociationDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    @InternalSdk
    public UpdateDataGuardAssociationDetails getBody$() {
        return this.updateDataGuardAssociationDetails;
    }

    public Builder toBuilder() {
        return new Builder().databaseId(this.databaseId).dataGuardAssociationId(this.dataGuardAssociationId).updateDataGuardAssociationDetails(this.updateDataGuardAssociationDetails).ifMatch(this.ifMatch).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",databaseId=").append(String.valueOf(this.databaseId));
        sb.append(",dataGuardAssociationId=").append(String.valueOf(this.dataGuardAssociationId));
        sb.append(",updateDataGuardAssociationDetails=").append(String.valueOf((Object)this.updateDataGuardAssociationDetails));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateDataGuardAssociationRequest)) {
            return false;
        }
        UpdateDataGuardAssociationRequest other = (UpdateDataGuardAssociationRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.databaseId, other.databaseId) && Objects.equals(this.dataGuardAssociationId, other.dataGuardAssociationId) && Objects.equals((Object)this.updateDataGuardAssociationDetails, (Object)other.updateDataGuardAssociationDetails) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.databaseId == null ? 43 : this.databaseId.hashCode());
        result = result * 59 + (this.dataGuardAssociationId == null ? 43 : this.dataGuardAssociationId.hashCode());
        result = result * 59 + (this.updateDataGuardAssociationDetails == null ? 43 : this.updateDataGuardAssociationDetails.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<UpdateDataGuardAssociationRequest, UpdateDataGuardAssociationDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String databaseId = null;
        private String dataGuardAssociationId = null;
        private UpdateDataGuardAssociationDetails updateDataGuardAssociationDetails = null;
        private String ifMatch = null;
        private String opcRequestId = null;

        public Builder databaseId(String databaseId) {
            this.databaseId = databaseId;
            return this;
        }

        public Builder dataGuardAssociationId(String dataGuardAssociationId) {
            this.dataGuardAssociationId = dataGuardAssociationId;
            return this;
        }

        public Builder updateDataGuardAssociationDetails(UpdateDataGuardAssociationDetails updateDataGuardAssociationDetails) {
            this.updateDataGuardAssociationDetails = updateDataGuardAssociationDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateDataGuardAssociationRequest o) {
            this.databaseId(o.getDatabaseId());
            this.dataGuardAssociationId(o.getDataGuardAssociationId());
            this.updateDataGuardAssociationDetails(o.getUpdateDataGuardAssociationDetails());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateDataGuardAssociationRequest build() {
            UpdateDataGuardAssociationRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(UpdateDataGuardAssociationDetails body) {
            this.updateDataGuardAssociationDetails(body);
            return this;
        }

        public UpdateDataGuardAssociationRequest buildWithoutInvocationCallback() {
            UpdateDataGuardAssociationRequest request = new UpdateDataGuardAssociationRequest();
            request.databaseId = this.databaseId;
            request.dataGuardAssociationId = this.dataGuardAssociationId;
            request.updateDataGuardAssociationDetails = this.updateDataGuardAssociationDetails;
            request.ifMatch = this.ifMatch;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

