/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.composer.ui.actions;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.modules.php.api.executable.InvalidPhpExecutableException;
import org.netbeans.modules.php.api.phpmodule.PhpModule;
import org.netbeans.modules.php.api.util.UiUtils;
import org.netbeans.modules.php.composer.commands.Composer;
import org.netbeans.modules.php.composer.output.model.ComposerPackage;
import org.netbeans.modules.php.composer.ui.DependenciesPanel;
import org.netbeans.modules.php.composer.ui.actions.Bundle;
import org.netbeans.modules.php.composer.util.ComposerUtils;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

final class AddDependencyPanel
extends JPanel {
    private static final long serialVersionUID = -546689998137L;
    private static boolean keepOpened = true;
    private final PhpModule phpModule;
    private final DependenciesPanel dependenciesPanel;
    private JPanel innerPanel;
    private JCheckBox keepOpenCheckBox;
    private JButton requireButton;
    private JButton requireDevButton;

    private AddDependencyPanel(PhpModule phpModule) {
        assert (EventQueue.isDispatchThread());
        assert (phpModule != null);
        this.phpModule = phpModule;
        this.dependenciesPanel = DependenciesPanel.create(phpModule);
        this.initComponents();
        this.init();
    }

    public static void open(PhpModule phpModule) {
        assert (EventQueue.isDispatchThread());
        assert (phpModule != null);
        final AddDependencyPanel addDependencyPanel = new AddDependencyPanel(phpModule);
        Object[] options = new Object[]{addDependencyPanel.requireButton, addDependencyPanel.requireDevButton, DialogDescriptor.CANCEL_OPTION};
        DialogDescriptor descriptor = new DialogDescriptor((Object)addDependencyPanel, Bundle.AddDependencyPanel_panel_title(phpModule.getDisplayName()), false, options, (Object)addDependencyPanel.requireButton, 0, null, null);
        descriptor.setClosingOptions(new Object[]{DialogDescriptor.CANCEL_OPTION});
        descriptor.setAdditionalOptions(new Object[]{addDependencyPanel.keepOpenCheckBox});
        Dialog dialog = DialogDisplayer.getDefault().createDialog(descriptor);
        addDependencyPanel.dependenciesPanel.setDefaultAction(dialog, new Runnable(){

            @Override
            public void run() {
                if (addDependencyPanel.requireButton.isEnabled()) {
                    addDependencyPanel.requireButton.doClick();
                }
            }
        });
        AddDependencyPanel.handleKeepOpen(dialog, addDependencyPanel);
        dialog.setVisible(true);
    }

    private static void handleKeepOpen(final Dialog dialog, final AddDependencyPanel addDependencyPanel) {
        ActionListener keepOpenActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!addDependencyPanel.keepOpenCheckBox.isSelected()) {
                    dialog.setVisible(false);
                    dialog.dispose();
                }
            }
        };
        addDependencyPanel.requireButton.addActionListener(keepOpenActionListener);
        addDependencyPanel.requireDevButton.addActionListener(keepOpenActionListener);
    }

    private void init() {
        this.innerPanel.add((Component)this.dependenciesPanel, "Center");
        this.initActionButons();
        this.dependenciesPanel.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                AddDependencyPanel.this.enableRequireButtons();
            }
        });
    }

    private void initActionButons() {
        assert (EventQueue.isDispatchThread());
        this.enableRequireButtons();
        this.keepOpenCheckBox.setSelected(keepOpened);
        this.keepOpenCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                assert (EventQueue.isDispatchThread());
                keepOpened = e.getStateChange() == 1;
            }
        });
    }

    void enableRequireButtons() {
        assert (EventQueue.isDispatchThread());
        boolean validResultSelected = this.dependenciesPanel.getComposerPackage() != null;
        this.requireButton.setEnabled(validResultSelected);
        this.requireDevButton.setEnabled(validResultSelected);
    }

    @CheckForNull
    Composer getComposer() {
        try {
            return Composer.getDefault();
        }
        catch (InvalidPhpExecutableException ex) {
            UiUtils.invalidScriptProvided((String)Bundle.AddDependencyPanel_error_composer_notValid(), (String)"FrameworksAndTools/Composer");
            return null;
        }
    }

    private void initComposer(Composer composer, Runnable postTask) {
        assert (this.phpModule != null);
        Future<Integer> task = composer.initIfNotPresent(this.phpModule);
        if (task == null) {
            postTask.run();
            return;
        }
        this.runWhenTaskFinish(task, postTask, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void runWhenTaskFinish(Future<Integer> task, @NullAllowed Runnable postTask, @NullAllowed Runnable finalTask) {
        try {
            task.get(3L, TimeUnit.MINUTES);
            if (postTask != null) {
                postTask.run();
            }
        }
        catch (TimeoutException ex) {
            task.cancel(true);
        }
        catch (CancellationException ex) {
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException ex) {
            UiUtils.processExecutionException((ExecutionException)ex, (String)"FrameworksAndTools/Composer");
        }
        finally {
            if (finalTask != null) {
                finalTask.run();
            }
        }
    }

    private void initComponents() {
        this.requireButton = new JButton();
        this.requireDevButton = new JButton();
        this.keepOpenCheckBox = new JCheckBox();
        this.innerPanel = new JPanel();
        Mnemonics.setLocalizedText((AbstractButton)this.requireButton, (String)NbBundle.getMessage(AddDependencyPanel.class, (String)"AddDependencyPanel.requireButton.text"));
        this.requireButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AddDependencyPanel.this.requireButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.requireDevButton, (String)NbBundle.getMessage(AddDependencyPanel.class, (String)"AddDependencyPanel.requireDevButton.text"));
        this.requireDevButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AddDependencyPanel.this.requireDevButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.keepOpenCheckBox, (String)NbBundle.getMessage(AddDependencyPanel.class, (String)"AddDependencyPanel.keepOpenCheckBox.text"));
        this.innerPanel.setLayout(new BorderLayout());
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.innerPanel, -1, 550, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.innerPanel, -1, 321, Short.MAX_VALUE).addContainerGap()));
    }

    private void requireButtonActionPerformed(ActionEvent evt) {
        assert (EventQueue.isDispatchThread());
        final Composer composer = this.getComposer();
        if (composer == null) {
            return;
        }
        final ComposerPackage composerPackage = this.dependenciesPanel.getComposerPackage();
        assert (composerPackage != null);
        this.initComposer(composer, new Runnable(){
            final /* synthetic */ AddDependencyPanel this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                assert (EventQueue.isDispatchThread());
                assert (this.this$0.phpModule != null);
                ComposerUtils.logUsageComposerRequire();
                composer.require(this.this$0.phpModule, composerPackage.asFullPackage());
            }
        });
    }

    private void requireDevButtonActionPerformed(ActionEvent evt) {
        assert (EventQueue.isDispatchThread());
        final Composer composer = this.getComposer();
        if (composer == null) {
            return;
        }
        final ComposerPackage composerPackage = this.dependenciesPanel.getComposerPackage();
        this.initComposer(composer, new Runnable(){
            final /* synthetic */ AddDependencyPanel this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                assert (EventQueue.isDispatchThread());
                assert (this.this$0.phpModule != null);
                ComposerUtils.logUsageComposerRequire();
                composer.requireDev(this.this$0.phpModule, composerPackage.asFullPackage());
            }
        });
    }
}

