/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui;

import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Action;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.apisupport.project.suite.SuiteProject;
import org.netbeans.modules.apisupport.project.ui.ImportantFilesNodeFactory;
import org.netbeans.modules.apisupport.project.ui.SuiteActions;
import org.netbeans.spi.project.ui.LogicalViewProvider;
import org.netbeans.spi.project.ui.support.DefaultProjectOperations;
import org.netbeans.spi.project.ui.support.NodeFactorySupport;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Node;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;
import org.openide.util.lookup.Lookups;

public final class SuiteLogicalView
implements LogicalViewProvider {
    private final SuiteProject suite;

    public SuiteLogicalView(SuiteProject suite) {
        this.suite = suite;
    }

    public Node createLogicalView() {
        return new SuiteRootNode(this.suite);
    }

    public Node findPath(Node root, Object target) {
        DataObject file;
        if (root.getLookup().lookup(SuiteProject.class) != this.suite) {
            return null;
        }
        if (target instanceof FileObject) {
            try {
                file = DataObject.find((FileObject)((FileObject)target));
            }
            catch (DataObjectNotFoundException e) {
                return null;
            }
        } else if (target instanceof DataObject) {
            file = (DataObject)target;
        } else {
            return null;
        }
        Node impFilesNode = root.getChildren().findChild("important.files");
        if (impFilesNode != null) {
            Node[] impFiles = impFilesNode.getChildren().getNodes(true);
            for (int i = 0; i < impFiles.length; ++i) {
                if (impFiles[i].getCookie(DataObject.class) != file) continue;
                return impFiles[i];
            }
        }
        return null;
    }

    static final class SuiteRootNode
    extends AbstractNode
    implements PropertyChangeListener {
        private static final Image ICON = ImageUtilities.loadImage((String)"org/netbeans/modules/apisupport/project/suite/resources/suite.png", (boolean)true);
        private final SuiteProject suite;
        private final ProjectInformation info;

        SuiteRootNode(SuiteProject suite) {
            super(NodeFactorySupport.createCompositeChildren((Project)suite, (String)"Projects/org-netbeans-modules-apisupport-project-suite/Nodes"), Lookups.fixed((Object[])new Object[]{suite, DataFolder.findFolder((FileObject)suite.getProjectDirectory()), suite.getProjectDirectory()}));
            this.suite = suite;
            this.info = ProjectUtils.getInformation((Project)suite);
            this.info.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.info));
        }

        public String getName() {
            return this.info.getDisplayName();
        }

        public String getDisplayName() {
            return this.info.getDisplayName();
        }

        public String getShortDescription() {
            return NbBundle.getMessage(SuiteLogicalView.class, (String)"HINT_suite_project_root_node", (Object)FileUtil.getFileDisplayName((FileObject)this.suite.getProjectDirectory()));
        }

        public Action[] getActions(boolean context) {
            return SuiteActions.getProjectActions(this.suite);
        }

        public Image getIcon(int type) {
            return ICON;
        }

        public Image getOpenedIcon(int type) {
            return this.getIcon(type);
        }

        @Override
        public void propertyChange(final PropertyChangeEvent evt) {
            ImportantFilesNodeFactory.getNodesSyncRP().post(new Runnable(){
                final /* synthetic */ SuiteRootNode this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void run() {
                    if (evt.getPropertyName().equals("name")) {
                        this.this$0.fireNameChange(null, this.this$0.getName());
                    } else if (evt.getPropertyName().equals("displayName")) {
                        this.this$0.fireDisplayNameChange(null, this.this$0.getDisplayName());
                    }
                }
            });
        }

        public boolean canRename() {
            return true;
        }

        public void setName(String name) {
            DefaultProjectOperations.performDefaultRenameOperation((Project)this.suite, (String)name);
        }
    }
}

