/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identity.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.identity.model.IdentityProvider;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="protocol")
@JsonFilter(value="explicitlySetFilter")
public final class Saml2IdentityProvider
extends IdentityProvider {
    @JsonProperty(value="metadataUrl")
    private final String metadataUrl;
    @JsonProperty(value="metadata")
    private final String metadata;
    @JsonProperty(value="signingCertificate")
    private final String signingCertificate;
    @JsonProperty(value="redirectUrl")
    private final String redirectUrl;
    @JsonProperty(value="freeformAttributes")
    private final Map<String, String> freeformAttributes;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public Saml2IdentityProvider(String id, String compartmentId, String name, String description, String productType, Date timeCreated, IdentityProvider.LifecycleState lifecycleState, Long inactiveStatus, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags, String metadataUrl, String metadata, String signingCertificate, String redirectUrl, Map<String, String> freeformAttributes) {
        super(id, compartmentId, name, description, productType, timeCreated, lifecycleState, inactiveStatus, freeformTags, definedTags);
        this.metadataUrl = metadataUrl;
        this.metadata = metadata;
        this.signingCertificate = signingCertificate;
        this.redirectUrl = redirectUrl;
        this.freeformAttributes = freeformAttributes;
    }

    public String getMetadataUrl() {
        return this.metadataUrl;
    }

    public String getMetadata() {
        return this.metadata;
    }

    public String getSigningCertificate() {
        return this.signingCertificate;
    }

    public String getRedirectUrl() {
        return this.redirectUrl;
    }

    public Map<String, String> getFreeformAttributes() {
        return this.freeformAttributes;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("Saml2IdentityProvider(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", metadataUrl=").append(String.valueOf(this.metadataUrl));
        sb.append(", metadata=").append(String.valueOf(this.metadata));
        sb.append(", signingCertificate=").append(String.valueOf(this.signingCertificate));
        sb.append(", redirectUrl=").append(String.valueOf(this.redirectUrl));
        sb.append(", freeformAttributes=").append(String.valueOf(this.freeformAttributes));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Saml2IdentityProvider)) {
            return false;
        }
        Saml2IdentityProvider other = (Saml2IdentityProvider)((Object)o);
        return Objects.equals(this.metadataUrl, other.metadataUrl) && Objects.equals(this.metadata, other.metadata) && Objects.equals(this.signingCertificate, other.signingCertificate) && Objects.equals(this.redirectUrl, other.redirectUrl) && Objects.equals(this.freeformAttributes, other.freeformAttributes) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.metadataUrl == null ? 43 : this.metadataUrl.hashCode());
        result = result * 59 + (this.metadata == null ? 43 : this.metadata.hashCode());
        result = result * 59 + (this.signingCertificate == null ? 43 : this.signingCertificate.hashCode());
        result = result * 59 + (this.redirectUrl == null ? 43 : this.redirectUrl.hashCode());
        result = result * 59 + (this.freeformAttributes == null ? 43 : this.freeformAttributes.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="productType")
        private String productType;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="lifecycleState")
        private IdentityProvider.LifecycleState lifecycleState;
        @JsonProperty(value="inactiveStatus")
        private Long inactiveStatus;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonProperty(value="metadataUrl")
        private String metadataUrl;
        @JsonProperty(value="metadata")
        private String metadata;
        @JsonProperty(value="signingCertificate")
        private String signingCertificate;
        @JsonProperty(value="redirectUrl")
        private String redirectUrl;
        @JsonProperty(value="freeformAttributes")
        private Map<String, String> freeformAttributes;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder productType(String productType) {
            this.productType = productType;
            this.__explicitlySet__.add("productType");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder lifecycleState(IdentityProvider.LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder inactiveStatus(Long inactiveStatus) {
            this.inactiveStatus = inactiveStatus;
            this.__explicitlySet__.add("inactiveStatus");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public Builder metadataUrl(String metadataUrl) {
            this.metadataUrl = metadataUrl;
            this.__explicitlySet__.add("metadataUrl");
            return this;
        }

        public Builder metadata(String metadata) {
            this.metadata = metadata;
            this.__explicitlySet__.add("metadata");
            return this;
        }

        public Builder signingCertificate(String signingCertificate) {
            this.signingCertificate = signingCertificate;
            this.__explicitlySet__.add("signingCertificate");
            return this;
        }

        public Builder redirectUrl(String redirectUrl) {
            this.redirectUrl = redirectUrl;
            this.__explicitlySet__.add("redirectUrl");
            return this;
        }

        public Builder freeformAttributes(Map<String, String> freeformAttributes) {
            this.freeformAttributes = freeformAttributes;
            this.__explicitlySet__.add("freeformAttributes");
            return this;
        }

        public Saml2IdentityProvider build() {
            Saml2IdentityProvider model = new Saml2IdentityProvider(this.id, this.compartmentId, this.name, this.description, this.productType, this.timeCreated, this.lifecycleState, this.inactiveStatus, this.freeformTags, this.definedTags, this.metadataUrl, this.metadata, this.signingCertificate, this.redirectUrl, this.freeformAttributes);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(Saml2IdentityProvider model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("productType")) {
                this.productType(model.getProductType());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            if (model.wasPropertyExplicitlySet("inactiveStatus")) {
                this.inactiveStatus(model.getInactiveStatus());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            if (model.wasPropertyExplicitlySet("metadataUrl")) {
                this.metadataUrl(model.getMetadataUrl());
            }
            if (model.wasPropertyExplicitlySet("metadata")) {
                this.metadata(model.getMetadata());
            }
            if (model.wasPropertyExplicitlySet("signingCertificate")) {
                this.signingCertificate(model.getSigningCertificate());
            }
            if (model.wasPropertyExplicitlySet("redirectUrl")) {
                this.redirectUrl(model.getRedirectUrl());
            }
            if (model.wasPropertyExplicitlySet("freeformAttributes")) {
                this.freeformAttributes(model.getFreeformAttributes());
            }
            return this;
        }
    }
}

