/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.ast.expr;

import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.GroovyCodeVisitor;
import org.codehaus.groovy.ast.Variable;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.ExpressionTransformer;

public class VariableExpression
extends Expression
implements Cloneable,
Variable {
    public static final VariableExpression THIS_EXPRESSION = new VariableExpression("this");
    public static final VariableExpression SUPER_EXPRESSION = new VariableExpression("super");
    private int modifiers;
    private final String variable;
    private Variable accessedVariable;
    private final ClassNode originType;
    private boolean inStaticContext;
    private boolean isDynamicTyped;
    private boolean closureShare;
    private boolean useRef;

    public VariableExpression(String name, ClassNode type) {
        this.variable = name;
        this.originType = type;
        this.setType(ClassHelper.isPrimitiveType(type) ? ClassHelper.getWrapper(type) : type);
    }

    public VariableExpression(String name) {
        this(name, ClassHelper.dynamicType());
    }

    public VariableExpression(Variable av) {
        this(av.getName(), av.getOriginType());
        this.setModifiers(av.getModifiers());
        this.setAccessedVariable(av);
    }

    public VariableExpression clone() {
        VariableExpression copy = new VariableExpression(this.variable, this.originType);
        copy.setAccessedVariable(this.accessedVariable);
        copy.setModifiers(this.modifiers);
        copy.setClosureSharedVariable(this.closureShare);
        copy.setInStaticContext(this.inStaticContext);
        copy.setUseReferenceDirectly(this.useRef);
        copy.setSynthetic(this.isSynthetic());
        copy.setType(super.getType());
        copy.setSourcePosition(this);
        copy.copyNodeMetaData(this);
        return copy;
    }

    public void setAccessedVariable(Variable variable) {
        this.accessedVariable = variable;
    }

    @Override
    public void setClosureSharedVariable(boolean inClosure) {
        this.closureShare = inClosure;
    }

    public void setInStaticContext(boolean inStaticContext) {
        this.inStaticContext = inStaticContext;
    }

    public void setModifiers(int modifiers) {
        this.modifiers = modifiers;
    }

    @Override
    public void setType(ClassNode type) {
        super.setType(type);
        this.isDynamicTyped |= ClassHelper.isDynamicTyped(type);
    }

    public void setUseReferenceDirectly(boolean useRef) {
        this.useRef = useRef;
    }

    public Variable getAccessedVariable() {
        return this.accessedVariable;
    }

    @Override
    public Expression getInitialExpression() {
        return null;
    }

    @Override
    public boolean hasInitialExpression() {
        return false;
    }

    @Override
    public int getModifiers() {
        return this.modifiers;
    }

    @Override
    public String getName() {
        return this.variable;
    }

    @Override
    public String getText() {
        return this.variable;
    }

    @Override
    public ClassNode getType() {
        if (this.accessedVariable != null && this.accessedVariable != this) {
            return this.accessedVariable.getType();
        }
        return super.getType();
    }

    @Override
    public ClassNode getOriginType() {
        if (this.accessedVariable != null && this.accessedVariable != this) {
            return this.accessedVariable.getOriginType();
        }
        return this.originType;
    }

    @Override
    public boolean isClosureSharedVariable() {
        if (this.accessedVariable != null && this.accessedVariable != this) {
            return this.accessedVariable.isClosureSharedVariable();
        }
        return this.closureShare;
    }

    @Override
    public boolean isDynamicTyped() {
        if (this.accessedVariable != null && this.accessedVariable != this) {
            return this.accessedVariable.isDynamicTyped();
        }
        return this.isDynamicTyped;
    }

    @Override
    public boolean isInStaticContext() {
        if (this.accessedVariable != null && this.accessedVariable != this) {
            return this.accessedVariable.isInStaticContext();
        }
        return this.inStaticContext;
    }

    public boolean isSuperExpression() {
        return "super".equals(this.variable);
    }

    public boolean isThisExpression() {
        return "this".equals(this.variable);
    }

    public boolean isUseReferenceDirectly() {
        return this.useRef;
    }

    public String toString() {
        return super.toString() + "[variable: " + this.getName() + (String)(this.isDynamicTyped() ? "" : " type: " + this.getType()) + "]";
    }

    @Override
    public Expression transformExpression(ExpressionTransformer transformer) {
        return this;
    }

    @Override
    public void visit(GroovyCodeVisitor visitor) {
        visitor.visitVariableExpression(this);
    }
}

