﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/ec2/EC2_EXPORTS.h>
#include <aws/ec2/model/ResponseMetadata.h>
#include <aws/ec2/model/VpcEndpointConnection.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Xml {
class XmlDocument;
}  // namespace Xml
}  // namespace Utils
namespace EC2 {
namespace Model {
class DescribeVpcEndpointConnectionsResponse {
 public:
  AWS_EC2_API DescribeVpcEndpointConnectionsResponse() = default;
  AWS_EC2_API DescribeVpcEndpointConnectionsResponse(const Aws::AmazonWebServiceResult<Aws::Utils::Xml::XmlDocument>& result);
  AWS_EC2_API DescribeVpcEndpointConnectionsResponse& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Xml::XmlDocument>& result);

  ///@{
  /**
   * <p>Information about the VPC endpoint connections.</p>
   */
  inline const Aws::Vector<VpcEndpointConnection>& GetVpcEndpointConnections() const { return m_vpcEndpointConnections; }
  template <typename VpcEndpointConnectionsT = Aws::Vector<VpcEndpointConnection>>
  void SetVpcEndpointConnections(VpcEndpointConnectionsT&& value) {
    m_vpcEndpointConnectionsHasBeenSet = true;
    m_vpcEndpointConnections = std::forward<VpcEndpointConnectionsT>(value);
  }
  template <typename VpcEndpointConnectionsT = Aws::Vector<VpcEndpointConnection>>
  DescribeVpcEndpointConnectionsResponse& WithVpcEndpointConnections(VpcEndpointConnectionsT&& value) {
    SetVpcEndpointConnections(std::forward<VpcEndpointConnectionsT>(value));
    return *this;
  }
  template <typename VpcEndpointConnectionsT = VpcEndpointConnection>
  DescribeVpcEndpointConnectionsResponse& AddVpcEndpointConnections(VpcEndpointConnectionsT&& value) {
    m_vpcEndpointConnectionsHasBeenSet = true;
    m_vpcEndpointConnections.emplace_back(std::forward<VpcEndpointConnectionsT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The token to use to retrieve the next page of results. This value is
   * <code>null</code> when there are no more results to return.</p>
   */
  inline const Aws::String& GetNextToken() const { return m_nextToken; }
  template <typename NextTokenT = Aws::String>
  void SetNextToken(NextTokenT&& value) {
    m_nextTokenHasBeenSet = true;
    m_nextToken = std::forward<NextTokenT>(value);
  }
  template <typename NextTokenT = Aws::String>
  DescribeVpcEndpointConnectionsResponse& WithNextToken(NextTokenT&& value) {
    SetNextToken(std::forward<NextTokenT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const ResponseMetadata& GetResponseMetadata() const { return m_responseMetadata; }
  template <typename ResponseMetadataT = ResponseMetadata>
  void SetResponseMetadata(ResponseMetadataT&& value) {
    m_responseMetadataHasBeenSet = true;
    m_responseMetadata = std::forward<ResponseMetadataT>(value);
  }
  template <typename ResponseMetadataT = ResponseMetadata>
  DescribeVpcEndpointConnectionsResponse& WithResponseMetadata(ResponseMetadataT&& value) {
    SetResponseMetadata(std::forward<ResponseMetadataT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::Vector<VpcEndpointConnection> m_vpcEndpointConnections;
  bool m_vpcEndpointConnectionsHasBeenSet = false;

  Aws::String m_nextToken;
  bool m_nextTokenHasBeenSet = false;

  ResponseMetadata m_responseMetadata;
  bool m_responseMetadataHasBeenSet = false;
};

}  // namespace Model
}  // namespace EC2
}  // namespace Aws
